/*
 * Copyright (C) 2007 Gustavo Pichorim Boiko <boiko@mandriva.com>
 * Copyright (C) 2006 Laurent Montel <lmontel@mandriva.com>
 *
 * based on KDE3 HighColor Style (version 1.0)
 * Copyright (C) 2001-2002 Karol Szwed      <gallium@kde.org>
 *           (C) 2001-2002 Fredrik Hglund  <fredrik@kde.org>
 *
 * renderGradient() code adapted from the Plastik stype
 * Copyright (C) 2003 Sandro Giessl <ceebx@users.sourceforge.net>
 *
 * Drawing routines adapted from the KDE2 HCStyle,
 * Copyright (C) 2000 Daniel M. Duley       <mosfet@kde.org>
 *           (C) 2000 Dirk Mueller          <mueller@kde.org>
 *           (C) 2001 Martijn Klingens      <klingens@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License version 2 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <tqdict.h>
#include <tqdrawutil.h>
#include <tqpainter.h>
#include <tqpointarray.h>
#include <tqstyleplugin.h>
#include <tqprogressbar.h>

#include <tqcombobox.h>
#include <tqheader.h>
#include <tqmenubar.h>
#include <tqpushbutton.h>
#include <tqscrollbar.h>
#include <tqslider.h>
#include <tqtabbar.h>
#include <tqtoolbutton.h>
#include <tqtoolbar.h>
#include <tqpopupmenu.h>
#include <kstandarddirs.h>
#include <kdrawutil.h>
#include <kpixmapeffect.h>
#include <tqradiobutton.h>
#include <tqimage.h>
#include <tqcheckbox.h>
#include "ia_ora.h"
#include "ia_ora.moc"
#include "bitmaps.h"
#include <tqlistview.h>
#include <tqlistbox.h>
#include <kdebug.h>
//#define USE_CROSS 1

// -- Style Plugin Interface -------------------------
class ThemeMdvStylePlugin : public TQStylePlugin
{
public:
  ThemeMdvStylePlugin() {}
  ~ThemeMdvStylePlugin() {}

  TQStringList keys() const
  {
    return TQStringList() << "ia_ora";
  }

  TQStyle* create( const TQString& key )
  {
      if ( key == "ia_ora" )
          return new MandrivaStyle( );
      return 0;
  }
};

TQ_EXPORT_PLUGIN( ThemeMdvStylePlugin )
// ---------------------------------------------------


// ### Remove globals
TQBitmap menuBmp;

static bool scrollmin = false;
static bool scrollmax = false;


static const int itemFrame       = 1;
static const int itemHMargin     = 3;
static const int itemVMargin     = 0;
static const int arrowHMargin    = 6;
static const int rightBorder     = 12;
static const char* kdeToolbarWidget = "tde toolbar widget";
const int smallButMaxW    = 27;
const int smallButMaxH    = 20;

// ---------------------------------------------------------------------------
MandrivaStyle::MandrivaColorData::~MandrivaColorData()
{
}

// ---------------------------------------------------------------------------

MandrivaStyle::MandrivaStyle( )
    : TDEStyle( AllowMenuTransparency | FilledFrameWorkaround, WindowsStyleScrollBar )
      , m_dataCache (), formMode( false ),kickerMode(false)
{
    hoverWidget = 0L;
    hoverControl = HoverNone;
    m_dataCache.setAutoDelete(true);
    horizontalLine = 0;
    verticalLine = 0;

    // setup pixmap cache...
    pixmapCache = new TQIntCache<CacheEntry>(150000, 499);
    pixmapCache->setAutoDelete(true);
}


MandrivaStyle::~MandrivaStyle()
{
    delete pixmapCache;
    delete horizontalLine;
    delete verticalLine;
}


MandrivaStyle::MandrivaColorData *MandrivaStyle::realizeData (const TQColorGroup &cg) const
{
    MandrivaColorData *cdata;
    //define mandriva color
    cdata = new MandrivaColorData;
    cdata->spotColor = cg.highlight().rgb();

    //blue mdk color
    //cg.base() == white
    //G0 gb.background()
    //B2 gb.hightlight
    //Hardcode
    if ( cg.background() == TQColor( "#EFF3F7" ) )
    {
        //Be sure to use design color
        cdata->shades[0]=TQColor( "#EFF3F7" );
        cdata->shades[1]=TQColor( "#DFE7EF" );
        cdata->shades[2]=TQColor( "#CFD7DF" );
        cdata->shades[3]=TQColor( "#C7D3DF" );
        cdata->shades[4]=TQColor( "#B6C3CF" );
        cdata->shades[5]=TQColor( "#A6B2C7" );
        cdata->shades[6]=TQColor( "#8692A6" );
    }
    else
    {
        //create algo
        cdata->shades[0]=cg.background();
        cdata->shades[1]=cdata->shades[0].dark(107);
        cdata->shades[2]=cdata->shades[0].dark(115);
        cdata->shades[3]=cdata->shades[0].dark(117);
        cdata->shades[4]=cdata->shades[0].dark(131);
        cdata->shades[5]=cdata->shades[0].dark(144);
        cdata->shades[6]=cdata->shades[0].dark(178);

    }
    if ( cg.highlight() == TQColor("#4965AE" ) ) // Blue
    {
        cdata->blueMdkColor[0]=TQColor("#A6B6E7" );
        cdata->blueMdkColor[1]=TQColor("#8EA2CF" );
        cdata->blueMdkColor[2]=TQColor("#4965AE" );
        cdata->blueMdkColor[3]=TQColor("#415DA6" );
        cdata->blueMdkColor[4]=TQColor("#21459C" );
    }
    else if ( cg.highlight() == TQColor("#8EC7FF" ) ) // Arctic
    {
        cdata->blueMdkColor[0]=TQColor("#EFF7FF" );
        cdata->blueMdkColor[1]=TQColor("#C7DFFF" );
        cdata->blueMdkColor[2]=TQColor("#8EC7FF" );
        cdata->blueMdkColor[3]=TQColor("#79BEFF" );
        cdata->blueMdkColor[4]=TQColor("#69B6FF" );
    }
    else if ( cg.highlight() == TQColor("#7BAAE7" ) ) // Smooth
    {
        cdata->blueMdkColor[0]=TQColor("#CEE3FF" );
        cdata->blueMdkColor[1]=TQColor("#ADCFFF" );
        cdata->blueMdkColor[2]=TQColor("#7BAAE7" );
        cdata->blueMdkColor[3]=TQColor("#5A8AD6" );
        cdata->blueMdkColor[4]=TQColor("#427DC6" );
    }
    else if ( cg.highlight() == TQColor("#F7B610" ) ) // Orange
    {
        cdata->blueMdkColor[0]=TQColor("#FFDF10" );
        cdata->blueMdkColor[1]=TQColor("#FFCB10" );
        cdata->blueMdkColor[2]=TQColor("#F7B610" );
        cdata->blueMdkColor[3]=TQColor("#FFA208" );
        cdata->blueMdkColor[4]=TQColor("#F79600" );
    }
    else if ( cg.highlight() == TQColor("#CFD7DF" ) ) // Gray
    {
        cdata->blueMdkColor[0]=cdata->shades[1];
        cdata->blueMdkColor[1]=cdata->shades[2];
        cdata->blueMdkColor[2]=cdata->shades[3];
        cdata->blueMdkColor[3]=cdata->shades[4];
        cdata->blueMdkColor[4]=cdata->shades[5];
    }

    else
    {
        cdata->blueMdkColor[2]=cg.highlight();
        cdata->blueMdkColor[0]=cdata->blueMdkColor[2].light(150);
        cdata->blueMdkColor[1]=cdata->blueMdkColor[2].light(137);
        cdata->blueMdkColor[3]=cdata->blueMdkColor[2].dark(112);
        cdata->blueMdkColor[4]=cdata->blueMdkColor[2].dark(130);
    }

    if (cg.button() == cg.background())
    {
        for (int i=0; i < 7; ++i)
            cdata->buttonColor[i] = cdata->shades[i];
    }
    else if ( cg.button() == TQColor( "#EFF3F7" ) )
    {
        //Be sure to use design color
        cdata->buttonColor[0]=TQColor( "#EFF3F7" );
        cdata->buttonColor[1]=TQColor( "#DFE7EF" );
        cdata->buttonColor[2]=TQColor( "#CFD7DF" );
        cdata->buttonColor[3]=TQColor( "#C7D3DF" );
        cdata->buttonColor[4]=TQColor( "#B6C3CF" );
        cdata->buttonColor[5]=TQColor( "#A6B2C7" );
        cdata->buttonColor[6]=TQColor( "#8692A6" );
    }
    else
    {
        cdata->buttonColor[0]=cg.button();
        cdata->buttonColor[1]=cdata->buttonColor[0].dark(107);
        cdata->buttonColor[2]=cdata->buttonColor[0].dark(115);
        cdata->buttonColor[3]=cdata->buttonColor[0].dark(117);
        cdata->buttonColor[4]=cdata->buttonColor[0].dark(131);
        cdata->buttonColor[5]=cdata->buttonColor[0].dark(144);
        cdata->buttonColor[6]=cdata->buttonColor[0].dark(178);
    }

    return cdata;
}

/* We assume this seldom collides, since we can only cache one at a time */
static long hashColorGroup (const TQColorGroup &cg)
{
    return cg.button().rgb();// << 8 ^ cg.button().rgb();
}


const MandrivaStyle::MandrivaColorData *MandrivaStyle::lookupData (const TQColorGroup &cg) const
{
    MandrivaColorData *cdata;
    long h;
    TQIntCache<MandrivaColorData> *cache;

    h = hashColorGroup (cg);

    // Cast away the const crap
    // Nasty, but how else would i do it?
    cache = (TQIntCache<MandrivaColorData> *)&m_dataCache;

    cdata = cache->find(h);

    if (cdata == 0 || !cdata->isGroup(cg)) 
    {
        if (cdata != 0) 
        {
            cache->remove (h);
        }

        cdata = realizeData (cg);
        cache->insert (h, cdata);
    }

    return cdata;
}

void MandrivaStyle::getShade (const TQColorGroup &cg, int shadenr, TQColor &res) const
{
    const MandrivaColorData *cdata = lookupData(cg);

    res = cdata->shades[shadenr];
}

void MandrivaStyle::updateHoverControl(const TQPoint &pos, const TQStyleControlElementData &ceData, ControlElementFlags elementFlags)
{
    TQRegion repaint;
    enum Hover oldControl = hoverControl;
    hoverControl = HoverNone;

    if (!hoverWidget)
        return;

    if (hoverWidget->inherits("TQScrollBar"))
    {
        TQRect subline(querySubControlMetrics(CC_ScrollBar, ceData, elementFlags,
                                             SC_ScrollBarSubLine, TQStyleOption::Default, hoverWidget)),
              addline(querySubControlMetrics(CC_ScrollBar, ceData, elementFlags,
                                             SC_ScrollBarAddLine, TQStyleOption::Default, hoverWidget)),
              slider(querySubControlMetrics(CC_ScrollBar, ceData, elementFlags,
                                            SC_ScrollBarSlider, TQStyleOption::Default, hoverWidget));
        if (subline.contains(pos))
            hoverControl = HoverScrollBarSubLine;
        else if (addline.contains(pos))
            hoverControl = HoverScrollBarAddLine;
        else if (slider.contains(pos))
            hoverControl = HoverScrollBarSlider;

        if (hoverControl == HoverScrollBarSubLine 
            || oldControl == HoverScrollBarSubLine)
            repaint += subline;
        if (hoverControl == HoverScrollBarAddLine 
            || oldControl == HoverScrollBarAddLine)
            repaint += addline;
        if (hoverControl == HoverScrollBarSlider 
            || oldControl == HoverScrollBarSlider)
            repaint += slider;
    }
    else if (hoverWidget->inherits("TQComboBox"))
    {
        TQComboBox *cb = static_cast<TQComboBox*>(hoverWidget);
        // for not editable combo, this is not necessary
        if (!cb->editable())
            return;

        TQRect comboArrow(querySubControlMetrics(CC_ComboBox, ceData, elementFlags,
                                                SC_ComboBoxArrow, TQStyleOption::Default, hoverWidget)),
              comboEditField(querySubControlMetrics(CC_ComboBox, ceData, elementFlags,
                                                SC_ComboBoxEditField, TQStyleOption::Default, hoverWidget));

        if (comboArrow.contains(pos))
            hoverControl = HoverComboBoxArrow;
        else if (comboEditField.contains(pos))
            hoverControl = HoverComboBoxEdit;

        if (hoverControl == HoverComboBoxArrow
            || oldControl == HoverComboBoxArrow)
            repaint += comboArrow;
        if (hoverControl == HoverComboBoxEdit
            || oldControl == HoverComboBoxEdit)
            repaint += comboEditField;
    }
    // if we are still in the same subcontrol, return
    if (oldControl != hoverControl)
        hoverWidget->repaint(repaint, false);
}

void MandrivaStyle::applicationPolish(const TQStyleControlElementData &ceData, ControlElementFlags, void *ptr)
{
    if (ceData.widgetObjectTypes.contains("TQApplication")) {
        TQApplication *app = reinterpret_cast<TQApplication*>(ptr);
        if (!qstrcmp(app->argv()[0], "kicker")) {
            kickerMode = true;
        }
    }
}

void MandrivaStyle::polish(const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, void *ptr)
{
	if (ceData.widgetObjectTypes.contains("TQWidget")) {
		TQWidget *widget = reinterpret_cast<TQWidget*>(ptr);

		// Put in order of highest occurance to maximize hit rate
		if (   widget->inherits( "TQComboBox" )
			|| widget->inherits( "TQScrollBar" )
			|| widget->inherits( "TQHeader" )
			|| widget->inherits( "TQSlider" )
			|| widget->inherits( "TQCheckBox" )
			|| widget->inherits("TQSplitterHandle") )
		{
			installObjectEventHandler(ceData, elementFlags, ptr, this);
			if (widget->inherits( "TQScrollBar" ) || widget->inherits( "TQComboBox" ))
			   widget->setMouseTracking( true );
		}
		else if (widget->inherits("TQMenuBar")
				 || widget->inherits("TQPopupMenu") )
		{
			widget->setBackgroundMode(TQWidget::NoBackground);
		}
		else if (widget->inherits("TQPushButton") )
		{
			installObjectEventHandler(ceData, elementFlags, ptr, this);
			widget->setBackgroundMode( TQWidget::PaletteBackground );
		}
		else if ( widget->inherits( "TDEToolBarSeparator" ) || widget->inherits( "TQToolBarSeparator" ) )
		{
			widget->setBackgroundMode( TQWidget::PaletteBackground );
		}
		else if (widget->inherits("TQToolBarExtensionWidget"))
		{
			installObjectEventHandler(ceData, elementFlags, ptr, this);
		}
		else if ( widget->parentWidget() &&
				( ( widget->inherits( "TQListBox" ) && widget->parentWidget()->inherits( "TQComboBox" ) )
					|| widget->inherits( "TDECompletionBox" ) ) )
		{
			TQListBox* listbox = (TQListBox*) widget;
			listbox->setLineWidth( 1 );
			listbox->setBackgroundMode( NoBackground );
			installObjectEventHandler(ceData, elementFlags, ptr, this);
		}
		else if ( !qstrcmp( widget->name(), kdeToolbarWidget) )
		{
			widget->setBackgroundMode( NoBackground ); // We paint the whole background.
			installObjectEventHandler(ceData, elementFlags, ptr, this);
		}
	}

    TDEStyle::polish( ceData, elementFlags, ptr );
}


void MandrivaStyle::unPolish(const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, void *ptr)
{
	if (ceData.widgetObjectTypes.contains("TQWidget")) {
		TQWidget *widget = reinterpret_cast<TQWidget*>(ptr);

		TQFont f = TQApplication::font();
		TQApplication::setFont( f, TRUE ); // get rid of the special fonts for special widget classes

		if (   widget->inherits( "TQComboBox"  )
			|| widget->inherits("TQScrollBar")
			|| widget->inherits("TQHeader")
			|| widget->inherits( "TQSlider" )
			|| widget->inherits( "TQCheckBox" )
			|| widget->inherits("TQSplitterHandle"))
		{
			removeObjectEventHandler(ceData, elementFlags, ptr, this);
		}
		else if (   widget->inherits("TQMenuBar")
				 || widget->inherits("TQPopupMenu"))
		{
			widget->setBackgroundMode(TQWidget::PaletteBackground);
		}
		else if ( widget->inherits("TQPushButton") )
		{
			removeObjectEventHandler(ceData, elementFlags, ptr, this);
		}
		else if (widget->inherits("TQToolBarExtensionWidget"))
		{
			removeObjectEventHandler(ceData, elementFlags, ptr, this);
		}
		else if ( widget->parentWidget() &&
				  ( ( widget->inherits( "TQListBox" ) && widget->parentWidget()->inherits( "TQComboBox" ) )
					  || widget->inherits( "TDECompletionBox" ) ) )
		{
			TQListBox* listbox = (TQListBox*) widget;
			listbox->setLineWidth( 1 );
			listbox->setBackgroundMode( PaletteBackground );
			removeObjectEventHandler(ceData, elementFlags, ptr, this);
			widget->clearMask();
		}
		//For toolbar internal separators, return to button, too (can't use tqt_cast here since don't have access to the class)
		else if ( widget->inherits( "TDEToolBarSeparator" ) || widget->inherits( "TQToolBarSeparator" ) )
		{
			widget->setBackgroundMode( TQWidget::PaletteBackground );
		}
		else if ( !qstrcmp( widget->name(), kdeToolbarWidget) )
		{
			widget->setBackgroundMode( PaletteBackground );
			removeObjectEventHandler(ceData, elementFlags, ptr, this);
		}
	}

    TDEStyle::unPolish( ceData, elementFlags, ptr );
}

/* reimp. */
void MandrivaStyle::renderMenuBlendPixmap( KPixmap& pix, const TQColorGroup &cg,
                                           const TQPopupMenu* /* popup */ ) const
{
    TQColor col = cg.background();
    //FIXME !!!!!!!!!!!!!!!
#ifdef TQ_WS_X11 // Only draw menu gradients on TrueColor, X11 visuals
    if ( TQPaintDevice::x11AppDepth() >= 24 )
        KPixmapEffect::gradient( pix, col.light(120), col.dark(115), 
                                 KPixmapEffect::HorizontalGradient );
    else
#endif
    pix.fill( col );
}


void MandrivaStyle::drawHandle( const MandrivaColorData *cdata,
                                TQPainter *p,
                                const TQRect &r,
                                const TQColorGroup & /*cg*/,
                                SFlags flags,
                                const TQStyleOption& /*opt*/,
                                bool /*drawBorder*/ /*for the future remove it*/, bool drawGradient) const
{
    int x,y,width,height;
    r.rect(&x, &y, &width, &height);
    int i = 0;
    int delta=0;
    //fix for handle toolbar, otherwise it's not center
    if (!(flags & Style_Horizontal))
    {

        if ( drawGradient )
            renderGradient( p, TQRect(x+2,y+2,width-4, height-4),
                            cdata->shades[2], cdata->shades[0],false);
        if(width > 30)
        {
            delta = x + (width/2) - 11;
            for(i = 0; i < 3; i++)
            {
                drawHandlePoint (cdata,p, (delta + 9*i),
                                 y + TQMAX((height-4)/2,0));
            }
        }
        else
        {
            drawHandlePoint (cdata, p,  x + (width-4)/2 ,
                             y + TQMAX((height-4)/2,0));
        }
    }
    else
    {
        if( drawGradient )
            renderGradient(p, TQRect(x+2,y+2,width-4, height-4),
                           cdata->shades[0],cdata->shades[2], true);

        if(height > 30)
        {
            delta = y + (height / 2) - 11;
            for(i = 0; i < 3; i++)
            {
                drawHandlePoint (cdata, p, x + TQMAX((width-4)/2,0),
                                 delta+9*i);
            }
        }
        else
        {
            drawHandlePoint (cdata,p, x + TQMAX((width-4)/2,0),
                             y + (height-4) / 2);
        }
    }
}

void MandrivaStyle::drawGroupBox(const MandrivaColorData *cdata, const TQColorGroup & cg, TQPainter *p, const TQRect & r, bool /*active*/, bool sunken)const
{
    int x,y,w,h;
    x=r.x(); y=r.y(); w=r.width(); h=r.height();
    int x2 = x+w-1;
    int y2 = y+h-1;
    p->setPen(cdata->shades[2]);
    p->drawLine(x+1, y2, x2-1, y2);
    p->drawLine(x2, y+1, x2, y2-1);


    p->drawLine(x+1, y, x2-1, y);
    p->drawLine(x, y+1, x, y2-1);
    p->setPen( cg.background() );
    p->drawPoint( x, y );
    p->drawPoint( x, y2 );
    p->drawPoint( x2, y );
    p->drawPoint( x2, y2 );

    p->setPen( sunken ?cg.base():cdata->shades[1] );
    p->drawLine( x+1, y+1, x2-1, y+1 );
    p->drawLine( x+1, y+2, x+1, y2-2 );

    p->setPen( sunken ? cdata->shades[1] :cg.base() );
    p->drawLine( x+1, y2-1, x2-1, y2-1 );
    p->drawLine( x2-1, y+2, x2-1, y2-2 );
}

void MandrivaStyle::drawLineSeparator(const MandrivaColorData *cdata, 
                                      const TQColorGroup & cg, TQPainter *p, 
                                      const TQRect & r, bool horizontal, 
                                      bool /*active*/, bool /*sunken*/,
                                      bool skipOffset )const
{
    TQRect line1, line2;

    p->fillRect(r, cg.background());
    if (horizontal)
    {
        int offset = 0;

        // remove 5 pixels from each side of the line
        if (r.width() > 20 && skipOffset)
            offset = 3;

        // draw the separator in the middle of the given rect
        int middle = (r.top() + r.bottom()) / 2;
        line1 = TQRect(r.x() + offset, middle, r.width() - 2*offset, 1);
        line2 = TQRect(r.x() + offset, middle+1, r.width() - 2*offset, 1);
    }
    else
    {
        int offset = 0;

        // remove 5 pixels from each side of the line
        if (r.height() > 20 && skipOffset)
            offset = 3;

        // draw the separator in the middle of the given rect
        int middle = (r.left() + r.right()) / 2;
        line1 = TQRect(middle, r.y() + offset, 1, r.height() - 2*offset);
        line2 = TQRect(middle+1, r.y() + offset, 1, r.height() - 2*offset);
    }

    p->setPen(cdata->shades[2]);
    p->drawLine(line1.left(), line1.top(), line1.right(), line1.bottom());

    p->setPen( cg.base() );
    p->drawLine(line2.left(), line2.top(), line2.right(), line2.bottom());
}


void MandrivaStyle::drawFrame( const MandrivaColorData *cdata, const TQColorGroup & cg, TQPainter *p, const TQRect & r, bool active )const
{
    //use by checkbox,lineedit,spinbox,combobox
    int x,y,w,h;
    x=r.x(); y=r.y(); w=r.width(); h=r.height();
    int x2 = x+w-1;
    int y2 = y+h-1;

    p->setPen(cdata->shades[4]);
    p->drawLine(x+1, y2, x2-1, y2);
    p->drawLine(x2, y+1, x2, y2-1);

    //Change color if it's active
    if ( active )
        p->setPen( cdata->shades[5] );
    p->drawLine(x+1, y, x2-1, y);
    p->drawLine(x, y+1, x, y2-1);
    p->setPen( cg.background() );
    p->drawPoint( x, y );
    p->drawPoint( x, y2 );
    p->drawPoint( x2, y );
    p->drawPoint( x2, y2 );
}
// This function draws primitive elements as well as their masks.
void MandrivaStyle::drawPrimitive( PrimitiveElement pe,
                                   TQPainter *p,
                                   const TQStyleControlElementData &ceData,
                                   ControlElementFlags elementFlags,
                                   const TQRect &r,
                                   const TQColorGroup &cg,
                                   SFlags flags,
                                   const TQStyleOption& opt ) const
{
    int x, y, xw;
    x= r.x();
    y= r.y();
    xw = r.x()+r.width()-1;
    bool down = flags & Style_Down;
    bool on   = flags & Style_On;
    const MandrivaColorData *cdata = lookupData(cg);
    bool sunken = flags & Style_Sunken;

    switch(pe)
    {
    case PE_PanelTabWidget:
    {
        p->save();
        p->setPen(cdata->shades[4]);
        p->drawRect(r);
        p->restore();
        break;
    }
    case PE_FocusRect:
    {
        p->save();
        p->setPen(cdata->shades[6]);
        p->drawWinFocusRect( r );
        p->restore();
        break;
    }
    case PE_PanelMenuBar: // Menu
    {
        //FIXME
        p->fillRect(r, cg.brush(TQColorGroup::Background));

        int x2 = r.x()+r.width()-1;
        int y2 = r.y()+r.height()-1;

        p->setPen(cdata->shades[2]);
        p->drawLine(x, y2, x2, y2);

        break;
    }

    case PE_PanelDockWindow: // Toolbar
    {
        bool horiz = r.width() > r.height();

        //Here, we just draw the border.
        int x  = r.x();
        int y  = r.y();
        int x2 = r.x() + r.width()  - 1;
        int y2 = r.y() + r.height() - 1;
        int lw = opt.isDefault() ? pixelMetric(PM_DefaultFrameWidth, ceData, elementFlags)
                                 : opt.lineWidth();

        //FIXME
        if (lw)
        {
            //Gradient border colors.
            //(Same as in gradients.cpp)
            TQColor gradTop = cg.base();
            TQColor gradBot = cdata->shades[2];
            if (horiz)
            {
                //Top line
                p->setPen(gradTop);
                p->drawLine(x, y, x2, y);

                //Bottom line
                p->setPen(gradBot);
                p->drawLine(x, y2, x2, y2);
            }
            else
            {
                //Left line
                p->setPen(gradTop);
                p->drawLine(x, y, x, y2);

                //Right line
                p->setPen(gradBot);
                p->drawLine(x2, y, x2, y2);
            }
        }
        break;
    }
    case PE_DockWindowSeparator:
    {
        bool horiz = flags & Style_Horizontal;

        drawLineSeparator( cdata, cg, p, r, !horiz, true, sunken );
        break;
    }

    case PE_DockWindowResizeHandle:
    case PE_Splitter:
    {
        TQRect real(r);
        real.addCoords( 1, 0,0 ,0);
        TQColor color = (hoverWidget == p->device())?cdata->shades[1]:cg.background();
        p->fillRect( r, color );
        p->setPen( cg.background() );
        p->drawPoint( r.x(), 0 );
        p->drawPoint( r.width()-1, 0 );
        p->drawPoint( r.x(), r.height()-1 );
        p->drawPoint( r.width()-1, r.height()-1 );

        drawHandle( cdata, p,real,cg,flags,opt, false );
        break;
    }
    case PE_PanelLineEdit:
    {
        drawFrame( cdata, cg, p, r, true );
        break;
    }
    case PE_Panel: //TQListBox and co
    {
        if(kickerMode)
            break;
        p->save();
        p->setPen(cdata->shades[4]);
        p->drawRect(r);
        p->restore();
        break;
    }
    case PE_StatusBarSection:
    {
        p->fillRect(r, cg.background());
        break;
    }
    case PE_PanelPopup:
    case PE_WindowFrame:
    {
        int lw = /*opt.isDefault() ? pixelMetric(PM_DefaultFrameWidth, ceData, elementFlags)
                   : opt.lineWidth()*/1;
        if (lw == 1 || lw == 2)
        {
            TQPen oldPen = p->pen();
            int x,y,w,h;
            r.rect(&x, &y, &w, &h);
            int x2 = x+w-1;
            int y2 = y+h-1;
            p->setPen(sunken ? cg.light() : cdata->shades[2]);
            p->drawLine(x, y2, x2, y2);
            p->drawLine(x2, y, x2, y2);
            p->setPen(sunken ? cdata->shades[2] : cg.light());
            p->drawLine(x, y, x2, y);
            p->drawLine(x, y, x, y2);
            p->setPen(sunken ? cg.midlight() : cdata->shades[2]);
            p->drawLine(x+1, y2-1, x2-1, y2-1);
            p->drawLine(x2-1, y+1, x2-1, y2-1);
            p->setPen(sunken ? cdata->shades[2] : cg.midlight());
            p->drawLine(x+1, y+1, x2-1, y+1);
            p->drawLine(x+1, y+1, x+1, y2-1);
            if( lw == 2 )
            {
                p->setPen(sunken ? cg.midlight() : cdata->shades[5]);
                p->drawLine(x+2, y2-2, x2-2, y2-2);
                p->drawLine(x2-1, y+2, x2-2, y2-2);
                p->setPen(sunken ? cdata->shades[5] : cg.midlight());
                p->drawLine(x+2, y+2, x2-2, y+2);
                p->drawLine(x+2, y+2, x+2, y2-2);
            }
            p->setPen(oldPen);
        }
        else
            TDEStyle::drawPrimitive(pe, p, ceData, elementFlags, r, cg, flags, opt);
        break;
    }
    case  PE_GroupBoxFrame:
    {
        if ( opt.isDefault() || opt.lineWidth() <= 0 )
            break;
        drawGroupBox( cdata, cg, p, r, true,sunken );
        break;
    }
#if 0
    case PE_PanelGroupBox:
        drawPrimitive( PE_GroupBoxFrame, p, ceData, elementFlags, r, cg, flags, opt );
        break;
#endif
    case PE_Separator:
    {
        drawLineSeparator( cdata, cg, p, r, true, true, sunken );
        break;
    }
    case PE_HeaderArrow:
    {
        if ( flags & Style_Up )
            drawPrimitive( PE_ArrowUp, p, ceData, elementFlags, r, cg, Style_Enabled );
        else
            drawPrimitive( PE_ArrowDown, p, ceData, elementFlags, r, cg, Style_Enabled );
        break;
    }
    case PE_HeaderSection:
    {
        bool horizontal = true;
        bool isFirst = false;
        if (p && p->device()->devType() == TQInternal::Widget) {
            TQHeader* hdr = dynamic_cast<TQHeader*>(p->device());
            if (hdr)
            {
                horizontal = ( hdr->orientation() == Horizontal );
                isFirst = hdr->mapToIndex(hdr->sectionAt(r.x() ) ) == 0;
            }
        }
        int x,y,w,h;
        r.rect(&x, &y, &w, &h);
        TQPen oldPen = p->pen();

        //TODO verify it
        if (flags & Style_MouseOver)
            renderGradient( p, TQRect(x, y, w, h-1),
                            cdata->shades[0],cdata->shades[2], !horizontal );
        else if ( on )
            renderGradient(p, TQRect(x, y, w, h-1),
                           cdata->shades[0],cdata->shades[2], !horizontal );
        else if ( down )
            renderGradient(p, TQRect(x, y, w, h-1),
                           cdata->shades[2],cdata->shades[1], !horizontal );
        else
            renderGradient( p, TQRect(x, y, w, h-1),
                            cdata->shades[0],cdata->shades[2], !horizontal );

        //don't draw separator for first eleemtn
        if ( !isFirst )
        {
            drawLineSeparator(cdata, cg, p, TQRect(x,y,2,h), false, true, false, false);
        }
        p->setPen( oldPen );
        break;
    }
    case PE_ExclusiveIndicator:
    { //radiobutton
        bool enabled  = flags & Style_Enabled;
        p->setPen( cdata->shades[4] );
        p->setBrush( TQBrush( enabled  ? cg.base() : cdata->shades[0] ) );
        p->drawEllipse( r );
        bool specificBackground = excludeColor( cg.highlight(), enabled );

        if (!(flags & Style_Off))
        {
            if (flags & Style_On) //on
            {
                if ( specificBackground )
                    p->setPen( enabled ? cdata->shades[6]:cdata->shades[3] );
                else
                    p->setPen( enabled ? cdata->blueMdkColor[2]:cdata->shades[3] );
                p->drawLine( x+5, y+3, xw-5, y+3 );
                p->drawLine( x+4, y+4, xw-4, y+4 );
                p->drawLine( x+3, y+5, xw-3, y+5 );

                if ( specificBackground )
                    p->setPen( enabled ? cdata->shades[6]:cdata->shades[5] );
                else
                    p->setPen( enabled ? cdata->blueMdkColor[4]:cdata->shades[5] );


                p->drawLine( x+3, y+6, xw-3, y+6 );
                p->drawLine( x+4, y+7, xw-4, y+7);
                p->drawLine( x+5, y+8, xw-5, y+8 );
            }
        }
        break;
    }
    case PE_CheckListIndicator:
    {
        TQCheckListItem *item = opt.checkListItem();
        if(!item)
                return;
        int x = r.x(), y = r.y(), w = r.width(), h = r.width();
        drawPrimitive(PE_Indicator, p, ceData, elementFlags, TQRect(x-2, y-2 , w+3, h+3 ) , cg, flags );
        break;
    }
    //case PE_IndicatorMask:
    case PE_Indicator:
    { //checkbox
        bool enabled  = flags & Style_Enabled;

        //draw background use base color
        TQRect ar( x+1, y+1, x+11, y+10 );
        p->fillRect (ar, enabled  ? cg.base() : cdata->shades[0]);
        bool specificBackground = excludeColor( cg.highlight(), enabled );
        //TODO mouse over
        if (!(flags & Style_Off))
        {
            if (flags & Style_On) //on
            {
#ifdef USE_CROSS
                p->setPen( enabled ? cdata->blueMdkColor[2]:cdata->shades[3] );
                //TODO look at if we can use a qbitmap directly
                p->drawLine( x+2, y+2, x+3, y+2 );
                p->drawLine( x+2, y+3, x+4, y+3 );
                p->drawLine( x+3, y+4, x+5, y+4 );
                p->drawLine( x+4, y+5, x+8, y+5 );
                p->drawLine( x+9, y+2, x+10, y+2 );
                p->drawLine( x+8, y+3, x+10, y+3 );
                p->drawLine( x+7, y+4, x+9, y+4 );
                p->setPen( enabled ? cdata->blueMdkColor[4] : cdata->shades[5]);
                p->drawLine( x+4, y+6, x+8, y+6 );
                p->drawLine( x+3, y+7, x+5, y+7 );
                p->drawLine( x+2, y+8, x+4, y+8 );
                p->drawLine( x+2, y+9, x+3, y+9 );

                p->drawLine( x+9, y+9, x+10, y+9 );
                p->drawLine( x+8, y+8, x+10, y+8 );
                p->drawLine( x+7, y+7, x+9, y+7 );
#else
                if (TQApplication::reverseLayout()  )
                {
                    if ( specificBackground )
                        p->setPen( enabled ? cdata->shades[6]:cdata->shades[3] );
                    else
                        p->setPen( enabled ? cdata->blueMdkColor[2]:cdata->shades[3] );

                    p->drawPoint( x+2,y+2 );
                    p->drawLine( x+2,y+3,x+3,y+3 );
                    p->drawLine( x+2,y+4,x+4,y+4 );
                    p->drawLine( x+3,y+5,x+5,y+5 );
                    p->drawLine( x+4,y+6,x+6,y+6 );
                    p->drawPoint( x+10,y+5 );
                    p->drawLine( x+9,y+6,x+10,y+6 );

                    if ( specificBackground )
                        p->setPen( enabled ? TQt::black : cdata->shades[4]);
                    else
                        p->setPen( enabled ? cdata->blueMdkColor[4] : cdata->shades[4]);
                    p->drawLine( x+5,y+7,x+10,y+7 );
                    p->drawLine( x+6,y+8,x+9,y+8 );
                    p->drawLine( x+7,y+9,x+8,y+9 );

                }
                else
                {
                    if ( specificBackground )
                        p->setPen( enabled ? cdata->shades[6]:cdata->shades[3] );
                    else
                        p->setPen( enabled ? cdata->blueMdkColor[2]:cdata->shades[3] );
                    p->drawPoint( x+10,y+2 );
                    p->drawLine( x+9,y+3,x+10,y+3 );
                    p->drawLine( x+8,y+4,x+10,y+4 );
                    p->drawLine( x+7,y+5,x+9,y+5 );
                    p->drawLine( x+6,y+6,x+8,y+6 );
                    p->drawPoint( x+2,y+5 );
                    p->drawLine( x+2,y+6,x+3,y+6 );

                    if ( specificBackground )
                        p->setPen( enabled ? TQt::black : cdata->shades[4]);
                    else
                        p->setPen( enabled ? cdata->blueMdkColor[4] : cdata->shades[4]);

                    p->drawLine( x+2,y+7,x+7,y+7 );
                    p->drawLine( x+3,y+8,x+6,y+8 );
                    p->drawLine( x+4,y+9,x+5,y+9 );
                }
#endif
            }
            else //tristate
            {
                if ( specificBackground )
                    p->setPen( enabled ? cdata->shades[6] : cdata->shades[3]);
                else
                    p->setPen( enabled ? cdata->blueMdkColor[2] : cdata->shades[3]);

                p->drawLine( x+4, y+5, x+8, y+5 );
                p->drawLine( x+3, y+6, x+9, y+6 );
                if ( specificBackground )
                    p->setPen(  enabled ? TQt::black : cdata->shades[5]);
                else
                    p->setPen(  enabled ? cdata->blueMdkColor[4] : cdata->shades[5]);
                p->drawLine( x+4, y+7, x+8, y+7 );
            }
        }
        drawFrame( cdata, cg, p, r,true );
        break;
    }
    case PE_SizeGrip:
    {
        int y = r.y();
        int x2 = r.width();
        int y2 = r.height();
        p->setPen( cdata->shades[2] );
        p->drawPoint( x2, y );
        p->drawPoint( x2-1, y+1 );
        p->drawLine( x2-2, y+2, x2-1, y+2 );
        p->drawLine( x2-3, y+3, x2-1, y+3 );
        p->drawLine( x2-4, y+4, x2-1, y+4 );
        p->drawLine( x2-5, y+5, x2-1, y+5 );
        p->drawLine( x2-6, y+6, x2-1, y+6 );
        p->drawLine( x2-7, y+7, x2-2, y+7 );
        p->drawLine( x2-8, y+8, x2-3, y+8 );
        p->drawLine( x2-9, y+9, x2-4, y+9 );
        p->drawLine( x2-10, y+10, x2-6, y+10 );
        p->drawLine( x2-11, y+11, x2-9, y+11 );

        p->drawPoint( x2, y+12 );
        p->drawLine( x2-1, y+13,x2,y+13 );
        p->drawLine( x2-2, y+14,x2-1,y+14 );

        //TODO draw last point
        p->setPen( cdata->shades[3] );

        p->drawLine( x2, y+1, x2, y2-3 );
        p->drawPoint( x2-1, y+7 );
        p->drawLine( x2-2, y+8, x2-1, y+8 );
        p->drawLine( x2-3, y+9, x2-1, y+9 );
        p->drawLine( x2-5, y+10, x2-1, y+10 );
        p->drawLine( x2-8, y+11, x2-1, y+11 );
        p->drawLine( x2-12, y+12, x2-1, y+12 );
        p->drawLine( x2-13, y+13, x2-2, y+13 );
        p->drawLine( x2-14, y+14, x2-3, y+14 );

        p->setPen( cg.background() );
        p->drawPoint( x2, y2 );
        break;
    }
    case PE_SpinWidgetUp:
    case PE_SpinWidgetDown:
    {
        p->save();
        TQRect br;
        TQRect re( r );
        br.setRect( r.x() , r.y(), r.width()+1, r.height() );

        bool down = flags & Style_Down;
        bool on   = flags & Style_On;
        bool sunken = on || down;
        //Verify
        if ( on )
            renderGradient(p, br,
                           cdata->shades[0],cdata->shades[2], /*!horizontal*/ false);
        else if ( down )
            renderGradient(p, br,
                           cdata->shades[2],cdata->shades[1], /*!horizontal*/ false);
        else if( !sunken && (flags & Style_Enabled ))
            renderGradient(p, br,
                           cdata->shades[2],cdata->shades[0], /*!horizontal*/false );

        p->setPen( cdata->shades[5]);
        p->drawLine( br.x()-1, br.y(), br.x()-1, br.x()+r.height() ); //TODO verify +1 ???
        if ( pe == PE_SpinWidgetUp )
        {
            TQRect tmp( re );
            tmp.addCoords( -1, -2, 1, 1 );
            p->drawRect( tmp );
            //p->drawLine(br.x()-1, br.y()+br.height(), br.x()+br.width()-1, br.y()+br.height() ); //TODO verify +1 ???
            p->setPen( cg.background() );
            //p->drawPoint( tmp.width()-1, tmp.y()+1 ) ;
        }
        else
        {
            TQRect tmp( re );
            tmp.addCoords( -1, 0, 1, 1 );
            p->drawRect( tmp );

            //p->drawLine(br.x()-1, br.y(), br.x()+br.width()-1, br.y() ); //TODO verify +1 ???
            p->setPen( cg.background() );
            //p->drawPoint( tmp.width()-5, tmp.height()-2 ) ;
        }
        int w = r.width();
        int sw = w-4;
        if ( sw < 3 )
                break;
        else if ( !(sw & 1) )
               sw--;
        sw -= ( sw / 7 ) * 2;	// Empty border
        //TODO don't use same color for active/inactive
        p->setPen( cg.buttonText() );
        p->setBrush( cg.buttonText() );
        TQPointArray a;
        if ( pe == PE_SpinWidgetDown )
            a.setPoints(TQCOORDARRLEN(d_spinarrow), d_spinarrow);
        else
        {
            //move one pixel up
            re.addCoords( 0, 1,0,0);
            a.setPoints(TQCOORDARRLEN(u_spinarrow), u_spinarrow);
        }
        drawMandrivaArrow( a, p, re, cg, flags, opt );
        p->restore();
        break;
    }
    case PE_ScrollBarSlider:
    {
        bool horizontal = flags & Style_Horizontal;

        p->setPen( cdata->shades[5]);
        if( scrollmin && scrollmax )
        {
            TQRect tmpRect(r);
            if( !horizontal )
                tmpRect.addCoords(0,0,0,1);
            else
                tmpRect.addCoords(0,0,1,0);

            p->drawRect( tmpRect );
        }
        else
            p->drawRect( r );

        p->setPen( cdata->shades[0]);
        if ( horizontal )
        {
            p->drawLine( r.x(), r.y()+1, r.x(), r.y()+r.height()-2 );
            p->drawLine( r.x()+r.width(), r.y() +1 , r.x()+r.width(), r.y()+r.height()-2 );
        }
        else
        {
            p->drawLine( r.x()+1, r.y(), r.x()+r.width()-2, r.y() );
            p->drawLine( r.x()+1, r.y()+r.height()-1, r.x()+r.width()-2, r.y()+r.height()-1 );
        }
        // if the mouse is over the slider, the first half of the gradient changes
        bool mouseover = flags & Style_MouseOver;

        TQRect tmpRect(r), firstHalf, secondHalf;
        if (horizontal)
        {
            tmpRect.addCoords( 0, 1, 0, -1 );
            firstHalf = TQRect(tmpRect.x(), tmpRect.y(), tmpRect.width(), tmpRect.height()/2);
            secondHalf = TQRect(tmpRect.x(), tmpRect.height()/2 + 1, 
                               tmpRect.width(), tmpRect.height() - (tmpRect.height()/2));
        }
        else
        {
            tmpRect.addCoords( 1, 0, -1, 0 );
            firstHalf = TQRect(tmpRect.x(), tmpRect.y(), tmpRect.width()/2, tmpRect.height());
            secondHalf = TQRect(tmpRect.width()/2 + 1, tmpRect.y(),
                                tmpRect.width() - (tmpRect.width()/2), tmpRect.height());
        }

        // first half of the gradient
        //   horizontal scrollbars need vertical gradients (that's the reason 
        //   of the !horizontal as the last argument
        renderGradient(p, firstHalf, mouseover ? cdata->blueMdkColor[0] : cdata->blueMdkColor[1],
                       cdata->blueMdkColor[3], !horizontal); 

        // second half of the gradient
        renderGradient(p, secondHalf, cdata->blueMdkColor[4], cdata->blueMdkColor[2], !horizontal);

        // draw the points if !scrollmin or !scrollmax
        p->setPen( cg.background() );
        if (horizontal)
        {
            if ( !scrollmax )
            {
                p->drawPoint( tmpRect.x()+ tmpRect.width()-1, tmpRect.y() );
                p->drawPoint( tmpRect.x()+tmpRect.width()-1, tmpRect.y()+tmpRect.height()-1 );
            }
            if ( !scrollmin )
            {
                p->drawPoint( tmpRect.x(), tmpRect.y() );
                p->drawPoint( tmpRect.x(), tmpRect.height() );
            }
        }
        else
        {
            if ( !scrollmax )
            {
                p->drawPoint( tmpRect.x(), tmpRect.y()+tmpRect.height()-1 );
                p->drawPoint( tmpRect.width(), tmpRect.y()+tmpRect.height()-1 );
            }
            if ( !scrollmin )
            {
                p->drawPoint( tmpRect.x(), tmpRect.y() );
                p->drawPoint( tmpRect.width(), tmpRect.y() );
            }
        }

        break;
    }
    case PE_ScrollBarAddPage:
    case PE_ScrollBarSubPage: {
        int x, y, w, h;
        r.rect(&x, &y, &w, &h);
        int x2 = x+w-1;
        int y2 = y+h-1;

        p->setPen( cg.base());
        p->drawLine( x,y,x,y2 );
        p->drawLine( x2,y,x2,y2 );
        p->setPen( cdata->shades[5]);

        if (flags & Style_Horizontal) {
            p->drawLine(x, y, x2, y);
            p->drawLine(x, y2, x2, y2);
            p->fillRect( TQRect( x, y+1, w, h-2),cdata->shades[0] );
        } else {
            p->drawLine(x, y, x, y2);
            p->drawLine(x2, y, x2, y2);
            p->fillRect( TQRect( x+1, y, w-2, h),cdata->shades[0] );
        }
        break;
    }

    case PE_ScrollBarAddLine:
    case PE_ScrollBarSubLine:
    {
        int x,y,w,h;
        r.rect(&x, &y, &w, &h);
        bool sunken = on || down;
        bool mouseover = flags & Style_MouseOver;
        bool horizontal = flags & Style_Horizontal;

        // draw the bounding rect
        p->setPen( cdata->shades[5]);
        p->drawRect( r );

        // draw the gradient of the buttons
        if (w > 4 && h > 4) 
        {
            if (sunken)
                renderGradient(p, TQRect(x+1, y+1, w-2, h-2),
                               cdata->shades[2],cdata->shades[1], !horizontal);
            else if ( flags & Style_Enabled )
                renderGradient(p, TQRect(x+1, y+1, w-2, h-2),
                               cdata->shades[0], mouseover ? cdata->shades[1] : cdata->shades[2], !horizontal );
        }

        PrimitiveElement arrow;
        // draw some points to get a kind of rounded corner
        p->setPen( cg.background() );
        if (pe == PE_ScrollBarAddLine)
        {
            arrow = horizontal ? PE_ArrowRight : PE_ArrowDown;
            if ( horizontal )
            {
                p->drawPoint( r.x()+r.width()-1 ,r.y() );
                p->drawPoint( r.x()+r.width()-1 ,r.y()+r.height()-1 );
            }
            else
            {
                p->drawPoint( r.x() ,r.y()+r.height()-1 );
                p->drawPoint( r.x()+r.width()-1 ,r.y()+r.height()-1 );
            }
        }
        else
        {
            arrow = horizontal ? PE_ArrowLeft : PE_ArrowUp;
            if ( horizontal )
            {
                p->drawPoint( r.x() ,r.y() );
                p->drawPoint( r.x() ,r.y()+r.height()-1 );
            }
            else
            {
                p->drawPoint( r.x() ,r.y() );
                p->drawPoint( r.x()+r.width()-1 ,r.y() );
            }
        }

        // draw the arrow
        drawPrimitive( arrow, p, ceData, elementFlags, r, cg, flags );
        break;
    }

    // BUTTONS
    // -------------------------------------------------------------------
    case PE_ButtonDefault: //default button
    case PE_ButtonCommand: // action button
    case PE_ButtonDropDown:
    case PE_ButtonTool:
    {
        drawButton(cdata,r,p,cg,flags);
        break;
    }
    case PE_CheckMark:
    {
        if (menuBmp.isNull()) 
        {
            menuBmp = TQBitmap( 12 , 12, menu_check_bits, true);
            menuBmp.setMask(menuBmp);
        }
        int x,y;
        x=r.x(); y=r.y();

        if (!(flags & Style_Off)) 
        {
            p->setPen( on ? cdata->blueMdkColor[2] :  cg.highlightedText () );
            p->drawPixmap(x+3, y+3, menuBmp);
        }

        break;
    }

    //FIXME !!!!!!!!!!!!!!!!!!!! scrollbar
    case PE_ButtonBevel: 
    {
        int x,y,w,h;
        r.rect(&x, &y, &w, &h);
        bool sunken = on || down;
        int x2 = x+w-1;
        int y2 = y+h-1;

        // Outer frame
        p->setPen(cg.shadow());
        p->drawRect(r);

        // Bevel
        p->setPen(sunken ? cg.mid() : cg.light());
        p->drawLine(x+1, y+1, x2-1, y+1);
        p->drawLine(x+1, y+1, x+1, y2-1);
        p->setPen(sunken ? cg.light() : cg.mid());
        p->drawLine(x+2, y2-1, x2-1, y2-1);
        p->drawLine(x2-1, y+2, x2-1, y2-1);
        if (w > 4 && h > 4) {
            if (sunken)
                p->fillRect(x+2, y+2, w-4, h-4, cg.button());
            /*else
              renderGradient( p, TQRect(x+2, y+2, w-4, h-4),
              cg.button(), flags & Style_Horizontal );*/
        }
        break;
    }

    default:
    {
        if (pe >= PE_ArrowUp && pe <= PE_ArrowLeft)
        {
            TQPointArray a;
            //array point define into bitmap.h
            switch(pe) {
            case PE_ArrowUp:
                a.setPoints(TQCOORDARRLEN(u_arrow), u_arrow);
                break;

            case PE_ArrowDown:
                a.setPoints(TQCOORDARRLEN(d_arrow), d_arrow);
                break;

            case PE_ArrowLeft:
                a.setPoints(TQCOORDARRLEN(l_arrow), l_arrow);
                break;

            default:
                a.setPoints(TQCOORDARRLEN(r_arrow), r_arrow);
            }
            drawMandrivaArrow( a, p, r, cg, flags, opt );
        }
        else
            TDEStyle::drawPrimitive( pe, p, ceData, elementFlags, r, cg, flags, opt );
    }
    } //switch
}

void MandrivaStyle::drawMandrivaArrow( TQPointArray a, TQPainter *p,
                                       const TQRect &r,
                                       const TQColorGroup &cg,
                                       SFlags flags,
                                       const TQStyleOption& /*opt*/ ) const
{
    TQPen oldPen = p->pen();
    a.translate( r.x() + r.width() / 2, r.y() + r.height() / 2 );
    p->setPen(flags & Style_Enabled ? cg.buttonText() : cg.mid() );
    p->drawLineSegments( a );
    p->setPen( oldPen ); // restore pen
}

void MandrivaStyle::drawTDEStylePrimitive( TDEStylePrimitive pe,
                                         TQPainter* p,
                                         const TQStyleControlElementData &ceData,
                                         ControlElementFlags elementFlags,
                                         const TQRect &r,
                                         const TQColorGroup &cg,
                                         SFlags flags,
                                         const TQStyleOption &opt,
                                         const TQWidget* widget) const
{
    const MandrivaColorData *cdata = lookupData(cg);
    switch(pe)
    {
    // GENERAL/KICKER HANDLE
    // -------------------------------------------------------------------
    case KPE_GeneralHandle:
    {
        drawHandle( cdata, p,r,cg,flags,opt,false );
        break;
    }

    // TOOLBAR HANDLE
    // -------------------------------------------------------------------
    case KPE_ToolBarHandle:
    {
        TQRect real(r);
        real.addCoords( -1, 0,0,0);
        drawHandle( cdata, p,r,cg,flags,opt,true );
        break;
    }
    // SLIDER GROOVE
    // -------------------------------------------------------------------
    case KPE_SliderGroove: 
    {
        const TQSlider* sl = static_cast< const TQSlider* >( widget );
        bool horizontal = sl->orientation() == Horizontal;
        //TODO fixme
        p->fillRect( TQRect( r.x()+1, r.y()+1, r.width()-2, r.height()-2 ),cdata->shades[0] );
        p->setPen( cdata->shades[1] );

        int pos = sl->sliderStart();

        if ( horizontal )
        {
            //bidi
            if (TQApplication::reverseLayout() )
                p->fillRect( TQRect( pos, 1, r.right(), r.height()-2 ),cdata->shades[3] );
            else
                p->fillRect( TQRect( 1, 1, pos, r.height()-2 ),cdata->shades[3] );
            for ( int i = 12; i < r.width() ; )
            {
                p->drawLine( i, r.y()+1, i, r.height()-2 );
                i+=12;
            }
        }
        else
        {
            p->fillRect( TQRect( 1, pos, r.width()-2, r.height() ),cdata->shades[3] );
            for ( int i = 12; i < r.height() ; )
            {
                p->drawLine( r.x(), i, r.width(), i );
                i+=12;
            }
        }
        drawFrame( cdata, cg, p, r,true /*flags ? */);
        break;
    }

    // SLIDER HANDLE
    // -------------------------------------------------------------------
    case KPE_SliderHandle: 
    {
        const TQSlider* sl = static_cast< const TQSlider* >( widget );
        bool horizontal = sl->orientation() == Horizontal;
        bool mouseOver = (widget == hoverWidget);
        int x = r.x();
        int y = r.y();
        int x2 = r.right();
        int y2 = y+r.height();
        p->setPen( mouseOver ? cdata->blueMdkColor[1] : cdata->blueMdkColor[2]);
        if ( horizontal )
        {
            p->drawLine( x+1, y, x2-1, y );
            p->drawLine( x, y+1, x2, y+1 );
            p->drawLine( x, y+2, x2, y+2 );

            p->setPen( mouseOver ? cdata->blueMdkColor[2] : cdata->blueMdkColor[4]);
            p->drawLine( x, y+4, x2, y+4 );
            p->drawLine( x, y+3, x2, y+3 );
            p->drawLine( x+1, y+5, x2-1, y+5 );

            //draw cross
            int newposx = x+r.width()/2;

            p->drawLine( newposx-1, y+1, newposx+1,y+1 );
            p->drawLine( newposx-2, y+2, newposx+2,y+2 );

            p->setPen(  mouseOver ? cdata->blueMdkColor[1] : cdata->blueMdkColor[2]);
            p->drawLine( newposx-2, y+3, newposx+2,y+3 );
            p->drawLine( newposx-1, y+4, newposx+1,y+4 );
        }
        else //test into kmix
        {
            p->drawLine( x, y+1, x, y2-1 );
            p->drawLine( x+1, y, x+1, y2 );
            p->drawLine( x+2, y, x+2, y2 );


            p->setPen( mouseOver ? cdata->blueMdkColor[2] : cdata->blueMdkColor[4]);
            p->drawLine( x+3, y, x+3, y2 );
            p->drawLine( x+4, y, x+4, y2 );
            p->drawLine( x+5, y+1, x+5, y2-1 );


            //draw cross
            int newposy = y+r.height()/2;

            p->drawLine( x+1, newposy-1, x+1, newposy+1);
            p->drawLine( x+2, newposy-2, x+2, newposy+2);

            p->setPen(  mouseOver ? cdata->blueMdkColor[1] : cdata->blueMdkColor[2]);
            p->drawLine( x+3, newposy-2, x+3, newposy+2);
            p->drawLine( x+4, newposy-1, x+4, newposy+1);

        }
        break;
    }
    // copied and slightly modified from TDEStyle.
    case KPE_ListViewBranch: 
    {
        // Typical Windows style listview branch element (dotted line).

        // Create the dotline pixmaps if not already created
        if ( !verticalLine )
        {
            // make 128*1 and 1*128 bitmaps that can be used for
            // drawing the right sort of lines.
            verticalLine   = new TQBitmap( 1, 129, true );
            horizontalLine = new TQBitmap( 128, 1, true );
            TQPointArray a( 64 );
            TQPainter p2;
            p2.begin( verticalLine );

            int i;
            for( i=0; i < 64; i++ )
                a.setPoint( i, 0, i*2+1 );
            p2.setPen( cdata->shades[4] );
            p2.drawPoints( a );
            p2.end();
            TQApplication::flushX();
            verticalLine->setMask( *verticalLine );

            p2.begin( horizontalLine );
            for( i=0; i < 64; i++ )
                a.setPoint( i, i*2+1, 0 );
            p2.setPen( cdata->shades[4] );
            p2.drawPoints( a );
            p2.end();
            TQApplication::flushX();
            horizontalLine->setMask( *horizontalLine );
        }

        p->setPen( cg.mid() );

        if (flags & Style_Horizontal)
        {
            int point = r.x();
            int other = r.y();
            int end = r.x()+r.width();
            int thickness = r.height();

            while( point < end )
            {
                int i = 128;
                if ( i+point > end )
                    i = end-point;
                p->drawPixmap( point, other, *horizontalLine, 0, 0, i, thickness );
                point += i;
            }

        } 
        else 
        {
            int point = r.y();
            int other = r.x();
            int end = r.y()+r.height();
            int thickness = r.width();
            int pixmapoffset = (flags & Style_NoChange) ? 0 : 1;	// ### Hackish

            while( point < end )
            {
                int i = 128;
                if ( i+point > end )
                    i = end-point;
                p->drawPixmap( other, point, *verticalLine, 0, pixmapoffset, thickness, i );
                point += i;
            }
        }

        break;
    }
    default:
        TDEStyle::drawTDEStylePrimitive( pe, p, ceData, elementFlags, r, cg, flags, opt, widget);
    }
}

void MandrivaStyle::drawControl( ControlElement element,
                                 TQPainter *p,
                                 const TQStyleControlElementData &ceData,
                                 ControlElementFlags elementFlags,
                                 const TQRect &r,
                                 const TQColorGroup &cg,
                                 SFlags flags,
                                 const TQStyleOption& opt,
                                 const TQWidget *widget ) const
{
    const MandrivaColorData *cdata = lookupData(cg);
    switch (element)
    {
    case CE_CheckBox: 
    {
        drawPrimitive (PE_Indicator, p, ceData, elementFlags, r, cg, flags);
        break;
    }
    //progressbar
    case CE_ProgressBarContents: 
    {
        const TQProgressBar* pb = (const TQProgressBar*)widget;
        TQRect backend = subRect(SR_ProgressBarContents, ceData, elementFlags, widget);
        double progress = pb->progress();
        bool reverse = TQApplication::reverseLayout();
        int steps = pb->totalSteps();

        if (!pb || !backend.isValid())
            return;
        //necessary to fill all background
        //TODO fix it
        p->fillRect(backend , cg.background() );

        //draw border
        drawPrimitive( PE_PanelLineEdit, p, ceData, elementFlags, r, cg );

        TQRect cr(backend);
        cr.addCoords( 1, 1, -2, -2 );

        // Draw progress bar gradient
        if (progress > 0 || steps == 0) 
        {
            double pg = (steps == 0) ? 0.1 : progress / steps;
            int width = TQMIN(cr.width(), (int)(pg * cr.width()));
            if (steps == 0)
                width = TQMIN(width,20); //Don't cross squares

            if (steps == 0)
            { //Busy indicator

                if (width < 1) width = 1; //A busy indicator with width 0 is kind of useless

                int remWidth = cr.width() - width; //Never disappear completely
                if (remWidth <= 0) remWidth = 1; //Do something non-crashy when too small...

                int pstep =  int(progress) % ( 2 *  remWidth );

                if ( pstep > remWidth ) 
                {
                    //Bounce about.. We're remWidth + some delta, we want to be remWidth - delta...
                    // - ( (remWidth + some delta) - 2* remWidth )  = - (some deleta - remWidth) = remWidth - some delta..
                    pstep = - (pstep - 2 * remWidth );
                }
                if( reverse )
                    renderGradient(p, TQRect(cr.x() + cr.width() - width - pstep, cr.y(), width, cr.height()),
                                   cdata->shades[2],cdata->shades[1], false);
                else
                    renderGradient(p, cr,
                                   cdata->shades[2],cdata->shades[1], false);
                p->setPen(cdata->shades[5]);
                p->drawLine( backend.x(), backend.y(), backend.width()+1, backend.y());
                p->drawLine( backend.x(), backend.y(), backend.x(), backend.height());
                return;

            }
            if( reverse )
            {
                //convert it as after
                //TODO Verify it
                TQPixmap gradient(1, cr.height()+1);
                TQPainter painter(&gradient);
                KPixmap tempPixmap;
                tempPixmap.resize(1, cr.height()/2+1);
                KPixmapEffect::gradient(tempPixmap,
                                        cdata->blueMdkColor[1],
                                        cdata->blueMdkColor[3],
                                        KPixmapEffect::VerticalGradient);
                painter.drawPixmap(0,0, tempPixmap);
                tempPixmap.resize(1, cr.height()+1);
                KPixmapEffect::gradient(tempPixmap,
                                        cdata->blueMdkColor[4],
                                        cdata->blueMdkColor[2],
                                        KPixmapEffect::VerticalGradient);
                painter.drawPixmap(0, cr.height()/2 +1, tempPixmap);
                painter.end();
                TQRect tmp( cr.width()-width+1, cr.y(),width+1,cr.height() );
                tmp.addCoords( 0, 0, 0, 1 );
                p->drawTiledPixmap( tmp , gradient );
                bool changed = false;
                p->setPen( cdata->shades[1]);
                for ( int i = 12; i < cr.width() ; )
                {
                    if ( !changed && ( i >cr.width() -width ) )
                    {
                        p->setPen( cdata->blueMdkColor[2] );
                        changed = true;
                    }
                    p->drawLine( i, r.y()+1, i, r.height()-2 );
                    i+=12;
                }
                p->setPen(cg.background() );
                p->drawPoint( cr.width() -width +1, r.y()+1 );
                p->drawPoint( cr.width() -width + 1,  r.height()-2 );

            }
            else
            {
                TQPixmap gradient(1, cr.height()+1);
                TQPainter painter(&gradient);
                KPixmap tempPixmap;
                tempPixmap.resize(1, cr.height()/2+1);
                KPixmapEffect::gradient(tempPixmap,
                                        cdata->blueMdkColor[1],
                                        cdata->blueMdkColor[3],
                                        KPixmapEffect::VerticalGradient);
                painter.drawPixmap(0,0, tempPixmap);
                tempPixmap.resize(1, cr.height()+1);
                KPixmapEffect::gradient(tempPixmap,
                                        cdata->blueMdkColor[4],
                                        cdata->blueMdkColor[2],
                                        KPixmapEffect::VerticalGradient);
                painter.drawPixmap(0, cr.height()/2 +1, tempPixmap);
                painter.end();
                TQRect tmp( cr.x(), cr.y(),width-1,cr.height() );
                tmp.addCoords( 0, 0, 0, 1 );
                p->drawTiledPixmap( tmp , gradient );
                bool changed = false;
                p->setPen( cdata->blueMdkColor[2] );
                for ( int i = 12; i < cr.width() ; )
                {
                    if ( !changed && ( i >width ) )
                    {
                        p->setPen( cdata->shades[1] );
                        changed = true;
                    }
                    p->drawLine( i, r.y()+1, i, r.height()-2 );
                    i+=12;
                }
                p->setPen(cg.background() );
                p->drawPoint( width-1, r.y()+1 );
                p->drawPoint( width-1,  r.height()-2 );
            }
        }
        break;
    }
    case CE_ProgressBarLabel:
    {
        const TQProgressBar * pb = (const TQProgressBar *) widget;
        const int unit_width = pixelMetric( PM_ProgressBarChunkWidth, ceData, elementFlags, pb );
        int u = r.width() / unit_width;
        int p_v = pb->progress();
        int t_s = pb->totalSteps();
        if ( u > 0 && pb->progress() >= INT_MAX / u && t_s >= u ) 
        {
            // scale down to something usable.
            p_v /= u;
            t_s /= u;
        }
        // TQColor("#4965AE" ) powerpack
        if ( pb->percentageVisible() && pb->totalSteps() ) 
        {
            int nu = ( u * p_v + t_s/2 ) / t_s;
            int x = unit_width * nu;
            if (pb->indicatorFollowsStyle() || pb->centerIndicator()) 
            {
                if(cg.highlight() == TQColor("#4965AE" ))
                    p->setPen( TQColor("#FFFFFF"));
                else
                    p->setPen( TQColor( "#000000" ) );

                p->setClipRect( r.x(), r.y(), x, r.height() );
                p->drawText( r, AlignCenter | SingleLine, pb->progressString() );

                if ( pb->progress() != pb->totalSteps() ) 
                {
                    p->setClipRect( r.x() + x, r.y(), r.width() - x, r.height() );
                    //second part of progress bar => black
                    p->setPen( /*cg.highlight()*/TQColor( "#000000" ) );
                    p->drawText( r, AlignCenter | SingleLine, pb->progressString() );
                }
            }
            else
            {
                if(cg.highlight() == TQColor("#4965AE" ))
                    p->setPen( TQColor("#FFFFFF"));
                else
                    p->setPen( TQColor( "#000000" ) );
                p->drawText( r, AlignCenter | SingleLine, pb->progressString() );
            }
        }
        break;
    }
    case CE_ToolButtonLabel:
    {
        TDEStyle::drawControl(element, p, ceData, elementFlags, r, cg, flags, opt, widget);
        break;
    }

    case CE_MenuBarEmptyArea:
    case CE_DockWindowEmptyArea:
    {
        p->fillRect(r, cg.background() );
        break;
    }
    case CE_TabBarTab:
    {
        const TQTabBar* tb = static_cast< const TQTabBar* >( widget );
        int x, y, xw, yh;
        int offset= 0;
        x= r.x();
        y= r.y();
        //verify it
        xw = r.x()+r.width()-1;
        yh = r.y()+r.height()-1;

        //necessary to define type of tab
        TabPosition pos;
        if (tb->count() == 1) 
            pos = Single;
        else if ((tb->indexOf(opt.tab()->identifier()) == 0))
            pos = First;
        else if (tb->indexOf(opt.tab()->identifier()) == tb->count() - 1)
            pos = Last;
        else
            pos = Middle;
        
        bool bottom = tb->shape() == TQTabBar::RoundedBelow ||
                      tb->shape() == TQTabBar::TriangularBelow;

        if ( !bottom )
        {
            if (flags & Style_Selected )
            {
                p->fillRect( r, tb->palette().active().brush( TQColorGroup::Background ));
                //blue-2
                p->setPen( cdata->blueMdkColor[2]);
                p->drawLine( x+2, y, xw-2, y );
                p->drawLine( x+1, y+1, xw-1, y+1 );
                //blue-4
                p->setPen( cdata->blueMdkColor[4] );
                p->drawLine( x, y+2, xw, y+2 );
                p->drawLine( x, y+3, xw, y+3 );
                p->setPen( cdata->shades[4] );
                p->drawLine( xw,y+4,xw,yh);
                if ( pos==First )
                    p->drawLine( x,y+4,x,yh);
                else if ( ( pos==Last || pos == Single ) && TQApplication::reverseLayout() )
                    p->drawLine( xw, y+4, xw, yh );
            }
            else
            {
                offset = 3;
                //grey1
                p->fillRect( TQRect(x,y+offset,r.width()-1,yh), cdata->shades[1]);
                //grey5
                p->setPen( cdata->shades[5]);
                p->drawLine( x+2,y+offset-1,xw-2,y+offset-1);
                p->drawPoint(x+1, y+offset );
                p->drawPoint(xw-1, y+offset );
                p->drawLine( xw, y+offset+1, xw, yh );
                p->drawLine( x, y+offset+1, x, yh );
                p->setPen( cdata->shades[4]);
                p->drawLine( x, yh, xw,yh);
            }
        }
        else
        {
            if (flags & Style_Selected )
            {
                p->fillRect( r, tb->palette().active().brush( TQColorGroup::Background ));

                p->setPen( cdata->blueMdkColor[2] );
                p->drawLine( x, yh-3, xw, yh-3 );
                p->drawLine( x, yh-2, xw, yh-2 );

                p->setPen( cdata->blueMdkColor[4] );
                p->drawLine( x+1, yh-1, xw-1, yh-1 );
                p->drawLine( x+2, yh, xw-2, yh );
                p->setPen( cdata->shades[4] );
                p->drawLine( xw,y,xw,yh-4);
                if ( pos==First )
                    p->drawLine( x,y,x,yh-4);
                else if ( ( pos==Last || pos == Single ) && TQApplication::reverseLayout() )
                    p->drawLine( x, y, x, yh-4 ); //CHECK
            }
            else
            {
                offset = 3;
                //grey1
                p->fillRect( TQRect(x,y,r.width()-1,yh-offset), cdata->shades[1]);
                //grey5
                p->setPen( cdata->shades[5]);

                p->drawLine( x+2,yh-offset+1,xw-2,yh-offset+1);
                p->drawPoint(x+1, yh-offset );
                p->drawPoint(xw-1, yh-offset );
                p->drawLine( xw, y, xw, yh-4 );
                p->drawLine( x, y, x, yh-4 );
                p->setPen( cdata->shades[4]);
                p->drawLine( x, y, xw,y);
            }
        }
        break;
    }
    //CHECK
    case CE_MenuBarItem:
    {
        TQMenuItem *mi = opt.menuItem();

        bool active  = flags & Style_Active;
        bool focused = flags & Style_HasFocus;
        bool down = flags & Style_Down;

        TQColor textColor = cg.text();
        if ( active && focused && down )
        {
            //top half
            TQRect half_rect = r;
            half_rect.setHeight(r.height()/2);
            renderGradient(p, half_rect, cdata->blueMdkColor[1], cdata->blueMdkColor[3], false);
            //bottom half
            half_rect.setHeight(r.height() - half_rect.height());
            half_rect.moveBottom(r.bottom());
            renderGradient(p, half_rect, cdata->blueMdkColor[4], cdata->blueMdkColor[2], false);
            textColor = cg.highlightedText();
            // create the fake rounded corners
            TQPen oldPen = p->pen();
            p->setPen(cg.background());
            p->drawPoint(r.topLeft());
            p->drawPoint(r.topRight());
            p->drawPoint(r.bottomLeft());
            p->drawPoint(r.bottomRight());
            p->setPen(oldPen);
        }
        else
            renderGradient(p, r, cg.background(), cg.background(),false);

        drawItem( p, r, AlignCenter | AlignVCenter | ShowPrefix
                  | DontClip | SingleLine, cg, flags & Style_Enabled,
                  mi->pixmap(), mi->text(), -1, &textColor );

        break;
    }


// POPUPMENU ITEM
// -------------------------------------------------------------------
    case CE_PopupMenuItem:
    {
        const TQPopupMenu *popupmenu = (const TQPopupMenu *) widget;

        TQMenuItem *mi = opt.menuItem();
        if ( !mi )
        {
            // Don't leave blank holes if we set NoBackground for the TQPopupMenu.
            // This only happens when the popupMenu spans more than one column.
            if (! (widget->erasePixmap() && !widget->erasePixmap()->isNull()) )
                p->fillRect(r, cg.brush(TQColorGroup::Background) );
            break;
        }

        int  tab        = opt.tabWidth();
        int  checkcol   = opt.maxIconWidth();
        bool enabled    = mi->isEnabled();
        bool checkable  = popupmenu->isCheckable();
        bool active     = flags & Style_Active;
        bool etchtext   = styleHint( SH_EtchDisabledText, ceData, elementFlags );
        bool reverse    = TQApplication::reverseLayout();
        int x, y, w, h;
        r.rect( &x, &y, &w, &h );

        if ( checkable )
            checkcol = TQMAX( checkcol, 20 );

        // Are we a menu item separator?
        if ( mi->isSeparator() )
        {
            drawLineSeparator( cdata, cg, p, r, true, active, false );
            break;
        }
        // Draw the menu item background
        if( active && (flags & Style_Enabled))
        {
           //top half
            TQRect half_rect = r;
            half_rect.setHeight(r.height()/2);
            renderGradient(p, half_rect, cdata->blueMdkColor[1], cdata->blueMdkColor[3], false);
            //bottom half
            half_rect.setHeight(r.height() - half_rect.height());
            half_rect.moveBottom(r.bottom());
            renderGradient(p, half_rect, cdata->blueMdkColor[4], cdata->blueMdkColor[2], false);
            // create the fake rounded corners
            TQPen oldPen = p->pen();
            p->setPen(cg.background());
            p->drawPoint(r.topLeft());
            p->drawPoint(r.topRight());
            p->drawPoint(r.bottomLeft());
            p->drawPoint(r.bottomRight());
            p->setPen(oldPen);
        }

        // Draw the transparency pixmap
        else if ( widget->erasePixmap() && !widget->erasePixmap()->isNull() )
            p->drawPixmap( x, y, *widget->erasePixmap(), x, y, w, h );
        // Draw a solid background
        else
            p->fillRect( r, cg.background() );


        // Do we have an icon?
#if 0
        if ( (  (widget && !qstrcmp(widget->name(),"KMenu" )) ||
                (widget->parentWidget() && !qstrcmp(widget->parentWidget()->name(),"KMenu" )) )
             &&
#endif
             if( mi->iconSet() )
             {
                 TQIconSet::Mode mode;
                 TQRect cr = visualRect( TQRect(x, y, checkcol, h), r );

                 // Select the correct icon from the iconset
                 if ( active )
                     mode = enabled ? TQIconSet::Active : TQIconSet::Disabled;
                 else
                     mode = enabled ? TQIconSet::Normal : TQIconSet::Disabled;
#if 0 //don't check menu
                 // Do we have an icon and are checked at the same time?
                 // Then draw a "pressed" background behind the icon
                 if ( checkable && !active && mi->isChecked() )
                 {
                     qDrawShadePanel( p, cr.x(), cr.y(), cr.width(), cr.height(),
                                      cg, true, 1, &cg.brush(TQColorGroup::Midlight) );
                 }
#endif
                 //TEST IT !!!!!!!!!!!!!!
                 if ( checkable && mi->isChecked() )
                 {//don't display icon when button is checkable
                     int cx = reverse ? x+w - checkcol : x;
                     // Draw the checkmark
                     SFlags cflags = Style_Default;
                     cflags |= active ? Style_Enabled : Style_On;
                     drawPrimitive( PE_CheckMark, p, ceData, elementFlags, TQRect( cx + itemFrame, y + itemFrame,
                                                            checkcol - itemFrame*2, h - itemFrame*2), cg, cflags );
                 }
                 else
                 {
                     // Draw the icon
                     TQPixmap pixmap = mi->iconSet()->pixmap( TQIconSet::Small, mode );
                     TQRect pmr( 0, 0, pixmap.width(), pixmap.height() );
                     pmr.moveCenter( cr.center() );
                     p->drawPixmap( pmr.topLeft(), pixmap );
                 }
             }
             // Are we checked? (This time without an icon)
             else if (  (checkable && mi->isChecked()) )
             {
                 int cx = reverse ? x+w - checkcol : x;
#if 0 //don't create a checked button
                 // We only have to draw the background if the menu item is inactive
                 // if it's active the "pressed" background is already drawn
                 if ( ! active )
                     qDrawShadePanel( p, cx, y, checkcol, h, cg, true, 1,
                                      &cg.brush(TQColorGroup::Midlight) );
#endif
                 // Draw the checkmark
                 SFlags cflags = Style_Default;
                 cflags |= active ? Style_Enabled : Style_On;
                 drawPrimitive( PE_CheckMark, p, ceData, elementFlags, TQRect( cx + itemFrame, y + itemFrame,
                                                        checkcol - itemFrame*2, h - itemFrame*2), cg, cflags );
             }

             // Time to draw the menu item label...
             int xm = itemFrame + checkcol + itemHMargin; // X position margin

             int xp = reverse ? // X position
             x + tab + rightBorder + itemHMargin + itemFrame - 1 :
             x + xm;

             int offset = reverse ? -1 : 1;	// Shadow offset for etched text

             // Label width (minus the width of the accelerator portion)
             int tw = w - xm - tab - arrowHMargin - itemHMargin * 3 - itemFrame + 1;

             // Set the color for enabled and disabled text
             // (used for both active and inactive menu items)
             p->setPen( enabled ? cg.buttonText() : cg.mid() );

             // This color will be used instead of the above if the menu item
             // is active and disabled at the same time. (etched text)
             TQColor discol = cg.mid();

             // Does the menu item draw it's own label?
             if ( mi->custom() )
             {
                 int m = itemVMargin;
                 // Save the painter state in case the custom
                 // paint method changes it in some way
                 TQPen oldPen = p->pen();


                 // Draw etched text if we're inactive and the menu item is disabled
                 if ( etchtext && !enabled && !active )
                 {
                     p->setPen( cg.light() );
                     mi->custom()->paint( p, cg, active, enabled, xp+offset, y+m+1, tw, h-2*m );
                     p->setPen( discol );
                 }
                 mi->custom()->paint( p, cg, active, enabled, xp, y+m, tw, h-2*m );
                 p->setPen( oldPen );			// restore pen

             }
             else
             {
                 // The menu item doesn't draw it's own label
                 TQString s = mi->text();

                 // Does the menu item have a text label?
                 if ( !s.isNull() ) 
                 {
                     int t = s.find( '\t' );
                     int m = itemVMargin;
                     int text_flags = AlignVCenter | ShowPrefix | DontClip | SingleLine;
                     text_flags |= reverse ? AlignRight : AlignLeft;

                     //TQColor draw = cg.text();
                     TQColor draw = (active && enabled) ? cg.highlightedText () : cg.text();
                     p->setPen(draw);


                     // Does the menu item have a tabstop? (for the accelerator text)
                     if ( t >= 0 )
                     {
                         int tabx = reverse ? x + rightBorder + itemHMargin + itemFrame :
                                    x + w - tab - rightBorder - itemHMargin - itemFrame;

                         // Draw the right part of the label (accelerator text)
                         if ( etchtext && !enabled && !active )
                         {
                             // Draw etched text if we're inactive and the menu item is disabled
                             p->setPen( cg.light() );
                             p->drawText( tabx+offset, y+m+1, tab, h-2*m, text_flags, s.mid( t+1 ) );
                             p->setPen( discol );
                         }
                         p->drawText( tabx, y+m, tab, h-2*m, text_flags, s.mid( t+1 ) );
                         s = s.left( t );
                     }

                     // Draw the left part of the label (or the whole label
                     // if there's no accelerator)
                     if ( etchtext && !enabled && !active )
                     {
                         // Etched text again for inactive disabled menu items...
                         p->setPen( cg.light() );
                         p->drawText( xp+offset, y+m+1, tw, h-2*m, text_flags, s, t );
                         p->setPen( discol );
                     }

                     p->drawText( xp, y+m, tw, h-2*m, text_flags, s, t );
                 }

                 // The menu item doesn't have a text label
                 // Check if it has a pixmap instead
                 else if ( mi->pixmap() )
                 {
                     TQPixmap *pixmap = mi->pixmap();

                     // Draw the pixmap
                     if ( pixmap->depth() == 1 )
                         p->setBackgroundMode( OpaqueMode );

                     int diffw = ( ( w - pixmap->width() ) / 2 )
                                 + ( ( w - pixmap->width() ) % 2 );
                     p->drawPixmap( x+diffw, y+itemFrame, *pixmap );

                     if ( pixmap->depth() == 1 )
                         p->setBackgroundMode( TransparentMode );
                 }
             }

             // Does the menu item have a submenu?
             if ( mi->popup() )
             {
                 PrimitiveElement arrow = reverse ? PE_ArrowLeft : PE_ArrowRight;
                 int dim = pixelMetric(PM_MenuButtonIndicator, ceData, elementFlags)- itemFrame;
                 TQRect vr = visualRect( TQRect( x + w - arrowHMargin - itemFrame - dim,
                                               y + h / 2 - dim / 2, dim, dim), r );

                 // Draw an arrow at the far end of the menu item
                 if ( active )
                 {
                     if ( enabled )
                         discol = cg.buttonText();

                     TQColorGroup g2( cg.highlightedText ()/*white*/, cg.highlight(), /*white*/cg.highlightedText (), /*white*/cg.highlightedText (),
                                     enabled ? cg.highlightedText () : discol, /*discol*/cg.highlightedText (), cg.highlightedText () );

                     drawPrimitive( arrow, p, ceData, elementFlags, vr, g2, Style_Enabled );
                 }
                 else
                     drawPrimitive( arrow, p, ceData, elementFlags, vr, cg,
                                    enabled ? Style_Enabled : Style_Default );
             }
             break;
    }
    case CE_PushButtonLabel:
    {
        const TQPushButton* button = (const TQPushButton*)widget;
        bool active = button->isOn() || button->isDown();
        int x, y, w, h;
        r.rect( &x, &y, &w, &h );

        // Shift button contents if pushed.
        if ( active )
        {
            x += pixelMetric(PM_ButtonShiftHorizontal, ceData, elementFlags, widget);
            y += pixelMetric(PM_ButtonShiftVertical, ceData, elementFlags, widget);
            flags |= Style_Sunken;
        }

        // Does the button have a popup menu?
        if ( button->isMenuButton() )
        {
            int dx = pixelMetric( PM_MenuButtonIndicator, ceData, elementFlags, widget );
            drawPrimitive( PE_ArrowDown, p, ceData, elementFlags, TQRect(x + w - dx - 2, y + 2, dx, h - 4),
                           cg, flags, opt );
            w -= dx;
        }

        // Draw the icon if there is one
        if ( button->iconSet() && !button->iconSet()->isNull() ) 
        {
            TQIconSet::Mode  mode  = TQIconSet::Disabled;
            TQIconSet::State state = TQIconSet::Off;

            if (button->isEnabled())
                mode = button->hasFocus() ? TQIconSet::Active : TQIconSet::Normal;
            if (button->isToggleButton() && button->isOn())
                state = TQIconSet::On;

            TQPixmap pixmap = button->iconSet()->pixmap( TQIconSet::Small, mode, state );

            // Center the iconset if there's no text or pixmap
            if (button->text().isEmpty() && !button->pixmap())
                p->drawPixmap( x + (w - pixmap.width())  / 2,
                               y + (h - pixmap.height()) / 2, pixmap );
            else
                p->drawPixmap( x + 4, y + (h - pixmap.height()) / 2, pixmap );

            int  pw = pixmap.width();
            x += pw + 4;
            w -= pw + 4;
        }
        // Make the label indicate if the button is a default button or not
        if ( active || button->isDefault() ) 
        {
            // Draw "fake" bold text  - this enables the font metrics to remain
            // the same as computed in TQPushButton::sizeHint(), but gives
            // a reasonable bold effect.
            //change color of text
            drawItem( p, TQRect(x, y, w, h), AlignCenter | ShowPrefix,
                      button->colorGroup(),
                      button->isEnabled(),
                      button->pixmap(),
                      button->text(), -1,
                      /*button->isDefault() ? &cdata->blueMdkColor[4] :*/ &button->colorGroup().buttonText() );

#if 0
            // Normal Text
            for(i=0; i<2; i++)
                drawItem( p, TQRect(x+i, y, w, h), AlignCenter | ShowPrefix,
                          button->colorGroup(),
                          button->isEnabled(),
                          i == 0 ? button->pixmap() : NULL,
                          button->text(), -1,
                          &button->colorGroup().buttonText() );
#endif
        } 
        else
        {
            drawItem( p, TQRect(x, y, w, h), AlignCenter | ShowPrefix,
                      button->colorGroup(),
                      button->isEnabled(), button->pixmap(),
                      button->text(), -1,
                      &button->colorGroup().buttonText() );
        }
        // Draw a focus rect if the button has focus
        if ( flags & Style_HasFocus )
            drawPrimitive( PE_FocusRect, p, ceData, elementFlags,
                           TQStyle::visualRect(subRect(SR_PushButtonFocusRect, ceData, elementFlags, widget), widget),
                           cg, flags );
        break;
    }
    case CE_PushButton:
    {
        const TQPushButton* btn = static_cast< const TQPushButton* >( widget );
        if ( widget == hoverWidget )
            flags |= Style_MouseOver;
        if (isFormWidget(btn))
            formMode = true;

        drawPrimitive(  btn->isDefault( ) ? PE_ButtonDefault : PE_ButtonCommand, p, ceData, elementFlags, r, cg, flags );
    }
    break;
    default:
        TDEStyle::drawControl(element, p, ceData, elementFlags, r, cg, flags, opt, widget);
    }
}

void MandrivaStyle::drawControlMask( ControlElement element,
                                     TQPainter *p,
                                     const TQStyleControlElementData &ceData,
                                     ControlElementFlags elementFlags,
                                     const TQRect &r,
                                     const TQStyleOption& opt,
                                     const TQWidget *widget ) const
{
    switch (element) 
    {
    case CE_TabBarTab:
    case CE_TabBarLabel:
    {
       p->fillRect(r,color1);
       break;
    }
    default:
        TDEStyle::drawControlMask(element, p, ceData, elementFlags, r, opt, widget);
    }
}

void MandrivaStyle::drawComboboxArrow( TQPainter *p,
                                       const TQStyleControlElementData &ceData,
                                       ControlElementFlags elementFlags,
                                       const TQRect &ar,
                                       const TQColorGroup &cg,
                                       SFlags flags,
                                       SCFlags active,
                                       const TQWidget *widget)const
{
    const TQComboBox * cb = (const TQComboBox *) widget;
    bool editableCombo = cb->editable();
    // Are we enabled?
    if ( widget->isEnabled() )
        flags |= Style_Enabled;

    // Are we "pushed" ?
    if ( active & Style_Sunken )
        flags |= Style_Sunken;
    p->setPen( cg.text() );
    //Don't apply background color otherwise it
    //destroys gradient.
    //p->setBackgroundColor( cg.button() );
    TQPointArray a;
    if ( editableCombo )
        a.setPoints(TQCOORDARRLEN(c_edit_arrow), c_edit_arrow);
    else
        a.setPoints(TQCOORDARRLEN(c_arrow), c_arrow);

    if ( flags & Style_Down )
        p->translate( pixelMetric( PM_ButtonShiftHorizontal, ceData, elementFlags ),
                      pixelMetric( PM_ButtonShiftVertical, ceData, elementFlags ) );

    if ( flags & Style_Enabled ) 
    {
        if ( TQApplication::reverseLayout() )
        {
            a.translate( editableCombo ? ar.x() + ar.width() / 2 +1  : ar.x() + ar.width() / 2 +4 , 
                         editableCombo ? ar.y() + ar.height() / 2 + 1 : ar.y() + ar.height() / 2 );
        }
        else
        {
            a.translate( editableCombo ? ar.x() + ar.width() / 2 +1  : ar.x() + ar.width() / 2 -3, 
                         editableCombo ? ar.y() + ar.height() / 2 + 1 : ar.y() + ar.height() / 2 );
        }
        p->setPen( cg.buttonText() );
        p->drawLineSegments( a );
    }
    else
    {
        if ( TQApplication::reverseLayout() )
        {
            a.translate( editableCombo ? ar.x() + ar.width() / 2 + 1 : ar.x() + ar.width() / 2 +4, 
                         editableCombo ? ar.y() + ar.height() / 2  + 1:  ar.y() + ar.height() / 2  );
        }
        else
        {
            a.translate( editableCombo ? ar.x() + ar.width() / 2 + 1 : ar.x() + ar.width() / 2 -3, 
                         editableCombo ? ar.y() + ar.height() / 2  + 1:  ar.y() + ar.height() / 2  );
        }
        p->setPen( cg.light() );
        p->drawLineSegments( a );
        a.translate( -1, -1 );
        p->setPen( cg.mid() );
        p->drawLineSegments( a );
    }
}

void MandrivaStyle::drawComplexControl( ComplexControl control,
                                        TQPainter *p,
                                        const TQStyleControlElementData &ceData,
                                        ControlElementFlags elementFlags,
                                        const TQRect &r,
                                        const TQColorGroup &cg,
                                        SFlags flags,
                                        SCFlags controls,
                                        SCFlags active,
                                        const TQStyleOption& opt,
                                        const TQWidget *widget ) const
{
    const MandrivaColorData *cdata = lookupData(cg);
    switch(control)
    {
    case CC_SpinWidget:
    {
        const TQSpinWidget* sw = static_cast< const TQSpinWidget* >( widget );
        TQRect br = visualRect( querySubControlMetrics( CC_SpinWidget, ceData, elementFlags, SC_SpinWidgetButtonField, opt, widget ), widget );
        //FIXME
        p->fillRect( r, widget->isEnabled() ? cg.base() : cg.background() );

        if ( controls & SC_SpinWidgetButtonField )
        {
            if ( controls  & SC_SpinWidgetUp)
            {
                TQColorGroup ucg = sw->isUpEnabled() ? cg : sw->palette().disabled();
                drawPrimitive( PE_SpinWidgetUp,p, ceData, elementFlags, TQRect(br.x()+1, br.y()+1 , br.width()-2 , br.height() / 2 ), ucg, flags, opt);
            }
            if ( controls & SC_SpinWidgetDown)
            {
                TQColorGroup dcg = sw->isDownEnabled() ? cg : sw->palette().disabled();

                drawPrimitive( PE_SpinWidgetDown,p, ceData, elementFlags, TQRect( br.x()+1 , br.y() + br.height() / 2 , br.width()-2, br.height()/ 2 -1 ), dcg, flags, opt);
            }
        }
        if ( controls & SC_SpinWidgetFrame )
            drawPrimitive( PE_PanelLineEdit, p, ceData, elementFlags, r, cg );

        break;
    }
    case CC_ToolButton: 
    {
        const TQToolButton *tb = (const TQToolButton *) widget;

        TQRect button, menuarea;
        button   = querySubControlMetrics(control, ceData, elementFlags, SC_ToolButton, opt, widget);
        menuarea = querySubControlMetrics(control, ceData, elementFlags, SC_ToolButtonMenu, opt, widget);

        SFlags bflags = flags,
            mflags = flags;

        // don't want to have the buttoncolor as the background...
        p->fillRect(r, cg.background());
        bflags &= ~Style_MouseOver;

        if (active & SC_ToolButton)
            bflags |= Style_Down;

        if (active & SC_ToolButtonMenu)
            mflags |= Style_Down;

        if (controls & SC_ToolButton) 
        {
            // If we're pressed, on, or raised...
            if (bflags & (Style_Down | Style_On | Style_Raised) || widget==hoverWidget ) 
            {
                drawPrimitive(PE_ButtonTool, p, ceData, elementFlags, button, cg, bflags, opt);
            } 
            else if (tb->parentWidget() &&
                     tb->parentWidget()->backgroundPixmap() &&
                     !tb->parentWidget()->backgroundPixmap()->isNull()) 
            {
                TQPixmap pixmap = *(tb->parentWidget()->backgroundPixmap());
                p->drawTiledPixmap( r, pixmap, tb->pos() );
            }
        }

        // Draw a toolbutton menu indicator if required
        if (controls & SC_ToolButtonMenu) 
        {
            if (mflags & (Style_Down | Style_On | Style_Raised)) 
                drawPrimitive(PE_ButtonDropDown, p, ceData, elementFlags, menuarea, cg, mflags, opt);

            drawPrimitive(PE_ArrowDown, p, ceData, elementFlags, menuarea, cg, mflags, opt);
        }

        if (tb->hasFocus() && !tb->focusProxy()) 
        {
            TQRect fr = tb->rect();
            fr.addCoords(2, 2, -2, -2);
            drawPrimitive(PE_FocusRect, p, ceData, elementFlags, fr, cg);
        }

        // Set the color for the ToolButton menu indicator
        p->setPen(cg.buttonText() );

        break;
    }

    case CC_ScrollBar:
    {
        const TQScrollBar *scrollbar = (const TQScrollBar *) widget;
        TQRect addline, subline, addpage, subpage, slider, first, last;
        bool maxedOut = (scrollbar->minValue() == scrollbar->maxValue());
        scrollmin = ( scrollbar->minValue() == scrollbar->value() );
        scrollmax = (( scrollbar->maxValue() == scrollbar->value() )|| maxedOut);
        subline = querySubControlMetrics(control, ceData, elementFlags, SC_ScrollBarSubLine, opt, widget);
        addline = querySubControlMetrics(control, ceData, elementFlags, SC_ScrollBarAddLine, opt, widget);
        subpage = querySubControlMetrics(control, ceData, elementFlags, SC_ScrollBarSubPage, opt, widget);
        addpage = querySubControlMetrics(control, ceData, elementFlags, SC_ScrollBarAddPage, opt, widget);
        slider  = querySubControlMetrics(control, ceData, elementFlags, SC_ScrollBarSlider,  opt, widget);

        first   = querySubControlMetrics(control, ceData, elementFlags, SC_ScrollBarFirst,   opt, widget);
        last    = querySubControlMetrics(control, ceData, elementFlags, SC_ScrollBarLast,    opt, widget);

        if ((controls & SC_ScrollBarSubLine) && subline.isValid()) 
        {
            int flags = Style_Enabled;
            if (active == SC_ScrollBarSubLine)
                flags |= Style_Down;
            if (scrollbar->orientation() == TQt::Horizontal)
                flags |= Style_Horizontal;
            if (hoverWidget == widget && hoverControl == HoverScrollBarSubLine)
                flags |= Style_MouseOver;
            drawPrimitive(PE_ScrollBarSubLine, p, ceData, elementFlags, subline, cg, flags);
        }
        if ((controls & SC_ScrollBarAddLine) && addline.isValid())
        {
            int flags = Style_Enabled;
            if (active == SC_ScrollBarAddLine)
                flags |= Style_Down;
            if (scrollbar->orientation() == TQt::Horizontal)
                flags |= Style_Horizontal;
            if (hoverWidget == widget && hoverControl == HoverScrollBarAddLine)
                flags |= Style_MouseOver;
            drawPrimitive(PE_ScrollBarAddLine, p, ceData, elementFlags, addline, cg, flags);
        }
        if ((controls & SC_ScrollBarSubPage) && subpage.isValid())
            drawPrimitive(PE_ScrollBarSubPage, p, ceData, elementFlags, subpage, cg,
                          Style_Enabled | ((active == SC_ScrollBarSubPage) ?
                                           Style_Down : Style_Default) |
                          ((scrollbar->orientation() == TQt::Horizontal) ?
                           Style_Horizontal : 0));
        if ((controls & SC_ScrollBarAddPage) && addpage.isValid())
            drawPrimitive(PE_ScrollBarAddPage, p, ceData, elementFlags, addpage, cg,
                          ((maxedOut) ? Style_Default : Style_Enabled) |
                          ((active == SC_ScrollBarAddPage) ?
                           Style_Down : Style_Default) |
                          ((scrollbar->orientation() == TQt::Horizontal) ?
                           Style_Horizontal : 0));
        if ((controls & SC_ScrollBarFirst) && first.isValid())
            drawPrimitive(PE_ScrollBarFirst, p, ceData, elementFlags, first, cg,
                          Style_Enabled | ((active == SC_ScrollBarFirst) ?
                                           Style_Down : Style_Default) |
                          ((scrollbar->orientation() == TQt::Horizontal) ?
                           Style_Horizontal : 0));
        if ((controls & SC_ScrollBarLast) && last.isValid())
            drawPrimitive(PE_ScrollBarLast, p, ceData, elementFlags, last, cg,
                          Style_Enabled | ((active == SC_ScrollBarLast) ?
                                           Style_Down : Style_Default) |
                          ((scrollbar->orientation() == TQt::Horizontal) ?
                           Style_Horizontal : 0));
        if ((controls & SC_ScrollBarSlider) && slider.isValid()) 
        {
            int flags = Style_Enabled;
            if (active == SC_ScrollBarSlider)
                flags |= Style_Down;
            if (scrollbar->orientation() == TQt::Horizontal)
                flags |= Style_Horizontal;
            if (hoverWidget == widget && hoverControl == HoverScrollBarSlider)
                flags |= Style_MouseOver;
            drawPrimitive(PE_ScrollBarSlider, p, ceData, elementFlags, slider, cg, flags);

            // ### perhaps this should not be able to accept focus if maxedOut?
            if (scrollbar->hasFocus()) 
            {
                TQRect fr(slider.x() + 2, slider.y() + 2,
                         slider.width() - 5, slider.height() - 5);
                drawPrimitive(PE_FocusRect, p, ceData, elementFlags, fr, cg, Style_Default);
            }
        }
        break;
    }
    // COMBOBOX
    // -------------------------------------------------------------------
    case CC_ComboBox: 
    {
        const TQComboBox * cb = (const TQComboBox *) widget;
        if (isFormWidget(cb))
            formMode = true;
        // Draw box and arrow
        bool reverse = TQApplication::reverseLayout();
        if ( widget == hoverWidget )
            flags |= Style_MouseOver;
        bool widgetEnabled = ( widget->isEnabled() );
        bool sunken = cb->listBox() ? cb->listBox()->isShown() : false;

        //TODO not editable
        if( cb->editable())
        {
            if ((controls & SC_ComboBoxFrame ))
            {
                drawFrame( cdata, cg, p, r,true /*flags ? */);
            }

            if( (controls & SC_ComboBoxEditField ))
            {
                TQRect ar = TQStyle::visualRect(querySubControlMetrics(CC_ComboBox, ceData, elementFlags, SC_ComboBoxEditField, opt, widget), widget );

                drawPrimitive( PE_PanelLineEdit, p, ceData, elementFlags, ar, cg );
            }
            //if ( controls & SC_ComboBoxListBoxPopup )
            //{
            //TODO
            //}
            if( (controls & SC_ComboBoxArrow ))
            {
                TQRect ar = TQStyle::visualRect(querySubControlMetrics(CC_ComboBox, ceData, elementFlags, SC_ComboBoxArrow, opt, widget), widget );
                bool mouseOver = (flags & Style_MouseOver) && (hoverControl == HoverComboBoxArrow);
                if ( sunken )
                    renderGradient(p, TQRect(ar.x()+1, ar.y()+1, ar.width()-1, ar.height()-2), cdata->shades[2], cdata->shades[0], false);
                else if ( mouseOver ) // FIXME: should highlight only when the mouse is over the arrow
                    renderGradient(p, TQRect(ar.x()+1, ar.y()+1, ar.width()-1, ar.height()-2), TQt::white, cdata->shades[1], false);
                else
                    renderGradient(p, TQRect(ar.x()+1, ar.y()+1, ar.width()-1, ar.height()-2), cdata->shades[0],cdata->shades[2], false);

                if ( widgetEnabled )
                {
                    if ( reverse )
                    {
                        p->setPen( cg.base() );
                        p->drawLine( ar.x()+1, ar.y()+1,ar.x()+ar.width()-1, ar.y()+1 );
                        p->drawLine( ar.width()-1, ar.y()+1, ar.width()-1, ar.height()-2 );
                        
                        p->setPen( cdata->shades[1]);
                        p->drawLine( ar.x(), ar.y()+1,ar.x(), ar.height()-2 );
                        p->drawLine( ar.x(), ar.height()-2, ar.x()+ar.width()-1, ar.height()-2 );
                    }
                    else
                    {
                        p->setPen( cg.base() );
                        p->drawLine( ar.x()+1, ar.y()+1,ar.x()+ar.width()-1, ar.y()+1 );
                        p->drawLine( ar.x()+1, ar.y()+1, ar.x()+1, ar.height()-2 );

                        p->setPen( cdata->shades[1]);
                        p->drawLine( ar.x()+ar.width()-1, ar.y()+1,ar.x()+ar.width()-1, ar.height()-2 );
                        p->drawLine( ar.x()+1, ar.height()-2, ar.x()+ar.width()-1, ar.height()-2 );
                    }
                }
                p->setPen( widgetEnabled ? cdata->shades[5] :cdata->shades[4] );
                if ( reverse)
                    p->drawLine( ar.width(), ar.y()+1, ar.width(), ar.height()-2 );
                else
                    p->drawLine( ar.x(), ar.y()+1, ar.x(), ar.height()-2 );

                drawComboboxArrow( p,ceData,elementFlags,ar,cg,flags,active,widget);
            }
        }
        else
        {
            TQPen oldPen = p->pen();

            // Get the button bounding box
            TQRect ar = TQStyle::visualRect(querySubControlMetrics(CC_ComboBox, ceData, elementFlags, SC_ComboBoxArrow, opt, widget), widget );
            drawButton(  cdata,r,p,cg,flags | (sunken ? Style_Down : Style_Default));

            //test reverse !
            if( reverse )
            {
                p->setPen(cg.base());
                p->drawLine( ar.width()-1,ar.y()+5,ar.width()-1,ar.height()-6);
                p->setPen( cdata->shades[2]);
                p->drawLine( ar.width(),ar.y()+5,ar.width(),ar.height()-6);
            }
            else
            {
                p->setPen(cg.base());
                p->drawLine( ar.x()-1,ar.y()+5,ar.x()-1,ar.height()-6);
                p->setPen(cdata->shades[2]);
                p->drawLine( ar.x()-2,ar.y()+5,ar.x()-2,ar.height()-6);
            }

            drawComboboxArrow( p,ceData,elementFlags,ar,cg,flags,active,widget);
            p->setPen( oldPen );// restore pen

        }
        break;
    }
    default:
        TDEStyle::drawComplexControl(control, p, ceData, elementFlags,
                                   r, cg, flags, controls, active, opt, widget);
    }
}

TQRect MandrivaStyle::querySubControlMetrics( ComplexControl control,
                                             const TQStyleControlElementData &ceData,
                                             ControlElementFlags elementFlags,
                                             SubControl subcontrol,
                                             const TQStyleOption& opt,
                                             const TQWidget* widget ) const
{
    switch (control)
    {
    case CC_SpinWidget:
    {
        switch ( subcontrol )
        {
        case SC_SpinWidgetButtonField:
            return TQRect( widget->width() -14 , 0, 14, widget->height() );
        default:
            return TDEStyle::querySubControlMetrics( control, ceData, elementFlags, subcontrol, opt, widget );
        }
    }
    //TODO verify it.
    case CC_ComboBox:
    {
        int arrow = 11;

        switch ( subcontrol )
        {
        case SC_ComboBoxFrame:
            return TQRect( 0, 0, widget->width(), widget->height() );
        case SC_ComboBoxArrow:
        {
            const TQComboBox * cb = (const TQComboBox *) widget;
            return TQRect( cb->editable() ? ( widget->width() - arrow - 11 ) : ( widget->width() - arrow- 7 ) , 0, arrow+10 , widget->height() );
        }
        case SC_ComboBoxEditField:
        {
            if ( widget->width() < 36 || widget->height() < 22 )
                return TQRect( 5, 1, widget->width() - arrow-12, widget->height());
            else if ( static_cast< const TQComboBox* >( widget )->editable() )
                return TQRect(  1,1, widget->width() - arrow-12, widget->height() - 2 );
            else //TODO verify it
                return TQRect( 5, 1, widget->width() - arrow-12, widget->height() - 2);
        }
        default:
            return TDEStyle::querySubControlMetrics( control, ceData, elementFlags, subcontrol, opt, widget );
        }
        break;
    }
    case CC_Slider:
    {
        const TQSlider* sl = static_cast< const TQSlider* >( widget );
        bool horizontal = sl->orientation() == Horizontal;
        TQSlider::TickSetting ticks = sl->tickmarks();
        int pos = sl->sliderStart();
        int handleSize = pixelMetric( PM_SliderThickness, ceData, elementFlags, widget );
        int len = pixelMetric( PM_SliderLength, ceData, elementFlags, widget );
        switch ( subcontrol )
        {
        case SC_SliderHandle:
            if ( horizontal )
            {
                if ( ticks == TQSlider::Both )
                    return TQRect( pos, ( sl->height() - handleSize ) / 2, len, handleSize );
                else if ( ticks == TQSlider::Above )
                    return TQRect( pos, sl->height() - handleSize, len, handleSize );
                return TQRect( pos, 0, len, handleSize );
            }
            else
            {
                if ( ticks == TQSlider::Both )
                    return TQRect( ( sl->width() - handleSize ) / 2, pos, handleSize, len );
                else if ( ticks == TQSlider::Above )
                    return TQRect( sl->width() - handleSize, pos, handleSize, len );
                return TQRect( 0, pos, handleSize, len );
            }
        default:
            break;
        }
        break;
    }
    default:
        break;
    }
    return TDEStyle::querySubControlMetrics( control, ceData, elementFlags, subcontrol, opt, widget );
}

void MandrivaStyle::drawComplexControlMask( ComplexControl control,
                                            TQPainter *p,
                                            const TQStyleControlElementData &ceData,
                                            ControlElementFlags elementFlags,
                                            const TQRect &r,
                                            const TQStyleOption& opt,
                                            const TQWidget *widget ) const
{
//TODO verify
//#if 0
    switch (control)
    {
        // COMBOBOX & TOOLBUTTON MASKS
        // -------------------------------------------------------------------
    case CC_ComboBox:
    case CC_ToolButton: 
    {
        int x1, y1, x2, y2;
        r.coords( &x1, &y1, &x2, &y2 );
        TQCOORD corners[] = { x1,y1, x2,y1, x1,y2, x2,y2 };
        p->fillRect( r, color1 );
        p->setPen( color0 );
        p->drawPoints( TQPointArray(4, corners) );
        break;
    }

    default:
        TDEStyle::drawComplexControlMask(control, p, ceData, elementFlags, r, opt, widget);
    }
//#endif
        //TDEStyle::drawComplexControlMask(control, p, ceData, elementFlags, r, opt, widget);
}


int MandrivaStyle::pixelMetric(PixelMetric m, const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, const TQWidget *widget) const
{
    switch(m)
    {
    case PM_SplitterWidth:
        return 6; //Perhaps 6
    case PM_ButtonMargin:
        return 2;
    case PM_DefaultFrameWidth:
        return 1;
    case PM_MenuButtonIndicator:
        return 13;
    case PM_SliderLength:
        return 31;
    case PM_SliderControlThickness: //VERIFY it
        return 6;
    case PM_SliderThickness: //VERIFY it
        return 6;
    case PM_ExclusiveIndicatorWidth:	// Radiobutton size
        return 13;
    case PM_ExclusiveIndicatorHeight:
        return 12;
    case PM_SpinBoxFrameWidth:
        return 1;
    case PM_CheckListButtonSize: //TODO FIXME !!!!!!!!!!!!!!!
        return 10;
    case PM_ScrollBarSliderMin:
        return 21;
    case PM_ScrollBarExtent:
        return 14; //scrollbar width verify arrow position
        //checkBox
    case PM_IndicatorWidth:
        return 13;
    case PM_IndicatorHeight:
        return 12;
    case PM_TabBarTabShiftVertical:
        return 0;
    default:
        return TDEStyle::pixelMetric(m, ceData, elementFlags, widget);
    }
}


TQSize MandrivaStyle::sizeFromContents( ContentsType contents,
                                       const TQStyleControlElementData &ceData,
                                       ControlElementFlags elementFlags,
                                       const TQSize &contentSize,
                                       const TQStyleOption& opt,
                                       const TQWidget* widget ) const
{
    switch (contents)
    {
        //define progressbar default size
    case CT_ProgressBar:
        return TQSize( contentSize.width(), 20 ) ;
    case CT_SpinBox:
        return TQSize( contentSize.width(), contentSize.height()+1);
    case CT_LineEdit: {
        return contentSize + TQSize (1, 1); //add +1 to rect
    }
    case CT_SizeGrip:
    {
        return TQSize( 15, 15 );
    }
    case CT_ToolButton:
    {
        bool onToolbar = widget->parentWidget() && widget->parentWidget()->inherits( "TQToolBar" );
        if (!onToolbar) //Behaves like a button, so scale appropriately to the border
        {
            int w = contentSize.width();
            int h = contentSize.height();
            return TQSize( w + 12, h + 10 );
        }
        else
        {
            return TDEStyle::sizeFromContents( contents, ceData, elementFlags, contentSize, opt, widget );
        }
    }
    case CT_ComboBox:
    {
        const TQComboBox* combobox = (const TQComboBox*) widget;
        int h  = contentSize.height();

        if ( h < 22 )
            h = 22;

        int arrow = 11;
        return TQSize( contentSize.width() + arrow + (combobox->editable() ? 26 : 22),
                      combobox->editable() ? h : contentSize.height() + 10 );
    }
    // PUSHBUTTON SIZE
    // ------------------------------------------------------------------
    case CT_PushButton:
    {
        const TQPushButton* button = (const TQPushButton*) widget;
        int w  = contentSize.width();
        int h  = contentSize.height();
        int bm = pixelMetric( PM_ButtonMargin, ceData, elementFlags, widget );
        int fw = pixelMetric( PM_DefaultFrameWidth, ceData, elementFlags, widget ) * 2;

        w += bm + fw + 6;	// ### Add 6 to make way for bold font.
        h += bm + fw;

        // Ensure we stick to standard width and heights.
        if ( button->isDefault() || button->autoDefault() )
        {
            if ( w < 80 && !button->pixmap() )
                w = 80;
        }

        if ( h < 30 )
            h = 30;

        return TQSize( w, h );
    }
    case CT_PopupMenuItem: 
    {
        if ( ! widget || opt.isDefault() )
            return contentSize;

        const TQPopupMenu *popup = (const TQPopupMenu *) widget;
        bool checkable = popup->isCheckable();
        TQMenuItem *mi = opt.menuItem();
        int maxpmw = opt.maxIconWidth();
        int w = contentSize.width(), h = contentSize.height();

        if ( mi->custom() ) 
        {
            w = mi->custom()->sizeHint().width();
            h = mi->custom()->sizeHint().height();
            if ( ! mi->custom()->fullSpan() )
                h += 2*itemVMargin + 2*itemFrame;
        }
        else if ( mi->widget() )
        {
            // do NOT remove this as it ends up doing wrong things
            // this if is here to stop processing the item
        }
        else if ( mi->isSeparator() ) 
        {
            w = 30; // Arbitrary
            h = 2;
        }
        else 
        {
            if ( mi->pixmap() )
                h = TQMAX( h, mi->pixmap()->height() + 2*itemFrame );
            else 
            {
                // Ensure that the minimum height for text-only menu items
                // is the same as the icon size used by KDE.
                h = TQMAX( h, 16 + 2*itemFrame );
                h = TQMAX( h, popup->fontMetrics().height()
                          + 2*itemVMargin + 2*itemFrame );
            }

            if ( mi->iconSet() )
                h = TQMAX( h, mi->iconSet()->pixmap(
                              TQIconSet::Small, TQIconSet::Normal).height() +
                          2 * itemFrame );
        }

        if ( ! mi->text().isNull() && mi->text().find('\t') >= 0 )
            w += 12;
        else if ( mi->popup() )
            w += 2 * arrowHMargin;

        if ( maxpmw )
            w += maxpmw + 6;
        if ( checkable && maxpmw < 20 )
            w += 20 - maxpmw;
        if ( checkable || maxpmw > 0 )
            w += 12;

        w += rightBorder;

        return TQSize( w, h );
    }

    default:
        return TDEStyle::sizeFromContents( contents, ceData, elementFlags, contentSize, opt, widget );
    }
}

//Why ? why create virtual function ?
// Fix TQt's wacky image alignment
TQPixmap MandrivaStyle::stylePixmap(StylePixmap stylepixmap,
                                   const TQStyleControlElementData &ceData,
                                   ControlElementFlags elementFlags,
                                   const TQStyleOption& opt,
                                   const TQWidget* widget) const
{
    return TDEStyle::stylePixmap(stylepixmap, ceData, elementFlags, opt, widget);
}

bool MandrivaStyle::objectEventHandler( const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, void* source, TQEvent *ev )
{
	if (TDEStyle::objectEventHandler(ceData, elementFlags, source, ev)) {
		return true;
	}

	if (ceData.widgetObjectTypes.contains("TQObject")) {
		TQObject* obj = reinterpret_cast<TQObject*>(source);

		TQToolBar* toolbar;
		//Hover highlight on buttons and combos
		if ( obj->inherits("TQPushButton")
			 || obj->inherits("TQComboBox")
			 || obj->inherits("TQScrollBar")
			 || obj->inherits("TQHeader")
			 || obj->inherits("TQSlider")
			 || obj->inherits("TQCheckBox")
			 || obj->inherits("TQSplitterHandle"))
		{
			if ( (ev->type() == TQEvent::Enter) && static_cast<TQWidget*>(obj)->isEnabled())
			{
				TQWidget* button = static_cast<TQWidget*>(obj);
				hoverWidget = button;
				button->repaint( false );
			}
			else if ( (ev->type() == TQEvent::Leave) && (obj == hoverWidget) )
			{
				TQWidget* button = static_cast<TQWidget*>(obj);
				hoverWidget = 0;
				hoverControl = HoverNone;
				button->repaint( false );
			}
			if ((obj->inherits("TQScrollBar") || obj->inherits("TQComboBox"))
				&& ev->type() == TQEvent::MouseMove)
			{
				TQMouseEvent *e = static_cast<TQMouseEvent*>(ev);
				// updateHoverControl will trigger a repainting if necessary
				updateHoverControl(e->pos(), ceData, elementFlags);
			}

		}
		else if (obj->inherits("TQListBox"))
		{
			if ( ev->type() == TQEvent::Show || ev->type() == TQEvent::Hide)
			{
				TQWidget *w = static_cast<TQWidget*>(obj);
				if (w->parentWidget() && w->parentWidget()->inherits("TQComboBox"))
					w->parentWidget()->repaint(false);
			}
		}
		else if ( obj->parent() && !qstrcmp( obj->name(), kdeToolbarWidget ) )
		{
			// Draw a gradient background for custom widgets in the toolbar
			// that have specified a "tde toolbar widget" name.

			if (ev->type() == TQEvent::Paint )
			{
				// Find the top-level toolbar of this widget, since it may be nested in other
				// widgets that are on the toolbar.
				TQWidget *widget = static_cast<TQWidget*>(obj);
				TQWidget *parent = static_cast<TQWidget*>(obj->parent());
				int x_offset = widget->x(), y_offset = widget->y();
				while (parent && parent->parent() && !qstrcmp( parent->name(), kdeToolbarWidget ) )
				{
					x_offset += parent->x();
					y_offset += parent->y();
					parent = static_cast<TQWidget*>(parent->parent());
				}

				TQRect r  = widget->rect();
				TQRect pr = parent->rect();
				bool horiz_grad = pr.width() < pr.height();

				// Check if the parent is a TQToolbar, and use its orientation, else guess.
				TQToolBar* tb = dynamic_cast<TQToolBar*>(parent);
				if (tb) horiz_grad = tb->orientation() == TQt::Vertical;

				TQPainter p( widget );
				renderGradient(&p, r, parent->colorGroup().background(),parent->colorGroup().background(), horiz_grad);/*,
							   x_offset, y_offset, pr.width(), pr.height());*/
				//FIXME: check this code later
				return false;	// Now draw the contents
			}
		}
		else if ( obj->parent() &&
					(toolbar = dynamic_cast<TQToolBar*>(obj->parent())) )
		{

			// We need to override the paint event to draw a
			// gradient on a TQToolBarExtensionWidget.
			if ( ev->type() == TQEvent::Paint )
			{
				TQWidget *widget = static_cast<TQWidget*>(obj);
				TQRect wr = widget->rect();
				TQPainter p( widget );
				renderGradient(&p, wr, toolbar->colorGroup().background(),toolbar->colorGroup().background(),
							   toolbar->orientation() == TQt::Vertical);/*,
							   wr.x(), wr.y(), tr.width() - 2, tr.height() - 2);*/
				//FIXME: check this code later
				p.setPen( toolbar->colorGroup().dark() );
				if ( toolbar->orientation() == TQt::Horizontal )
					p.drawLine( wr.width()-1, 0, wr.width()-1, wr.height()-1 );
				else
					p.drawLine( 0, wr.height()-1, wr.width()-1, wr.height()-1 );
				return true;
			}
		}
	}
    return false;
}

//***************
// renderGradient from PlastikStyle
void MandrivaStyle::renderGradient(TQPainter *painter,
                                  const TQRect &rect,
                                  const TQColor &c1,
                                  const TQColor &c2,
                                  bool horizontal) const
{
    if((rect.width() <= 0)||(rect.height() <= 0))
        return;

    // generate a quite unique key for this surface.
    CacheEntry search(cGradientTile,
                      horizontal ? rect.width() : 0,
                      horizontal ? 0 : rect.height(),
                      c1.rgb(), c2.rgb(), horizontal );
    int key = search.key();

    CacheEntry *cacheEntry;
    if( (cacheEntry = pixmapCache->find(key)) ) 
    {
        if( search == *cacheEntry ) // match! we can draw now...
        { 
            if(cacheEntry->pixmap)
                painter->drawTiledPixmap(rect, *(cacheEntry->pixmap) );
            
            return;
        } 
        else 
        {
            // Remove old entry in case of a conflict!
            // This shouldn't happen very often, see comment in CacheEntry.
            pixmapCache->remove(key);
        }
    }

    // there wasn't anything matching in the cache, create the pixmap now...
    TQPixmap *result = new TQPixmap(horizontal ? rect.width() : 10,
                                  horizontal ? 10 : rect.height());
    TQPainter p(result);

    int r_w = result->rect().width();
    int r_h = result->rect().height();
    int r_x, r_y, r_x2, r_y2;
    result->rect().coords(&r_x, &r_y, &r_x2, &r_y2);

    int rDiff, gDiff, bDiff;
    int rc, gc, bc;

    int x, y;

    rDiff = ( c2.red())   - (rc = c1.red());
    gDiff = ( c2.green()) - (gc = c1.green());
    bDiff = ( c2.blue())  - (bc = c1.blue());

    int rl = rc << 16;
    int gl = gc << 16;
    int bl = bc << 16;

    int rdelta = ((1<<16) / (horizontal ? r_w : r_h)) * rDiff;
    int gdelta = ((1<<16) / (horizontal ? r_w : r_h)) * gDiff;
    int bdelta = ((1<<16) / (horizontal ? r_w : r_h)) * bDiff;

    // these for-loops could be merged, but the if's in the inner loop
    // would make it slow
    if(!horizontal) 
    {
        for ( y = 0; y < r_h; y++ ) 
        {
            rl += rdelta;
            gl += gdelta;
            bl += bdelta;

            p.setPen(TQColor(rl>>16, gl>>16, bl>>16));
            p.drawLine(r_x, r_y+y, r_x2, r_y+y);
        }
    } 
    else 
    {
        for( x = 0; x < r_w; x++) 
        {
            rl += rdelta;
            gl += gdelta;
            bl += bdelta;

            p.setPen(TQColor(rl>>16, gl>>16, bl>>16));
            p.drawLine(r_x+x, r_y, r_x+x, r_y2);
        }
    }

    p.end();

    // draw the result...
    painter->drawTiledPixmap(rect, *result);

    // insert into cache using the previously created key.
    CacheEntry *toAdd = new CacheEntry(search);
    toAdd->pixmap = result;
    bool insertOk = pixmapCache->insert( key, toAdd, result->width()*result->height()*result->depth()/8 );

    if(!insertOk)
        delete result;
}

void MandrivaStyle::drawButton( const MandrivaColorData *cdata, const TQRect & r, TQPainter *p,const TQColorGroup &cg, SFlags flags)const
{
    TQPen oldPen = p->pen();
    bool down = flags & Style_Down;
    bool on   = flags & Style_On;
    bool enabled  = flags & Style_Enabled;
    bool mouseOver = flags & Style_MouseOver;
    bool defaultButton = flags & Style_ButtonDefault;

    bool sunken = on || down;
    int x, y, xw, yh;
    x= r.x();
    y= r.y();
    xw = r.x()+r.width()-1;
    yh = r.y()+r.height()-1;

    if (  !formMode )
    {
        if ( !defaultButton || ( defaultButton &&enabled ) )
        {
            p->setPen( cg.background() );
            p->drawRect( r );
            //replace background into round
            //left/top
            p->drawPoint( x+1, y+1 );
            p->drawPoint( x+2, y+1 );
            p->drawPoint( x+1, y+2 );

            //right/top
            p->drawPoint( xw-2, y+1 );
            p->drawPoint( xw-1, y+1 );
            p->drawPoint( xw-1, y+2 );

            //right/bottom
            p->drawPoint( x+1, yh-2);
            p->drawPoint( x+2, yh-1);
            p->drawPoint( x+1, yh-1);


            //left/bottom
            p->drawPoint( xw-2, yh-1 );
            p->drawPoint( xw-1, yh-1 );
            p->drawPoint( xw-1, yh-2 );

        }
        else
        {
            p->setPen( cdata->blueMdkColor[4] );
            p->drawLine( x+3, y, xw-3, y );
            p->drawLine( x, y+3, x, yh-3 );
            p->drawLine( x+3, yh, xw-3, yh );
            p->drawLine( xw, y+3, xw, yh-3 );

            p->drawPoint( x+2, y+1 );
            p->drawPoint( x+1, y+2 );

            p->drawPoint( x+1, yh-2 );
            p->drawPoint( x+2, yh-1 );

            p->drawPoint( xw-2, y+1 );
            p->drawPoint( xw-1, y+2 );

            p->drawPoint( xw-1, yh-2 );
            p->drawPoint( xw-2, yh-1 );

            p->setPen( cg.background() );
            //left/top
            p->drawLine( x, y, x+2, y );
            p->drawLine( x, y+1, x+1, y+1 );
            p->drawPoint( x, y+2 );
            //right/top
            p->drawLine( xw-2, y, xw, y );
            p->drawLine( xw-1, y+1, xw, y+1 );
            p->drawPoint( xw, y+2 );

            //left/bottom
            p->drawLine( x, yh-1, x+1, yh-1 );
            p->drawLine( x, yh, x+2, yh );
            p->drawPoint( x, yh-2 );

            //right/bottom
            p->drawLine( xw-1, yh-1, xw, yh-1 );
            p->drawLine( xw-2, yh, xw, yh );
            p->drawPoint( xw, yh-2 );



        }
    }
    //FIX toggle button
    p->setPen( enabled ? cdata->buttonColor[5] : cdata->buttonColor[4] );
    //VERIFY it
    p->drawLine( x+3, y+1, xw-3, y+1 );
    p->drawLine( x+1, y+3, x+1, yh-3 );
    p->drawPoint( x+2, y+2 );

    p->setPen( cdata->buttonColor[4] );
    p->drawLine( x+3, yh-1, xw-3, yh-1 );
    p->drawLine( xw-1,y+3,xw-1,yh-3 );
    p->drawPoint( x+2, yh-2 );
    p->drawPoint( xw-2, yh-2 );
    p->drawPoint( xw-2, y+2 );

    p->setPen( ( down||sunken ) ? cg.base() : cdata->buttonColor[1] );
    p->drawLine( xw-2, y+3, xw-2, yh-3 );
    p->drawLine( x+3, yh-2, xw-3, yh-2 );


    p->setPen( ( down || sunken ) ? cdata->buttonColor[2]: cg.base() );
    p->drawLine( x+3, y+2, xw-3, y+2 );
    p->drawLine( x+2, y+3, x+2, yh-3 );


    if ( on )
        renderGradient(p, TQRect(x+3, y+3, xw-5, yh-5),
                       cdata->buttonColor[0] ,mouseOver ?  cdata->buttonColor[1] : cdata->buttonColor[2], false);
    else if ( down ||sunken )
        renderGradient(p, TQRect(x+3, y+3, xw-4, yh-4),
                       cdata->buttonColor[2] ,cdata->buttonColor[1], false);
    else
        renderGradient(p, TQRect(x+3, y+3, xw-5, yh-5),
                       cdata->buttonColor[0] ,mouseOver ?  cdata->buttonColor[1] :cdata->buttonColor[2], false);

    p->setPen( oldPen ); // restore pen

}

TQRect MandrivaStyle::subRect(SubRect r, const TQStyleControlElementData &ceData, const ControlElementFlags elementFlags, const TQWidget *widget) const
{
    switch ( r )
    {
    case SR_ProgressBarContents:
    {
        TQRect wrect( widget->rect());
        return TQRect( wrect.x() , wrect.y() , wrect.width(),  wrect.height());
    }
    case SR_PushButtonFocusRect:
    {
        const TQPushButton* button = (const TQPushButton*) widget;
        TQRect wrect(widget->rect());
        if (button->isDefault() || button->autoDefault())
            return TQRect(wrect.x() + 6, wrect.y() + 4, wrect.width() - 12,  wrect.height() - 8);
        else
            return TQRect(wrect.x() + 4 , wrect.y() + 5, wrect.width() - 9,  wrect.height() - 8);

        break;
    }
    case SR_ComboBoxFocusRect:
    {
        return querySubControlMetrics( CC_ComboBox, ceData, elementFlags , SC_ComboBoxEditField, TQStyleOption::Default, widget );
    }
    default:
        return TDEStyle::subRect( r, ceData, elementFlags, widget );
    }
}

//define handle point
void MandrivaStyle::drawHandlePoint ( const MandrivaColorData *cdata,TQPainter *p, int x, int y)const
{
    //blue-4
    p->save();
    p->setPen( cdata->blueMdkColor[4]);
    //optimise it and use drawLine;
    p->drawPoint(x+1,y);
    p->drawPoint(x+2,y);
    p->drawPoint(x,y+1);
    p->drawPoint(x+1,y+1);
    p->drawPoint(x+2,y+1);
    p->drawPoint(x+3,y+1);

    //blue-2
    p->setPen( cdata->blueMdkColor[2]);
    p->drawPoint(x, y+2 );
    p->drawPoint( x+1, y+2 );
    p->drawPoint( x+1, y+3 );

    //blue-1
    p->setPen( cdata->blueMdkColor[1] );
    p->drawPoint( x+2, y+2 );
    p->drawPoint( x+3, y+2 );
    p->drawPoint( x+2, y+3 );
    p->restore();
}

bool MandrivaStyle::excludeColor(const TQColor &col, bool active) const
{
    if ( active )
    {
        if ( col == TQColor( "#F7B610" )
             || col == TQColor( "#8EC7FF" )
             || col == TQColor( "#C7D3DF" ) )
            return true;

    }
    return false;
}

bool MandrivaStyle::isFormWidget(const TQWidget* widget) const
{
    //Form widgets are in the TDEHTMLView, but that has 2 further inner levels
    //of widgets - TQClipperWidget, and outside of that, TQViewportWidget
    TQWidget* potentialClipPort = widget->parentWidget();
    if ( !potentialClipPort || potentialClipPort->isTopLevel() )
        return false;

    TQWidget* potentialViewPort = potentialClipPort->parentWidget();
    if (!potentialViewPort || potentialViewPort->isTopLevel() ||
        qstrcmp(potentialViewPort->name(), "qt_viewport") )
        return false;

    TQWidget* potentialKHTML  = potentialViewPort->parentWidget();
    if (!potentialKHTML || potentialKHTML->isTopLevel() ||
        qstrcmp(potentialKHTML->className(), "TDEHTMLView") )
        return false;


    return true;
}
