/***************************************************************************
 *   Copyright (C) 2006-2012 by Thomas Schweitzer                          *
 *   thomas-schweitzer(at)arcor.de                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2.0 as   *
 *   published by the Free Software Foundation.                            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program in the file LICENSE.GPL; if not, write to the *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "MainWindowBase.h"

#include "tqvaluelist.h"


class AboutDialog;
class UiGuiHighlighter;
class IndentHandler;
class UiGuiSettings;
class UiGuiSettingsDialog;
class ToolBarWidget;

class TQextScintilla;
class TQLabel;
class TQScrollBar;
class TQSplitter;
class TQTranslator;


class MainWindow : public MainWindowBase
{
	TQ_OBJECT

	public:
		// Constructor
		MainWindow(TQString file2OpenOnStart = "", TQWidget *parent = NULL);
		~MainWindow();

	protected:
		void closeEvent(TQCloseEvent *event);

	private slots:
		void openSourceFileDialog(const TQString &fileName = TQString::null);
		bool saveSourceFile();
		bool saveasSourceFileDialog(TQAction *chosenEncodingAction = NULL);
		void saveAsOtherEncoding(TQAction *chosenEncodingAction);
		void callIndenter();
		void updateSourceView();
		void turnHighlightOnOff(bool turnOn);
		void setWhiteSpaceVisibility(bool visible);
		void setIndenterParameterTooltips(bool enabled);
		void sourceCodeChangedHelperSlot();
		void sourceCodeChangedSlot();
		void indentSettingsChangedSlot();
		void previewTurnedOnOff(bool turnOn);
		void exportToPDF();
		void exportToHTML();
		void languageChanged(int languageIndex);
		void encodingChanged(TQAction *encodingAction);
		void numberOfLinesChanged();
		void updateRecentlyOpenedList();
		void recentlyOpenedFileHighlighted(int recentlyOpenedActionId);
		void openFileFromRecentlyOpenedList(int recentlyOpenedActionId);
		void clearRecentlyOpenedList();
		void showAboutDialog();
		void setStatusBarCursorPosInfo(int line, int column);

	private:
		TQString loadFile(const TQString &filePath);
		void     updateWindowTitle();
		void     updateSyntaxHighlighting();
		void     loadLastOpenedFile();
		void     saveSettings();
		bool     maybeSave();
		void     createEncodingMenu();
		void     createHighlighterMenu();
		bool     initApplicationLanguage();
		void     initMainWindow();
		void     initToolBar();
		void     initTextEditor();
		void     initSyntaxHighlighter();
		void     initIndenter();
		void     initRecentlyOpenedList();
///-- 		void     changeEvent(TQEvent *event);
		void     dragEnterEvent(TQDragEnterEvent *event);
		void     dropEvent(TQDropEvent *event);

	  TQSplitter       *m_centralSplitter;
		TQextScintilla   *m_qSciSourceCodeEditor;
		UiGuiSettings    *m_settings;
                     
		TQString          m_currentEncoding;
		TQString          m_sourceFileContent;
		TQString          m_sourceFormattedContent;
		TQString          m_sourceViewContent;
		UiGuiHighlighter *m_highlighter;
///-- 		TQScrollBar             *m_textEditVScrollBar;
		AboutDialog      *m_aboutDialog;
		UiGuiSettingsDialog *m_settingsDialog;
		int m_actionClearRecentlyOpenedListId;
		int m_recentlyOpenedListMaxSize;
///-- 		int            _textEditLastScrollPos;
		int             m_currentIndenterID;
		int             m_oldLinesNumber;
		bool            m_loadLastSourceCodeFileOnStartup;
		TQString        m_currentSourceFile;
		TQString        m_currentSourceFileExtension;
		TQString        m_savedSourceContent;
		TQActionGroup  *m_encodingActionGroup;
		TQActionGroup  *m_saveEncodedActionGroup;
		TQActionGroup  *m_highlighterActionGroup;
		TQValueList<TQAction*> m_openEncodingActions;
		TQValueList<TQAction*> m_saveEncodingActions;
		TQValueList<TQAction*> m_highlightingActions;
		TQTranslator   *m_uiGuiTranslator;

		bool            m_sourceCodeChanged;
		bool            m_indentSettingsChanged;
		bool            m_previewToggled;
		bool            m_documentModified;
		TQStringList    m_recentlyOpenedList;

		ToolBarWidget  *m_toolBarWidget;
		IndentHandler  *m_indentHandler;
		TQLabel        *m_textEditLineColumnInfoLabel;
};

#endif // MAINWINDOW_H
