/* This file is part of the KDE project
   Copyright (C) 2001,2002,2003,2004 Laurent Montel <montel@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "kchartParameterPieConfigPage.h"

#include "kchartParameterPieConfigPage.moc"

#include <tdeapplication.h>
#include <tdelocale.h>
#include <kdebug.h>
#include <kdialog.h>

#include <tqlayout.h>
#include <tqlabel.h>
#include <tqbuttongroup.h>
#include <tqcheckbox.h>
#include <tqlineedit.h>
#include <tqradiobutton.h>
#include <tqspinbox.h>
#include <tqvbuttongroup.h>
#include <tqwhatsthis.h>

#include "kchart_params.h"

namespace KChart
{

KChartParameterPieConfigPage::KChartParameterPieConfigPage( KChartParams* params,
                                                            TQWidget* parent ) :
    TQWidget( parent ),_params( params )
{
    TQVBoxLayout  *toplevel = new TQVBoxLayout( this, 10 );
    TQVBoxLayout  *grid1 = new TQVBoxLayout(this);
    toplevel->addLayout( grid1 );

    TQVButtonGroup* gb = new TQVButtonGroup( i18n( "Parameter" ), this );
    grid1->addWidget(gb);

    pie3d = new TQCheckBox(i18n("Pie 3D"), gb);
    TQWhatsThis::add(pie3d, i18n("Uncheck this option if you do not want a 3D effect for your pie."));
    drawShadowColor=new TQCheckBox(i18n("Draw shadow color"), gb);
    TQWhatsThis::add(drawShadowColor, i18n("Uncheck this option if you do not want a shadow color on a 3D pie."));

    TQLabel *label = new TQLabel( i18n( "Explode factor (%):" ), gb );
    explode = new TQSpinBox(0, 100, 1, gb);
    TQWhatsThis::add(explode, i18n("This will place gaps between the segments of your pie. Default is 0 which means the pie is a whole."));

    label = new TQLabel( i18n( "Start angle:" ), gb );
    angle = new TQSpinBox(0, 90, 1, gb);
    TQWhatsThis::add(angle, i18n("This will set the orientation of your pie. Default is 0."));

    label = new TQLabel( i18n( "3D-depth:" ), gb );
    depth = new TQSpinBox(0, 40, 1, gb);
    TQWhatsThis::add(depth, i18n("Set the depth from 0 to 40 of the 3D effect, if you have checked Pie 3D. Default is 20."));

    grid1->activate();

    connect(pie3d,TQ_SIGNAL(toggled ( bool )),this, TQ_SLOT(active3DPie(bool)));
}

void KChartParameterPieConfigPage::active3DPie(bool b)
{
    drawShadowColor->setEnabled(b);
    depth->setEnabled(b);
}

void KChartParameterPieConfigPage::init()
{
    bool state=_params->threeDPies();
    pie3d->setChecked(state);
    depth->setEnabled(state);
    active3DPie(state);

    explode->setValue((int)(_params->explodeFactor() * 100));
    depth->setValue( _params->threeDPieHeight() );
    drawShadowColor->setChecked(_params->threeDShadowColors());
    angle->setValue( _params->pieStart() );

}


void KChartParameterPieConfigPage::apply()
{
     _params->setThreeDPies( pie3d->isChecked() );
     if( _params->threeDPies() )	{
        _params->setThreeDPieHeight( depth->value() );
    }
    _params->setThreeDShadowColors( drawShadowColor->isChecked());
    _params->setExplodeFactor(((double)(explode->value()))/100.0);
    _params->setPieStart( angle->value() );
}

}  //KChart namespace
