/***************************************************************************
    begin                : Sat Sept 9 2003
    copyright            : (C) 2003 by Jeroen Wijnhout
    email                : Jeroen.Wijnhout@kdemail.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _LYXSERVER_H_
#define _LYXSERVER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tqobject.h>
#include <tqptrlist.h>
#include <tqintdict.h>
#include <tqstringlist.h>
#include <ktempdir.h>

#include <sys/types.h>

/**
 * @short Simple server that impersonates as LyX to work with gBib, pyBibliographer etc.
 * @author Jeroen Wijnhout <Jeroen.Wijnhout@kdemail.net>
 * @author Thomas Braun
 * @version 0.2
 */

class TQFile;
class TQSocketNotifier;
namespace KileAction { class TagData; }

class KileLyxServer : public TQObject
{
	TQ_OBJECT
  

public:
	KileLyxServer(bool start = true);
	~KileLyxServer();

	bool isRunning() { return m_running; }

public slots:
	bool start();
	void stop();

private slots:
	void receive(int);
	
private:
	bool openPipes();
	void removePipes();
	void processLine(const TQString &);

signals:
	void insert(const KileAction::TagData &);

private:
	mode_t 				m_perms;
	KTempDir			*m_tempDir;
	TQPtrList<TQFile>			m_pipeIn;
	TQPtrList<TQSocketNotifier>	m_notifier;
	TQIntDict<TQFile>			m_file;
	bool				m_running;
	TQStringList 			m_links,m_pipes;
};

#endif // _LYXSERVER_H_
