/*
    Rosegarden
    A sequencer and musical notation editor.
 
    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <bownie@bownie.com>
 
    The moral right of the authors to claim authorship of this work
    has been asserted.
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#include "PluginIdentifier.h"
#include <iostream>

namespace Rosegarden
{

TQString
PluginIdentifier::createIdentifier(TQString type,
                                   TQString soName,
                                   TQString label)
{
    TQString identifier = type + ":" + soName + ":" + label;
    return identifier;
}

void
PluginIdentifier::parseIdentifier(TQString identifier,
                                  TQString &type,
                                  TQString &soName,
                                  TQString &label)
{
    type = identifier.section(':', 0, 0);
    soName = identifier.section(':', 1, 1);
    label = identifier.section(':', 2);
}

bool
PluginIdentifier::areIdentifiersSimilar(TQString id1, TQString id2)
{
    TQString type1, type2, soName1, soName2, label1, label2;

    parseIdentifier(id1, type1, soName1, label1);
    parseIdentifier(id2, type2, soName2, label2);

    if (type1 != type2 || label1 != label2)
        return false;

    bool similar = (soName1.section('/', -1).section('.', 0, 0) ==
                    soName2.section('/', -1).section('.', 0, 0));

    return similar;
}

// The prefix of this key is also used as a literal in base/AudioPluginInstance.C.
// If you change one, change the other.
// Better still, don't change one.
TQString
PluginIdentifier::RESERVED_PROJECT_DIRECTORY_KEY = "__ROSEGARDEN__:__RESERVED__:ProjectDirectoryKey";

}

