/***************************************************************************
    smb4kscanner_p  -  This is a private helper class for Smb4KScanner.
                             -------------------
    begin                : Do Jul 19 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

// application specific includes
#include "smb4kscanner_p.h"


Smb4KScannerPrivate::Smb4KScannerPrivate()
{
  retry = false;
  clearData();
}


Smb4KScannerPrivate::~Smb4KScannerPrivate()
{
}


void Smb4KScannerPrivate::clearData()
{
  m_workgroup = TQString();
  m_host = TQString();
  m_ip = TQString();
  m_share = TQString();
}


void Smb4KScannerPrivate::setWorkgroup( const TQString &w )
{
  m_workgroup = w;
}


void Smb4KScannerPrivate::setHost( const TQString &h )
{
  m_host = h;
}


void Smb4KScannerPrivate::setIP( const TQString &i )
{
  m_ip = i;
}


void Smb4KScannerPrivate::setShare( const TQString &s )
{
  m_share = s;
}


const TQString &Smb4KScannerPrivate::workgroup()
{
  return m_workgroup;
}


const TQString &Smb4KScannerPrivate::host()
{
  return m_host;
}


const TQString &Smb4KScannerPrivate::ip()
{
  return m_ip;
}


const TQString &Smb4KScannerPrivate::share()
{
  return m_share;
}
