#ifndef _KVI_STATUSBARAPPLET_H_
#define _KVI_STATUSBARAPPLET_H_
//=============================================================================
//
//   File : kvi_statusbarapplet.h
//   Created on Tue 07 Sep 2004 03:56:46 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2004 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include "kvi_settings.h"
#include "kvi_pointerlist.h"
#include "kvi_heapobject.h"
#include "kvi_statusbar.h"

#include <tqstring.h>
#include "kvi_pointerhashtable.h"
#include <tqstatusbar.h>
#include <tqlabel.h>
#include <tqpixmap.h>

class TQTimer;
class TQLabel;
class KviTalPopupMenu;

class KviConfig;
class KviFrame;
class KviIrcContext;
class KviIrcConnection;
class KviStatusBarApplet;
class KviStatusBarAppletDescriptor;

typedef KviStatusBarApplet * (*CreateAppletCallback)(KviStatusBar *,KviStatusBarAppletDescriptor *);

class KVIRC_API KviStatusBarAppletDescriptor : public KviHeapObject
{
	friend class KviStatusBar;
	friend class KviStatusBarApplet;
protected:
	TQString                          m_szVisibleName;       // visible name of the applet
	TQString                          m_szInternalName;      // UNIQUE name of the applet
	TQString                          m_szPreloadModule;     // name of the module that must be preloaded for this applet
	CreateAppletCallback             m_pProc;               // creation callback
	TQPixmap                        * m_pIcon;
	int                              m_iId;
	KviPointerList<KviStatusBarApplet> * m_pAppletList;
public:
	KviStatusBarAppletDescriptor(const TQString &szVisibleName,
					const TQString &szInternalName,
					CreateAppletCallback pProc,
					const TQString &szPreloadModule = TQString(),
					const TQPixmap &pixIcon = TQPixmap());
	virtual ~KviStatusBarAppletDescriptor();
public:
	const TQString &visibleName(){ return m_szVisibleName; };
	const TQString &internalName(){ return m_szInternalName; };
	const TQString &preloadModule(){ return m_szPreloadModule; };
	int id(){ return m_iId; };
	TQPixmap * icon(){ return m_pIcon; };
protected:
	KviStatusBarApplet * create(KviStatusBar * pBar);
	void registerApplet(KviStatusBarApplet * a);
	void unregisterApplet(KviStatusBarApplet * a);
};


class KVIRC_API KviStatusBarApplet : public TQLabel
{
	friend class KviStatusBar;
	TQ_OBJECT
  
protected:
	KviStatusBar                 * m_pStatusBar;
	KviStatusBarAppletDescriptor * m_pDescriptor;
	bool                           m_bSelected;
public:
	KviStatusBarApplet(KviStatusBar * pParent,KviStatusBarAppletDescriptor *pDescriptor);
	virtual ~KviStatusBarApplet();
public:
	KviStatusBar * statusBar(){ return m_pStatusBar; };
	KviFrame * frame(){ return m_pStatusBar->frame(); };
	KviStatusBarAppletDescriptor * descriptor(){ return m_pDescriptor; };
	void select(bool bSelect = true);
	bool isSelected(){ return m_bSelected; };
protected:
	virtual void paintEvent(TQPaintEvent *e);
	virtual void fillContextPopup(KviTalPopupMenu *p){};
	virtual void loadState(const char * prefix,KviConfig *cfg){};
	virtual void saveState(const char * prefix,KviConfig *cfg){};
	virtual TQString tipText(const TQPoint &);
};



class KviStatusBarClock : public KviStatusBarApplet
{
	TQ_OBJECT
  
public:
	KviStatusBarClock(KviStatusBar * pParent,KviStatusBarAppletDescriptor *pDescriptor);
	virtual ~KviStatusBarClock();
protected:
	bool m_bUtc;
public:
	static void selfRegister(KviStatusBar * pBar);
protected:
	virtual void fillContextPopup(KviTalPopupMenu * p);
	virtual void timerEvent(TQTimerEvent * e);
	virtual void loadState(const char * prefix,KviConfig *cfg);
	virtual void saveState(const char * prefix,KviConfig *cfg);
protected slots:
	void toggleUtc();
};

class KviStatusBarConnectionTimer : public KviStatusBarApplet
{
	TQ_OBJECT
  
public:
	KviStatusBarConnectionTimer(KviStatusBar * pParent,KviStatusBarAppletDescriptor *pDescriptor);
	virtual ~KviStatusBarConnectionTimer();
protected:
	bool m_bTotal;
protected:
	virtual void timerEvent(TQTimerEvent * e);
	virtual void fillContextPopup(KviTalPopupMenu *p);
	virtual void loadState(const char * prefix,KviConfig *cfg);
	virtual void saveState(const char * prefix,KviConfig *cfg);
public:
	static void selfRegister(KviStatusBar * pBar);
protected slots:
	void toggleTotal();
};

class KviStatusBarSeparator : public KviStatusBarApplet
{
	TQ_OBJECT
  
public:
	KviStatusBarSeparator(KviStatusBar * pParent,KviStatusBarAppletDescriptor *pDescriptor);
	virtual ~KviStatusBarSeparator();
public:
	static void selfRegister(KviStatusBar * pBar);
};

class KviStatusBarAwayIndicator : public KviStatusBarApplet
{
	TQ_OBJECT
  
public:
	KviStatusBarAwayIndicator(KviStatusBar * pParent,KviStatusBarAppletDescriptor *pDescriptor);
	virtual ~KviStatusBarAwayIndicator();
public:
	static void selfRegister(KviStatusBar * pBar);
protected:
	bool m_bAwayOnAllContexts;
protected:
	virtual void mouseDoubleClickEvent(TQMouseEvent *e);
	virtual TQString tipText(const TQPoint &);
	virtual void fillContextPopup(KviTalPopupMenu *p);
	virtual void loadState(const char * prefix,KviConfig *cfg);
	virtual void saveState(const char * prefix,KviConfig *cfg);
protected slots:
	void updateDisplay();
	void toggleContext();
};

class KviStatusBarLagIndicator : public KviStatusBarApplet
{
	TQ_OBJECT
  
public:
	KviStatusBarLagIndicator(KviStatusBar * pParent,KviStatusBarAppletDescriptor *pDescriptor);
	virtual ~KviStatusBarLagIndicator();
public:
	static void selfRegister(KviStatusBar * pBar);
protected:
	virtual void mouseDoubleClickEvent(TQMouseEvent *e);
	virtual TQString tipText(const TQPoint &);
protected slots:
	void updateDisplay();
};


#endif //!_KVI_STATUSBARAPPLET_H_
