//=============================================================================
//
//   File : kvi_kvs_treenode_arraycount.cpp
//   Created on Tue 07 Oct 2003 03:00:52 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#define __KVIRC__

#include "kvi_kvs_treenode_arraycount.h"
#include "kvi_kvs_variant.h"
#include "kvi_kvs_runtimecontext.h"
#include "kvi_locale.h"
#include "kvi_kvs_object.h"


KviKvsTreeNodeArrayCount::KviKvsTreeNodeArrayCount(const TQChar * pLocation,KviKvsTreeNodeData * pSource)
: KviKvsTreeNodeIndirectData(pLocation,pSource)
{
}

KviKvsTreeNodeArrayCount::~KviKvsTreeNodeArrayCount()
{
}

void KviKvsTreeNodeArrayCount::contextDescription(TQString &szBuffer)
{
	szBuffer = "Array Count Operator";
}

void KviKvsTreeNodeArrayCount::dump(const char * prefix)
{
#ifdef COMPILE_NEW_KVS
	tqDebug("%s ArrayCount",prefix);
#endif
}

bool KviKvsTreeNodeArrayCount::evaluateReadOnlyInObjectScope(KviKvsObject *o,KviKvsRunTimeContext * c,KviKvsVariant * pBuffer)
{
#ifdef COMPILE_NEW_KVS
	KviKvsVariant val;
	if(o)
	{
		if(!m_pSource->evaluateReadOnlyInObjectScope(o,c,&val))return false;
	} else {
		if(!m_pSource->evaluateReadOnly(c,&val))return false;
	}

	if(!val.isArray())
	{
		if(!val.isNothing())
		{
			TQString szType;
			val.getTypeName(szType);
			c->warning(this,__tr2qs("The argument of the array count '#' operator didn't evaluate to an array: automatic conversion from type '%Q' supplied"),&szType);
		}
		pBuffer->setInteger(0);
		return true;
	}

	pBuffer->setInteger(val.array()->size());
#endif
	return true;
}

bool KviKvsTreeNodeArrayCount::evaluateReadOnly(KviKvsRunTimeContext * c,KviKvsVariant * pBuffer)
{
	return evaluateReadOnlyInObjectScope(0,c,pBuffer);
}
