#!/bin/bash

LIB="$1"
LIBDIR="$(rpm -E %_libdir)"
FILENAME="${LIB}.la"
FILE="${LIBDIR}/${FILENAME}"

if [ -r "${FILE}" ]; then
  echo "Already exists !!! Abort"
  exit 1
fi

LIBLONG="$(echo ${LIBDIR}/${LIB}.so.*.*)"
LIBSHORT="$(echo ${LIBDIR}/${LIB}.so.?)"

echo "Library: ${LIBLONG} | ${LIBSHORT}"


cat <<EOF >/tmp/$LIB.$$
# ${FILENAME} - a libtool library file
# Generated by libtool (GNU libtool) 2.4.2
#
# Please DO NOT delete this file!
# It is necessary for linking the library.

# The name that we can dlopen(3).
dlname='${LIBSHORT}'

# Names of this library.
library_names='${LIBLONG} ${LIBSHORT} ${LIB}.so'

# The name of the static archive.
old_library='${LIB}.a'

# Linker flags that can not go in dependency_libs.
inherited_linker_flags=''

# Libraries that this one depends upon.
dependency_libs=' -lm'

# Names of additional weak libraries provided by this library
weak_library_names=''

# Version information for ${LIB}.
current=4
age=2
revision=0

# Is this an already installed library?
installed=yes

# Should we warn about portability when linking against -modules?
shouldnotlink=no

# Files to dlopen/dlpreopen
dlopen=''
dlpreopen=''

# Directory that this library needs to be installed in:
libdir='${LIBDIR}'
EOF

[ $(whoami) = "root" ] || SUDO="sudo"
$SUDO mv "/tmp/$LIB.$$" "${FILE}"
