# Copyright 2022 The Trinity Desktop Project
# Distributed under the terms of the GNU General Public License v2

EAPI="8"

TRINITY_MODULE_TYPE="dependencies"
TRINITY_MODULE_NAME="tqscintilla"

inherit trinity-base-2

DESCRIPTION="TQt source code editing component based on Scintilla"
HOMEPAGE="https://trinitydesktop.org/"

LICENSE="LGPL-2.1"
SLOT="0"
if [[ ${PV} != *9999* ]] ; then
	KEYWORDS="~amd64 ~arm64 ~x86"
fi

DEPEND="~dev-tqt/tqtinterface-${PV}"
RDEPEND="${DEPEND}"

TQBASE="/usr/tqt3"

src_configure() {
	local mycmakeargs
	mycmakeargs=(
		-DCMAKE_INSTALL_PREFIX="${EPREFIX}${TQBASE}"
		-DHTML_INSTALL_DIR="${TDEDIR}/share/doc/tde/HTML"
		-DBUILD_ALL=ON
	)
	trinity-base-2_src_configure
}
