# Copyright 1999-2024 Gentoo Authors
# Copyright 2020-2024 The Trinity Desktop Project
# Distributed under the terms of the GNU General Public License v2

EAPI="8"

TRINITY_MODULE_TYPE="dependencies"
TRINITY_MODULE_NAME="libr"
inherit trinity-base-2

DESCRIPTION="ELF resource access and editing library"
HOMEPAGE="https://trinitydesktop.org/"

LICENSE="LGPL-2.1"
SLOT="0"
if [[ ${PV} != *9999* ]] ; then
	KEYWORDS="~amd64 ~arm64 ~x86"
fi
IUSE="+bfd elf gtk man"
REQUIRED_USE="?? ( bfd elf )"

RDEPEND="
	sys-libs/zlib:=
	bfd? ( sys-libs/binutils-libs:= )
	elf? ( virtual/libelf:= )
"
DEPEND="${RDEPEND}
	gtk? ( x11-libs/gtk+:2 )
"
# NOTE: gtk uses weak linkage, so it's not necessary during runtime
BDEPEND="man? ( app-text/doxygen )"

pkg_setup() {
	if ! use bfd && ! use elf; then
		ewarn "You haven't selected nor \"bfd\" nor \"elf\" as a backend"
		ewarn "a fallback read-only implementation will be used to"
		ewarn "access elf resources, but modification of elf files will"
		ewarn "be unavailable."
	fi
}

src_prepare() {
	trinity-base-2_src_prepare

	if ! use man; then
		rm -rf man || die
	fi
}

src_configure() {
	local mycmakeargs=(
		-DWITH_BACKEND_LIBBFD=$(usex bfd)
		-DWITH_BACKEND_LIBELF=$(usex elf)
		-DWITH_BACKEND_READONLY=$( (! use bfd && ! use elf) && echo yes || echo no )
		-DWITH_GTK=$(usex gtk)
	)

	cmake_src_configure
}
