--- tqt/secqlineedit.cpp.orig	2019-03-06 08:09:48.000000000 +0100
+++ tqt/secqlineedit.cpp	2024-04-14 19:43:21.398488000 +0200
@@ -86,7 +86,7 @@
 #include "ntqaccessible.h"
 #endif
 
-#ifndef QT_NO_ACCEL
+#ifndef TQT_NO_ACCEL
 #include "ntqkeysequence.h"
 #define ACCEL_KEY(k) "\t" + TQString(TQKeySequence( TQt::CTRL | TQt::Key_ ## k ))
 #else
@@ -235,7 +235,7 @@
     inline bool hasSelectedText() const { return !text.isEmpty() && selend > selstart; }
     inline void deselect() { selDirty |= (selend > selstart); selstart = selend = 0; }
     void removeSelectedText();
-#ifndef QT_NO_CLIPBOARD
+#ifndef TQT_NO_CLIPBOARD
     void copy( bool clipboard = TRUE ) const;
 #endif
     inline bool inSelection( int x ) const
@@ -1018,14 +1018,14 @@
 void SecTQLineEdit::setReadOnly( bool enable )
 {
     d->readOnly = enable;
-#ifndef QT_NO_CURSOR
+#ifndef TQT_NO_CURSOR
     setCursor( enable ? arrowCursor : ibeamCursor );
 #endif
     update();
 }
 
 
-#ifndef QT_NO_CLIPBOARD
+#ifndef TQT_NO_CLIPBOARD
 /*!
     Copies the selected text to the clipboard and deletes it, if there
     is any, and if echoMode() is \c Normal.
@@ -1073,15 +1073,15 @@
 #ifndef SECURE
     TQString t = q->selectedText();
     if ( !t.isEmpty() && echoMode == SecTQLineEdit::Normal ) {
-	q->disconnect( TQApplication::clipboard(), SIGNAL(selectionChanged()), q, 0);
+	q->disconnect( TQApplication::clipboard(), TQ_SIGNAL(selectionChanged()), q, 0);
 	TQApplication::clipboard()->setText( t, clipboard ? TQClipboard::Clipboard : TQClipboard::Selection );
-	q->connect( TQApplication::clipboard(), SIGNAL(selectionChanged()),
-		 q, SLOT(clipboardChanged()) );
+	q->connect( TQApplication::clipboard(), TQ_SIGNAL(selectionChanged()),
+		 q, TQ_SLOT(clipboardChanged()) );
     }
 #endif
 }
 
-#endif // !QT_NO_CLIPBOARD
+#endif // !TQT_NO_CLIPBOARD
 
 /*!\reimp
 */
@@ -1177,7 +1177,7 @@
 void SecTQLineEdit::mouseMoveEvent( TQMouseEvent * e )
 {
 
-#ifndef QT_NO_CURSOR
+#ifndef TQT_NO_CURSOR
     if ( ( e->state() & MouseButtonMask ) == 0 ) {
 	if ( !d->readOnly )
 	  setCursor( ( d->inSelection( e->pos().x() ) ? arrowCursor : ibeamCursor ) );
@@ -1193,7 +1193,7 @@
 */
 void SecTQLineEdit::mouseReleaseEvent( TQMouseEvent* e )
 {
-#ifndef QT_NO_CLIPBOARD
+#ifndef TQT_NO_CLIPBOARD
     if (TQApplication::clipboard()->supportsSelection() ) {
 	if ( e->button() == LeftButton ) {
 	    d->copy( FALSE );
@@ -1286,7 +1286,7 @@
 	case Key_B:
 	    cursorForward( e->state() & ShiftButton, -1 );
 	    break;
-#ifndef QT_NO_CLIPBOARD
+#ifndef TQT_NO_CLIPBOARD
 	case Key_C:
 	    copy();
 	    break;
@@ -1322,7 +1322,7 @@
 		clear();
 	    break;
 #endif
-#ifndef QT_NO_CLIPBOARD
+#ifndef TQT_NO_CLIPBOARD
 	case Key_V:
 	    if ( !d->readOnly )
 		paste();
@@ -1431,7 +1431,7 @@
 	    if ( !d->readOnly )
 		undo();
 	    break;
-#ifndef QT_NO_CLIPBOARD
+#ifndef TQT_NO_CLIPBOARD
 	case Key_F16: // Copy key on Sun keyboards
 	    copy();
 	    break;
@@ -1720,7 +1720,7 @@
 
 void SecTQLineEditPrivate::init( const SecTQString& txt )
 {
-#ifndef QT_NO_CURSOR
+#ifndef TQT_NO_CURSOR
     q->setCursor( readOnly ? arrowCursor : ibeamCursor );
 #endif
     q->setFocusPolicy( TQWidget::StrongFocus );
