/***************************************************************************
                         label.cpp - label widget 
                          -------------------
    copyright            : (C) 2004      Michal Rudolf <mrudolf@kdewebdev.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* QT INCLUDES */
#include <tqobject.h>
#include <tqstring.h>
#include <tqwidget.h>
#include <tqstringlist.h>
#include <tqevent.h>

/* OTHER INCLUDES */
#include <kommanderwidget.h>
#include <specials.h>
#include "label.h"

Label::Label(TQWidget *a_parent, const char *a_name)
  : TQLabel(a_parent, a_name), KommanderWidget(this)
{
  TQStringList states;
  states << "default";
  setStates(states);
  setDisplayStates(states);
  if (KommanderWidget::inEditor && a_name)
    setText(a_name);
}

Label::~Label()
{
}

TQString Label::currentState() const
{
  return TQString("default");
}

bool Label::isKommanderWidget() const
{
  return true;
}

TQStringList Label::associatedText() const
{
  return KommanderWidget::associatedText();
}

void Label::setAssociatedText(const TQStringList& a_at)
{
  KommanderWidget::setAssociatedText(a_at);
}

void Label::setPopulationText(const TQString& a_text)
{
  KommanderWidget::setPopulationText(a_text);
}

TQString Label::populationText() const
{
  return KommanderWidget::populationText();
}

void Label::populate()
{
  setWidgetText(KommanderWidget::evalAssociatedText(populationText()));
}

void Label::setWidgetText(const TQString& a_text)
{
  setText(a_text);
}

void Label::showEvent(TQShowEvent *e)
{
  TQLabel::showEvent(e);
  emit widgetOpened();
}

bool Label::isFunctionSupported(int f)
{
  return f == DCOP::text || f == DCOP::setText || f == DCOP::clear || f == DCOP::geometry || f == DCOP::getBackgroundColor || f == DCOP::setBackgroundColor;
}

TQString Label::handleDCOP(int function, const TQStringList& args)
{
  switch (function) {
    case DCOP::text:
      return text();
    case DCOP::setText:
      setWidgetText(args[0]);
      break;
    case DCOP::clear:
      setWidgetText("");
      break;
    case DCOP::geometry:
    {
      TQString geo = TQString::number(this->x())+" "+TQString::number(this->y())+" "+TQString::number(this->width())+" "+TQString::number(this->height());
      return geo;
      break;
    }
    case DCOP::getBackgroundColor:
      return this->paletteBackgroundColor().name();
      break;
    case DCOP::setBackgroundColor:
    {
      TQColor color;
      color.setNamedColor(args[0]);
      this->setPaletteBackgroundColor(color);
      break;
    }
    default:
      return KommanderWidget::handleDCOP(function, args);
  }
  return TQString();  
}

#include "label.moc"
