//
// C++ Implementation: apppropprg
//
// Description: 
//
//
// Author: KoolDock team <radix@kde.cl>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include <kicondialog.h>
#include <tdefiledialog.h>
#include <tdemessagebox.h>
#include <tdestandarddirs.h>
#include <tdelocale.h>

#include "apppropprg.h"
#include "appProp.h"
#include "kooldock.h"

appPropPrg::appPropPrg(TQWidget *parent,
                       const char* name):
  appProp(parent, name)
{
}

appPropPrg::~appPropPrg()
{
}

void appPropPrg::accept()
{
  TQString icon;
  TQString desktop;
  TQString path;
  TQString puser;
	
  icon = iconbutton->icon();
  desktop = cmdname->text();
  path = cmdpath->text();
  puser = user->text();
	
  if (icon.length() == 0) {
    KMessageBox::sorry(0, i18n("You must select an icon!"), i18n("Error"), 1);
    return;
  }
  if (desktop.length() == 0) {
    KMessageBox::sorry(0, i18n("You must enter a name!"), i18n("Error"), 1);
    return;
  }
  if (path.length() == 0) {
    KMessageBox::sorry(0, i18n("You must enter a command or path!"), i18n("Error"), 1);
    return;
  }
  if ((cuser->isChecked() == true) && (puser.length() == 0)) {
    KMessageBox::sorry(0, i18n("You must provide a username!"), i18n("Error"), 1);
    return;
  }

  // Modify desktop (lowercase, no spaces)
  desktop.remove(" ", true);
  desktop = desktop.lower();
  desktop.append(".desktop");
   
  // Handle position
  TQString progPath = locateLocal("data", "kooldock");
  TQDir dir(progPath + TQString("/menu/"));
  TQString preffix;
  TQStringList fileList = dir.entryList("*.desktop");
   
  int pos = fileList.count();
  if (pos < 10) {
    preffix = TQString("0%1_").arg(pos);
  }
  if (pos >= 10) {
    preffix = TQString("%1_").arg(pos);
  }
   
   desktop.prepend(preffix);
   // End handling position   
   
   // Add the .desktop file to the menuPath
   KoolDock::addFile(desktop, icon, cmdpath->text(), cmdname->text(),
                     true, terminal->isChecked(), tclose->isChecked(),
                     cuser->isChecked(), user->text());
   user->setEnabled(false);
   cuser->setChecked(false);
   terminal->setChecked(false);
   tclose->setChecked(false);
   tclose->setEnabled(false);
   this->hide();
   emit apply();
}

void appPropPrg::reject()
{
   user->setEnabled(false);
   cuser->setChecked(false);
   terminal->setChecked(false);
   tclose->setChecked(false);
   tclose->setEnabled(false);
   this->hide();
}

void appPropPrg::closeEvent(TQCloseEvent* e)
{
  e->ignore();
  reject();
}

void appPropPrg::cmdfile_clicked()
{
  TQString fileToOpen = KFileDialog::getOpenFileName(TQDir::currentDirPath(), "*.*", this, i18n("Open File"));
  if (!fileToOpen.isEmpty()) {
    cmdpath->setText(fileToOpen);
    // Set a default icon based on the program name
    TQString tmp = fileToOpen;
    int pos = tmp.findRev("/", -1);
    if (pos != -1) {
      tmp.remove(1, pos);
      tmp.remove("/", true);
    }
    iconbutton->setIcon(tmp);
    cmdname->setText(tmp);
  }
}

void appPropPrg::cuserchk()
{
  if (cuser->isChecked() == true) {
    user->setEnabled(true);
  }
  else {
    user->setEnabled(false);
  }
}

void appPropPrg::terminalchk()
{
  if (terminal->isChecked() == true) {
    tclose->setEnabled(true);
  }
  else {
    tclose->setChecked(false);
    tclose->setEnabled(false);
  }
}

#include "apppropprg.moc"
