/***************************************************************************
*   Copyright (C) 2005 by Alexander Dymo                                  *
*   adymo@kdevelop.org                                                    *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU Library General Public License as       *
*   published by the Free Software Foundation; either version 2 of the    *
*   License, or (at your option) any later version.                       *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU Library General Public     *
*   License along with this program; if not, write to the                 *
*   Free Software Foundation, Inc.,                                       *
*   51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.             *
***************************************************************************/
#ifndef KUDESIGNERSTRUCTUREWIDGET_H
#define KUDESIGNERSTRUCTUREWIDGET_H

#include <tdelistview.h>
#include <tqmap.h>

class KudesignerDoc;

namespace Kudesigner
{

class Box;
class Band;
class Canvas;
class StructureItem;

class StructureWidget: public TDEListView
{
    TQ_OBJECT
  
public:
    StructureWidget( TQWidget* parent = 0, const char* name = 0 );

public slots:
    void refresh();
    void selectionMade();
    void selectionClear();

    void selectItem( TQListViewItem *item );
    void setDocument( Kudesigner::Canvas *doc );

private:
    void refreshSection( Kudesigner::Band *section, StructureItem *root, int level = -1 );
    void refreshSectionContents( Kudesigner::Band *section, StructureItem *root );

    Kudesigner::Canvas *m_doc;
    TQMap<Kudesigner::Box*, StructureItem*> m_items;
    TQValueList<StructureItem*> m_selected;
};

}

#endif
