/*
 * Kivio - Visual Modelling and Flowcharting
 * Copyright (C) 2000-2001 theKompany.com & Dave Marotti
 * Copyright (C) 2003-2005 Peter Simonsson <psn@linux.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef TOOL_SELECT_H
#define TOOL_SELECT_H

#include <tqptrlist.h>
#include <KoPoint.h>
#include <KoRect.h>
#include "kivio_mousetool.h"

class KivioView;
class KivioPage;
class TQMouseEvent;
class TQKeyEvent;
class TDEPopupMenu;
class TDERadioAction;
class TDEAction;

class KivioStencil;

class KivioSelectDragData
{
  public:
    KoRect rect;
};

enum {
    stCut=1,
    stCopy,
    stPaste,
    stSendToBack,
    stBringToFront,
    stGroup,
    stUngroup
};

class SelectTool : public Kivio::MouseTool
{
  TQ_OBJECT
  
  public:
    SelectTool( KivioView* parent );
    ~SelectTool();

    virtual bool processEvent(TQEvent* e);

    void select(const TQRect&);

  public slots:
    void setActivated(bool a);

  signals:
    void operationDone();

  protected slots:
    void editText(TQPtrList<KivioStencil>* stencils);
    void showProperties();
    void editStencilText();

  protected:
    void mousePress(const TQPoint&);
    void mouseMove(TQMouseEvent*);
    void mouseRelease(const TQPoint&);
    void leftDoubleClick(const TQPoint&);

    bool startResizing(const TQPoint&);
    bool startDragging(const TQPoint&, bool);
    bool startCustomDragging(const TQPoint&, bool);
    bool startRubberBanding(const TQPoint&);

    void continueDragging(const TQPoint&, bool ignoreGridGuides = false);
    void continueCustomDragging(const TQPoint&);
    void continueResizing(const TQPoint&, bool ignoreGridGuides = false);
    void continueRubberBanding(const TQPoint&);

    void endResizing(const TQPoint&);
    void endDragging(const TQPoint&);
    void endCustomDragging(const TQPoint&);
    void endRubberBanding(const TQPoint&);

    void showPopupMenu(const TQPoint&);

    void changeMouseCursor(const TQPoint&);
    int isOverResizeHandle( KivioStencil *pStencil, const double x, const double y );
    
    void keyPress(TQKeyEvent* e);
    
    TQPoint m_startPoint, m_releasePoint;
    KoPoint m_lastPoint;
    KoPoint m_origPoint;

    // Select Tool Mode
    enum {
      stmNone,
      stmDrawRubber,
      stmDragging,
      stmCustomDragging,
      stmResizing
    };

  private:
    int m_mode;     // Flag to indicate that we are drawing a rubber band
    KivioStencil *m_pResizingStencil;
    KivioStencil *m_pCustomDraggingStencil;
    int m_resizeHandle;
    bool m_controlKey;
    int m_customDragID;
    TQPtrList <KivioSelectDragData> m_lstOldGeometry;
    KoRect m_selectedRect;
    KoPoint m_customDragOrigPoint;

    TDERadioAction* m_selectAction;
    TDEAction* m_arrowHeadAction;
    TDEAction* m_textEditAction;

    bool m_firstTime;
};

#endif
