/*
 *  kis_cursor.cpp - part of KImageShop
 *
 *  Copyright (c) 1999 Matthias Elter <elter@kde.org>
 *  Copyright (c) 2004 Adrian Page <adrian@pagenet.plus.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <tqbitmap.h>
#include <tqcursor.h>
#include <tqimage.h>
#include <tqpainter.h>

#include <kcursor.h>
#include <kiconloader.h>
#include <tdestandarddirs.h>

#include "kis_cursor.h"
#include "kis_factory.h"

KisCursor::KisCursor() {}

/*
 * Predefined TQt cursors
 */
TQCursor KisCursor::arrowCursor()
{
    return TQt::arrowCursor;
}

TQCursor KisCursor::upArrowCursor()
{
    return TQt::upArrowCursor;
}

TQCursor KisCursor::crossCursor()
{
    return TQt::crossCursor;
}

TQCursor KisCursor::waitCursor()
{
    return TQt::waitCursor;
}

TQCursor KisCursor::ibeamCursor()
{
    return TQt::ibeamCursor;
}

TQCursor KisCursor::sizeVerCursor()
{
    return TQt::sizeVerCursor;
}

TQCursor KisCursor::sizeHorCursor()
{
    return TQt::sizeHorCursor;
}

TQCursor KisCursor::sizeBDiagCursor()
{
    return TQt::sizeBDiagCursor;
}

TQCursor KisCursor::sizeFDiagCursor()
{
    return TQt::sizeFDiagCursor;
}

TQCursor KisCursor::sizeAllCursor()
{
    return TQt::sizeAllCursor;
}

TQCursor KisCursor::blankCursor()
{
    return TQt::blankCursor;
}

TQCursor KisCursor::splitVCursor()
{
    return TQt::splitVCursor;
}

TQCursor KisCursor::splitHCursor()
{
    return TQt::splitHCursor;
}

TQCursor KisCursor::pointingHandCursor()
{
    return TQt::pointingHandCursor;
}


/*
 * Existing custom KimageShop cursors. Use the 'load' function for all new cursors.
 */

TQCursor KisCursor::pickerCursor()
{
    static unsigned char picker_bits[] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x34, 0x00, 0x00, 0x7a,
        0x00, 0x00, 0x7d, 0x00, 0x80, 0x7e, 0x00, 0x60, 0x3f, 0x00, 0xd0, 0x1f,
        0x00, 0xa0, 0x0f, 0x00, 0x50, 0x07, 0x00, 0xc8, 0x06, 0x00, 0xe4, 0x02,
        0x00, 0x72, 0x01, 0x00, 0x39, 0x00, 0x80, 0x1c, 0x00, 0x40, 0x0e, 0x00,
        0x20, 0x07, 0x00, 0x90, 0x03, 0x00, 0xc8, 0x01, 0x00, 0xe4, 0x00, 0x00,
        0x74, 0x00, 0x00, 0x32, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00};

    TQBitmap picker_bitmap(24, 24, picker_bits, true); 
    TQBitmap picker_mask = picker_bitmap.createHeuristicMask( false );

    return TQCursor( picker_bitmap, picker_mask, 1, 22 );
}


TQCursor KisCursor::pickerPlusCursor()
{
    static unsigned char pickerplus_bits[] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x34, 0x00, 0x00, 0x7a,
        0x00, 0x00, 0x7d, 0x00, 0x80, 0x7e, 0x00, 0x60, 0x3f, 0x00, 0xd0, 0x1f,
        0x00, 0xa0, 0x0f, 0x00, 0x50, 0x07, 0x00, 0xc8, 0x06, 0x00, 0xe4, 0x02,
        0x00, 0x72, 0x01, 0x00, 0x39, 0x0c, 0x80, 0x1c, 0x0c, 0x40, 0x0e, 0x0c,
        0x20, 0x07, 0x0c, 0x90, 0x83, 0x7f, 0xc8, 0x81, 0x7f, 0xe4, 0x00, 0x0c,
        0x74, 0x00, 0x0c, 0x32, 0x00, 0x0c, 0x0a, 0x00, 0x0c, 0x00, 0x00, 0x00};

    TQBitmap picker_bitmap(24, 24, pickerplus_bits, true); 
    TQBitmap picker_mask = picker_bitmap.createHeuristicMask( false );

    return TQCursor( picker_bitmap, picker_mask, 1, 22 );
}


TQCursor KisCursor::pickerMinusCursor()
{
    static unsigned char pickerminus_bits[] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x34, 0x00, 0x00, 0x7a,
        0x00, 0x00, 0x7d, 0x00, 0x80, 0x7e, 0x00, 0x60, 0x3f, 0x00, 0xd0, 0x1f,
        0x00, 0xa0, 0x0f, 0x00, 0x50, 0x07, 0x00, 0xc8, 0x06, 0x00, 0xe4, 0x02,
        0x00, 0x72, 0x01, 0x00, 0x39, 0x00, 0x80, 0x1c, 0x00, 0x40, 0x0e, 0x00,
        0x20, 0x07, 0x00, 0x90, 0xc3, 0x7f, 0xc8, 0xc1, 0x7f, 0xe4, 0x00, 0x00,
        0x74, 0x00, 0x00, 0x32, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00};

    TQBitmap picker_bitmap(24, 24, pickerminus_bits, true); 
    TQBitmap picker_mask = picker_bitmap.createHeuristicMask( false );

    return TQCursor( picker_bitmap, picker_mask, 1, 22 );
}



TQCursor KisCursor::penCursor()
{
    static unsigned char pen_bits[] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x3a, 0x00, 0x00, 0x7d,
        0x00, 0x80, 0x7e, 0x00, 0x40, 0x7f, 0x00, 0xa0, 0x3f, 0x00, 0xd0, 0x1f,
        0x00, 0xe8, 0x0f, 0x00, 0xf4, 0x07, 0x00, 0xfa, 0x03, 0x00, 0xfd, 0x01,
        0x80, 0xfe, 0x00, 0x40, 0x7f, 0x00, 0xa0, 0x3f, 0x00, 0xf0, 0x1f, 0x00,
        0xd0, 0x0f, 0x00, 0x88, 0x07, 0x00, 0x88, 0x03, 0x00, 0xe4, 0x01, 0x00,
        0x7c, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00};

    TQBitmap pen_bitmap( 24, 24, pen_bits, true );
    TQBitmap pen_mask = pen_bitmap.createHeuristicMask( false );

    return TQCursor( pen_bitmap, pen_mask, 1, 22 );
}

TQCursor KisCursor::brushCursor()
{
    static unsigned char brush_bits[] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x68, 0x00,
        0x00, 0x00, 0xf4, 0x00, 0x00, 0x00, 0xfa, 0x00, 0x00, 0x00, 0xfd, 0x00,
        0x00, 0x80, 0x7e, 0x00, 0x00, 0x40, 0x3f, 0x00, 0x00, 0xa0, 0x1f, 0x00,
        0x00, 0xd0, 0x0f, 0x00, 0x00, 0xe8, 0x07, 0x00, 0x00, 0xf4, 0x03, 0x00,
        0x00, 0xe4, 0x01, 0x00, 0x00, 0xc2, 0x00, 0x00, 0x80, 0x41, 0x00, 0x00,
        0x40, 0x32, 0x00, 0x00, 0xa0, 0x0f, 0x00, 0x00, 0xd0, 0x0f, 0x00, 0x00,
        0xd0, 0x0f, 0x00, 0x00, 0xe8, 0x07, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00,
        0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

    TQBitmap brush_bitmap( 25, 23, brush_bits, true );
    TQBitmap brush_mask = brush_bitmap.createHeuristicMask( false );

    return TQCursor( brush_bitmap, brush_mask, 1, 21 );
}

TQCursor KisCursor::airbrushCursor()
{
    static unsigned char airbrush_bits[] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x68, 0x00, 0x00, 0x74,
        0x00, 0x00, 0x7a, 0xf0, 0x00, 0x3d, 0x08, 0x81, 0x1e, 0xe8, 0x41, 0x0f,
        0xe8, 0xa1, 0x07, 0xe8, 0xd1, 0x03, 0xe8, 0xe9, 0x01, 0xe8, 0xf5, 0x00,
        0xe8, 0x7b, 0x00, 0xf0, 0x33, 0x00, 0xf0, 0x23, 0x1f, 0xa0, 0x9f, 0x3f,
        0xd0, 0xff, 0x31, 0xe8, 0xf7, 0x30, 0xf4, 0x03, 0x18, 0xfc, 0x01, 0x0c,
        0xf8, 0x00, 0x06, 0x76, 0x00, 0x03, 0x36, 0x00, 0x03, 0x00, 0x00, 0x00};

    TQBitmap airbrush_bitmap( 24, 24, airbrush_bits, true );
    TQBitmap airbrush_mask = airbrush_bitmap.createHeuristicMask( false );

    return TQCursor( airbrush_bitmap, airbrush_mask, 1, 22 );
}

TQCursor KisCursor::eraserCursor()
{
    static unsigned char eraser_bits[] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x1d, 0x00,
        0x00, 0x80, 0x3e, 0x00, 0x00, 0x40, 0x7f, 0x00, 0x00, 0xa0, 0xff, 0x00,
        0x00, 0xd0, 0xff, 0x00, 0x00, 0xe8, 0x7f, 0x00, 0x00, 0xf4, 0x3f, 0x00,
        0x00, 0xfe, 0x1f, 0x00, 0x00, 0xf9, 0x0f, 0x00, 0x80, 0xf2, 0x07, 0x00,
        0x40, 0xe7, 0x03, 0x00, 0xa0, 0xcf, 0x01, 0x00, 0xd0, 0x9f, 0x00, 0x00,
        0xe8, 0x7f, 0x00, 0x00, 0xfc, 0x3f, 0x00, 0x00, 0xf2, 0x1f, 0x00, 0x00,
        0xe2, 0x0f, 0x00, 0x00, 0xc4, 0x07, 0x00, 0x00, 0x88, 0x03, 0x00, 0x00,
        0x10, 0x01, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

    TQBitmap eraser_bitmap( 25, 24, eraser_bits, true );
    TQBitmap eraser_mask = eraser_bitmap.createHeuristicMask( false );

    return TQCursor( eraser_bitmap, eraser_mask, 7, 22 );
}

TQCursor KisCursor::fillerCursor()
{
    static unsigned char filler_bits[] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x28, 0x00,
        0x00, 0x54, 0x00, 0x00, 0x4e, 0x00, 0x00, 0x85, 0x00, 0x80, 0x0a, 0x01,
        0x40, 0x11, 0x01, 0xe0, 0x00, 0x02, 0x58, 0x01, 0x04, 0x2c, 0x02, 0x04,
        0x44, 0x04, 0x08, 0x0c, 0x08, 0x18, 0x3c, 0x00, 0x14, 0x5c, 0x00, 0x0a,
        0x9c, 0x01, 0x05, 0x1c, 0x82, 0x02, 0x18, 0x4c, 0x01, 0x18, 0xb0, 0x00,
        0x08, 0x60, 0x00, 0x00, 0x00, 0x00};

    TQBitmap filler_bitmap( 22, 22, filler_bits, true );
    TQBitmap filler_mask = filler_bitmap.createHeuristicMask( false );

    return TQCursor( filler_bitmap, filler_mask, 3, 20 );
}

TQCursor KisCursor::colorChangerCursor()
{
    static unsigned char colorChanger_bits[] = {
        0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x10, 0x01, 0x0e, 0x08, 0x02, 0x11,
        0x04, 0x82, 0x20, 0x64, 0x84, 0x20, 0x92, 0x44, 0x46, 0x12, 0x49, 0x5f,
        0x12, 0x31, 0x5f, 0x22, 0x01, 0x5f, 0xc2, 0x00, 0x4e, 0x02, 0x00, 0x40,
        0xc2, 0x00, 0x46, 0xe2, 0x01, 0x4f, 0xe4, 0x19, 0x2f, 0xe4, 0x3d, 0x2f,
        0xe8, 0x3d, 0x17, 0xd0, 0x3c, 0x10, 0x20, 0x38, 0x08, 0x40, 0x00, 0x06,
        0x80, 0x81, 0x01, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00};

    TQBitmap colorChanger_bitmap( 24, 23, colorChanger_bits, true );
    TQBitmap colorChanger_mask = colorChanger_bitmap.createHeuristicMask( false );

    return TQCursor( colorChanger_bitmap, colorChanger_mask, 12, 10 );
}

TQCursor KisCursor::zoomCursor()
{
    static unsigned char zoom_bits[] = {
        0x00, 0x00, 0x00, 0xc0, 0x0f, 0x00, 0xf0, 0x3f, 0x00, 0x38, 0x70, 0x00,
        0x8c, 0xcf, 0x00, 0x0c, 0xdf, 0x00, 0x36, 0xbf, 0x01, 0xb6, 0xbf, 0x01,
        0xf6, 0xbf, 0x01, 0xf6, 0xbf, 0x01, 0xe6, 0x9f, 0x00, 0xcc, 0xcf, 0x00,
        0x9c, 0xe7, 0x01, 0x38, 0x70, 0x03, 0xf0, 0xbf, 0x05, 0xc0, 0xef, 0x0b,
        0x00, 0xc0, 0x17, 0x00, 0x80, 0x2f, 0x00, 0x00, 0x5f, 0x00, 0x00, 0x7e,
        0x00, 0x00, 0x7c, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00};

    TQBitmap zoom_bitmap( 24, 23, zoom_bits, true );
    TQBitmap zoom_mask = zoom_bitmap.createHeuristicMask( false );

    return TQCursor( zoom_bitmap, zoom_mask, 9, 8 );
}

TQCursor KisCursor::moveCursor()
{
    static unsigned char move_bits[] = {
        0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x7e, 0x00,
        0x00, 0xff, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00,
        0x10, 0x18, 0x08, 0x18, 0x18, 0x18, 0x1c, 0x18, 0x38, 0xfe, 0xff, 0x7f,
        0xfe, 0xff, 0x7f, 0x1c, 0x18, 0x38, 0x18, 0x18, 0x18, 0x10, 0x18, 0x08,
        0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0xff, 0x00,
        0x00, 0x7e, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00};

    TQBitmap move_bitmap( 24, 24, move_bits, true );
    TQBitmap move_mask = move_bitmap.createHeuristicMask( false );

    return TQCursor( move_bitmap, move_mask, 12, 11 );
}

TQCursor KisCursor::handCursor()
{
    return KCursor::handCursor();
}

TQCursor KisCursor::selectCursor()
{
    static unsigned char select_bits[] = {
        0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00,
        0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00,
        0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0xff, 0xff, 0x7f,
        0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00,
        0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00,
        0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00};

    TQBitmap select_bitmap(23, 23, select_bits, true); 
    TQBitmap select_mask = select_bitmap.createHeuristicMask( false );

    return TQCursor( select_bitmap, select_mask, 11, 11 );
}

TQCursor KisCursor::openHandCursor()
{
    return load("openhand_cursor.xpm");
}

TQCursor KisCursor::closedHandCursor()
{
    return load("closedhand_cursor.xpm");
}

TQCursor KisCursor::rotateCursor()
{
    return load("rotate_cursor.xpm");
}

TQCursor KisCursor::load(const TQString & iconName, int hotspotX, int hotspotY)
{
    TQString filename = KisFactory::instance()->dirs()->findResource("kis_pics", iconName);
    TQImage cursorImage;

    cursorImage.load(filename);
    Q_ASSERT(!cursorImage.isNull());
    Q_ASSERT(cursorImage.hasAlphaBuffer());

    TQBitmap bitmap(cursorImage.width(), cursorImage.height());
    TQBitmap mask(cursorImage.width(), cursorImage.height());

    TQPainter bitmapPainter(&bitmap);
    TQPainter maskPainter(&mask);

    for (TQ_INT32 x = 0; x < cursorImage.width(); ++x) {
        for (TQ_INT32 y = 0; y < cursorImage.height(); ++y) {

            TQRgb pixel = cursorImage.pixel(x, y);
            
            if (tqAlpha(pixel) < 128) {
                bitmapPainter.setPen(TQt::color0);
                maskPainter.setPen(TQt::color0);
            } else {
                maskPainter.setPen(TQt::color1);

                if (tqGray(pixel) < 128) {
                    bitmapPainter.setPen(TQt::color1);
                } else {
                    bitmapPainter.setPen(TQt::color0);
                }
            }

            bitmapPainter.drawPoint(x, y);
            maskPainter.drawPoint(x, y);
        }
    }

    return TQCursor(bitmap, mask, hotspotX, hotspotY);
}

