/***************************************************************************
 *   Copyright (C) 2012 by Timothy Pearson                                 *
 *   kb9vqf@pearsoncomputing.net                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <tqstringlist.h>
#include <tqlabel.h>
#include <tqmap.h>

#include <tdeapplication.h>
#include <tdesimpleconfig.h>
#include <tdelocale.h>
#include <kdebug.h>
#include <tdestandarddirs.h>
#include <kiconloader.h>
#include <dcopclient.h>
#include <tdeprocess.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <kwizard.h>
#include <kdialogbase.h>
#include <tqpushbutton.h>
#include <tqradiobutton.h>
#include <kurlrequester.h>

#include "certconfigpage.h"

PrimaryCertConfigPage::PrimaryCertConfigPage(TQWidget *parent, const char *name ) : PrimaryCertConfigPageDlg(parent,name) {

	px_introSidebar->setPixmap(UserIcon("kcmldapcontroller_step1.png"));

	connect(generateKeysEnabled, TQ_SIGNAL(stateChanged(int)), this, TQ_SLOT(setUseGeneratedKeys(int)));
	connect(generateKeysDisabled, TQ_SIGNAL(stateChanged(int)), this, TQ_SLOT(setUseProvidedKeys(int)));

	connect(kerberosPEM, TQ_SIGNAL(textChanged(const TQString&)), this, TQ_SLOT(validateEntries()));
	connect(kerberosPEMKEY, TQ_SIGNAL(textChanged(const TQString&)), this, TQ_SLOT(validateEntries()));
	connect(kerberosCRT, TQ_SIGNAL(textChanged(const TQString&)), this, TQ_SLOT(validateEntries()));
	connect(kerberosKEY, TQ_SIGNAL(textChanged(const TQString&)), this, TQ_SLOT(validateEntries()));
	connect(ldapCRT, TQ_SIGNAL(textChanged(const TQString&)), this, TQ_SLOT(validateEntries()));
	connect(ldapKEY, TQ_SIGNAL(textChanged(const TQString&)), this, TQ_SLOT(validateEntries()));

	connect(organizationName, TQ_SIGNAL(textChanged(const TQString&)), this, TQ_SLOT(validateEntries()));
	connect(orgUnitName, TQ_SIGNAL(textChanged(const TQString&)), this, TQ_SLOT(validateEntries()));
	connect(commonName, TQ_SIGNAL(textChanged(const TQString&)), this, TQ_SLOT(validateEntries()));
	connect(localityName, TQ_SIGNAL(textChanged(const TQString&)), this, TQ_SLOT(validateEntries()));
	connect(stateOrProvinceName, TQ_SIGNAL(textChanged(const TQString&)), this, TQ_SLOT(validateEntries()));
	connect(countryName, TQ_SIGNAL(textChanged(const TQString&)), this, TQ_SLOT(validateEntries()));
	connect(emailAddress, TQ_SIGNAL(textChanged(const TQString&)), this, TQ_SLOT(validateEntries()));

	m_parentWizard = dynamic_cast<KWizard*>(parent);
	m_parentDialog = dynamic_cast<KDialogBase*>(parent);
}

PrimaryCertConfigPage::~PrimaryCertConfigPage() {
	// 
}

void PrimaryCertConfigPage::setUseGeneratedKeys(int state) {
	if (state == TQButton::On) {
		generateKeysDisabled->setChecked(false);

		processLockouts();
		validateEntries();
	}
}

void PrimaryCertConfigPage::setUseProvidedKeys(int state) {
	if (state == TQButton::On) {
		generateKeysEnabled->setChecked(false);

		processLockouts();
		validateEntries();
	}
}

void PrimaryCertConfigPage::processLockouts() {
	kerberosPEM->setEnabled(generateKeysDisabled->isOn());
	kerberosPEMKEY->setEnabled(generateKeysDisabled->isOn());
	kerberosCRT->setEnabled(generateKeysDisabled->isOn());
	kerberosKEY->setEnabled(generateKeysDisabled->isOn());
	ldapCRT->setEnabled(generateKeysDisabled->isOn());
	ldapKEY->setEnabled(generateKeysDisabled->isOn());

	organizationName->setEnabled(generateKeysEnabled->isOn());
	orgUnitName->setEnabled(generateKeysEnabled->isOn());
	commonName->setEnabled(generateKeysEnabled->isOn());
	localityName->setEnabled(generateKeysEnabled->isOn());
	stateOrProvinceName->setEnabled(generateKeysEnabled->isOn());
	countryName->setEnabled(generateKeysEnabled->isOn());
	emailAddress->setEnabled(generateKeysEnabled->isOn());
}

void PrimaryCertConfigPage::validateEntries() {
	if (m_parentWizard) {
		if (generateKeysEnabled->isOn()) {
			if ((organizationName->text() != "") && (orgUnitName->text() != "") && (commonName->text() != "") && (localityName->text() != "") && (stateOrProvinceName->text() != "") && (countryName->text() != "") && (emailAddress->text() != "")) {
				m_parentWizard->nextButton()->setEnabled(true);
			}
			else {
				m_parentWizard->nextButton()->setEnabled(false);
			}
		}
		else {
			if ((kerberosPEM->url() != "") && (kerberosPEMKEY->url() != "") && (kerberosCRT->url() != "") && (kerberosKEY->url() != "") && (ldapCRT->url() != "") && (ldapKEY->url() != "")) {
				m_parentWizard->nextButton()->setEnabled(true);
			}
			else {
				m_parentWizard->nextButton()->setEnabled(false);
			}
		}
	}
	if (m_parentDialog) {
		if (generateKeysEnabled->isOn()) {
			if ((organizationName->text() != "") && (orgUnitName->text() != "") && (commonName->text() != "") && (localityName->text() != "") && (stateOrProvinceName->text() != "") && (countryName->text() != "") && (emailAddress->text() != "")) {
				m_parentDialog->enableButton(KDialogBase::Ok, true);
			}
			else {
				m_parentDialog->enableButton(KDialogBase::Ok, false);
			}
		}
		else {
			if ((kerberosPEM->url() != "") && (kerberosPEMKEY->url() != "") && (kerberosCRT->url() != "") && (kerberosKEY->url() != "") && (ldapCRT->url() != "") && (ldapKEY->url() != "")) {
				m_parentDialog->enableButton(KDialogBase::Ok, true);
			}
			else {
				m_parentDialog->enableButton(KDialogBase::Ok, false);
			}
		}
	}
}

#include "certconfigpage.moc"
