//Author:    Max Howell <max.howell@methylblue.com>, (C) 2003-4
//Copyright: See COPYING file that comes with this distribution

#ifndef LOCALLISTER_H
#define LOCALLISTER_H

#include <tqthread.h>

class Directory;
template<class T> class Chain;

namespace Filelight
{
   class LocalLister : public TQThread
   {
   public:
      LocalLister( const TQString &path, Chain<Directory> *cachedTrees, TQObject *parent );

      static bool readMounts();

   private:
      TQString m_path;
      Chain<Directory> *m_trees;
      TQObject *m_parent;

   private:
      virtual void run();
      Directory *scan( const TQCString&, const TQCString& );

   private:
      static TQStringList s_localMounts, s_remoteMounts; //TODO namespace
   };
}

#endif
