import os
import os.path
import re
import string
import sys
from SCons.Debug import logInstanceCreation
import SCons.Errors
import SCons.Util
class _Null:
    pass
_null=_Null
print_actions=1
execute_actions=1
print_actions_presub=0
default_ENV=None
def rfile(n):
    try:
        return n.rfile()
    except AttributeError:
        return n
def _actionAppend(act1, act2):
    a1=Action(act1)
    a2=Action(act2)
    if a1 is None or a2 is None:
        raise TypeError, "Cannot append %s to %s" % (type(act1), type(act2))
    if isinstance(a1, ListAction):
        if isinstance(a2, ListAction):
            return ListAction(a1.list + a2.list)
        else:
            return ListAction(a1.list + [ a2 ])
    else:
        if isinstance(a2, ListAction):
            return ListAction([ a1 ] + a2.list)
        else:
            return ListAction([ a1, a2 ])
class CommandGenerator:
    def __init__(self, generator):
        self.generator=generator
    def __add__(self, other):
        return _actionAppend(self, other)
    def __radd__(self, other):
        return _actionAppend(other, self)
def _do_create_action(act, *args, **kw):
    if isinstance(act, ActionBase):
        return act
    if SCons.Util.is_List(act):
        return apply(CommandAction, (act,)+args, kw)
    if isinstance(act, CommandGenerator):
        return apply(CommandGeneratorAction, (act.generator,)+args, kw)
    if callable(act):
        return apply(FunctionAction, (act,)+args, kw)
    if SCons.Util.is_String(act):
        var=SCons.Util.get_environment_var(act)
        if var:
            lcg=LazyCmdGenerator(var)
            return apply(CommandGeneratorAction, (lcg,)+args, kw)
        commands=string.split(str(act), '\n')
        if len(commands)==1:
            return apply(CommandAction, (commands[0],)+args, kw)
        else:
            listCmdActions=map(lambda x: CommandAction(x), commands)
            return apply(ListAction, (listCmdActions,)+args, kw)
    return None
def Action(act, strfunction=_null, varlist=[], presub=_null):
    if SCons.Util.is_List(act):
        acts=map(lambda x, s=strfunction, v=varlist, ps=presub:
                          _do_create_action(x, strfunction=s, varlist=v, presub=ps),
                   act)
        acts=filter(lambda x: not x is None, acts)
        if len(acts)==1:
            return acts[0]
        else:
            return ListAction(acts, strfunction=strfunction, varlist=varlist, presub=presub)
    else:
        return _do_create_action(act, strfunction=strfunction, varlist=varlist, presub=presub)
class ActionBase:
    def __init__(self, strfunction=_null, presub=_null, **kw):
        if not strfunction is _null:
            self.strfunction=strfunction
        if presub is _null:
            self.presub=print_actions_presub
        else:
            self.presub=presub
    def __cmp__(self, other):
        return cmp(self.__dict__, other.__dict__)
    def __call__(self, target, source, env, errfunc=None, presub=_null, show=_null, execute=_null):
        if not SCons.Util.is_List(target):
            target=[target]
        if not SCons.Util.is_List(source):
            source=[source]
        if presub is _null:  presub=self.presub
        if show is _null:  show=print_actions
        if execute is _null:  execute=execute_actions
        if presub:
            t=string.join(map(str, target), 'and')
            l=string.join(self.presub_lines(env), '\n  ')
            out="Building %s with action(s):\n  %s\n" % (t, l)
            sys.stdout.write(out)
        if show and self.strfunction:
            s=self.strfunction(target, source, env)
            if s:
                sys.stdout.write(s + '\n')
        if execute:
            stat=self.execute(target, source, env)
            if stat and errfunc:
                errfunc(stat)
            return stat
        else:
            return 0
    def presub_lines(self, env):
        self.presub_env=env
        lines=string.split(str(self), '\n')
        self.presub_env=None
        return lines
    def genstring(self, target, source, env):
        return str(self)
    def get_actions(self):
        return [self]
    def __add__(self, other):
        return _actionAppend(self, other)
    def __radd__(self, other):
        return _actionAppend(other, self)
def _string_from_cmd_list(cmd_list):
    cl=[]
    for arg in map(str, cmd_list):
        if ' ' in arg or '\t' in arg:
            arg='"' + arg + '"'
        cl.append(arg)
    return string.join(cl)
class CommandAction(ActionBase):
    def __init__(self, cmd, **kw):
        if __debug__: logInstanceCreation(self)
        apply(ActionBase.__init__, (self,), kw)
        self.cmd_list=cmd
    def __str__(self):
        return str(self.cmd_list)
    def strfunction(self, target, source, env):
        cmd_list=env.subst_list(self.cmd_list, 0, target, source)
        return string.join(map(_string_from_cmd_list, cmd_list), "\n")
    def execute(self, target, source, env):
        import SCons.Util
        escape=env.get('ESCAPE', lambda x: x)
        if env.has_key('SHELL'):
            shell=env['SHELL']
        else:
            raise SCons.Errors.UserError('Missing SHELL construction variable.')
        if env.has_key('PIPE_BUILD'):
            pipe_build=1
            if env.has_key('PSPAWN'):
                pspawn=env['PSPAWN']
            else:
                raise SCons.Errors.UserError('Missing PSPAWN construction variable.')
            if env.has_key('PSTDOUT'):
                pstdout=env['PSTDOUT']
            else:
                raise SCons.Errors.UserError('Missing PSTDOUT construction variable.')
            if env.has_key('PSTDERR'):
                pstderr=env['PSTDERR']
            else:
                raise SCons.Errors.UserError('Missing PSTDOUT construction variable.')
        else:
            pipe_build=0
            if env.has_key('SPAWN'):
                spawn=env['SPAWN']
            else:
                raise SCons.Errors.UserError('Missing SPAWN construction variable.')
        cmd_list=env.subst_list(self.cmd_list, 0, target, source)
        for cmd_line in cmd_list:
            if len(cmd_line):
                try:
                    ENV=env['ENV']
                except KeyError:
                    global default_ENV
                    if not default_ENV:
                        import SCons.Environment
                        default_ENV=SCons.Environment.Environment()['ENV']
                    ENV=default_ENV
                for key, value in ENV.items():
                    if SCons.Util.is_List(value):
                        value=SCons.Util.flatten(value)
                        ENV[key]=string.join(map(str, value), os.pathsep)
                    elif not SCons.Util.is_String(value):
                        ENV[key]=str(value)
                cmd_line=SCons.Util.escape_list(cmd_line, escape)
                if pipe_build:
                    ret=pspawn( shell, escape, cmd_line[0], cmd_line, ENV, pstdout, pstderr )
                else:
                    ret=spawn(shell, escape, cmd_line[0], cmd_line, ENV)
                if ret:
                    return ret
        return 0
    def get_contents(self, target, source, env, dict=None):
        cmd=self.cmd_list
        if SCons.Util.is_List(cmd):
            cmd=string.join(map(str, cmd))
        else:
            cmd=str(cmd)
        return env.subst_target_source(cmd, SCons.Util.SUBST_SIG, target, source, dict)
class CommandGeneratorAction(ActionBase):
    def __init__(self, generator, **kw):
        if __debug__: logInstanceCreation(self)
        apply(ActionBase.__init__, (self,), kw)
        self.generator=generator
    def __generate(self, target, source, env, for_signature):
        if not SCons.Util.is_List(target):
            target=[target]
        ret=self.generator(target=target, source=source, env=env, for_signature=for_signature)
        gen_cmd=Action(ret)
        if not gen_cmd:
            raise SCons.Errors.UserError("Object returned from command generator: %s cannot be used to create an Action." % repr(ret))
        return gen_cmd
    def strfunction(self, target, source, env):
        if not SCons.Util.is_List(source):
            source=[source]
        rsources=map(rfile, source)
        act=self.__generate(target, source, env, 0)
        if act.strfunction:
            return act.strfunction(target, rsources, env)
        else:
            return None
    def __str__(self):
        try:
            env=self.presub_env or {}
        except AttributeError:
            env={}
        act=self.__generate([], [], env, 0)
        return str(act)
    def genstring(self, target, source, env):
        return str(self.__generate(target, source, env, 0))
    def execute(self, target, source, env):
        rsources=map(rfile, source)
        act=self.__generate(target, source, env, 0)
        return act.execute(target, source, env)
    def get_contents(self, target, source, env, dict=None):
        return self.__generate(target, source, env, 1).get_contents(target, source, env, dict=None)
class LazyCmdGenerator:
    def __init__(self, var):
        if __debug__: logInstanceCreation(self)
        self.var=SCons.Util.to_String(var)
    def strfunction(self, target, source, env):
        try:
            return env[self.var]
        except KeyError:
            return ''
    def __str__(self):
        return 'LazyCmdGenerator: %s'%str(self.var)
    def __call__(self, target, source, env, for_signature):
        try:
            return env[self.var]
        except KeyError:
            return ''
    def __cmp__(self, other):
        return cmp(self.__dict__, other.__dict__)
class FunctionAction(ActionBase):
    def __init__(self, execfunction, **kw):
        if __debug__: logInstanceCreation(self)
        self.execfunction=execfunction
        apply(ActionBase.__init__, (self,), kw)
        self.varlist=kw.get('varlist', [])
    def function_name(self):
        try:
            return self.execfunction.__name__
        except AttributeError:
            try:
                return self.execfunction.__class__.__name__
            except AttributeError:
                return "unknown_python_function"
    def strfunction(self, target, source, env):
        def array(a):
            def quote(s):
                return '"' + str(s) + '"'
            return '[' + string.join(map(quote, a), ", ") + ']'
        name=self.function_name()
        tstr=array(target)
        sstr=array(source)
        return "%s(%s, %s)" % (name, tstr, sstr)
    def __str__(self):
        return "%s(env, target, source)" % self.function_name()
    def execute(self, target, source, env):
        rsources=map(rfile, source)
        return self.execfunction(target=target, source=rsources, env=env)
    def get_contents(self, target, source, env, dict=None):
        try:
            contents=str(self.execfunction.func_code.co_code)
        except AttributeError:
            try:
                contents=str(self.execfunction.__call__.im_func.func_code.co_code)
            except AttributeError:
                try:
                    gc=self.execfunction.get_contents
                except AttributeError:
                    contents=str(self.execfunction)
                else:
                    contents=gc(target, source, env, dict)
        return contents + env.subst(string.join(map(lambda v: '${'+v+'}',
                                                     self.varlist)))
class ListAction(ActionBase):
    def __init__(self, list, **kw):
        if __debug__: logInstanceCreation(self)
        apply(ActionBase.__init__, (self,), kw)
        self.list=map(lambda x: Action(x), list)
    def get_actions(self):
        return self.list
    def __str__(self):
        s=[]
        for l in self.list:
            s.append(str(l))
        return string.join(s, "\n")
    def strfunction(self, target, source, env):
        s=[]
        for l in self.list:
            if l.strfunction:
                x=l.strfunction(target, source, env)
                if not SCons.Util.is_List(x):
                    x=[x]
                s.extend(x)
        return string.join(s, "\n")
    def execute(self, target, source, env):
        for l in self.list:
            r=l.execute(target, source, env)
            if r:
                return r
        return 0
    def get_contents(self, target, source, env, dict=None):
        dict=SCons.Util.subst_dict(target, source)
        return string.join(map(lambda x, t=target, s=source, e=env, d=dict:
                                      x.get_contents(t, s, e, d), self.list), "")
class ActionCaller:
    def __init__(self, parent, args, kw):
        self.parent=parent
        self.args=args
        self.kw=kw
    def get_contents(self, target, source, env, dict=None):
        actfunc=self.parent.actfunc
        try:
            contents=str(actfunc.func_code.co_code)
        except AttributeError:
            try:
                contents=str(actfunc.__call__.im_func.func_code.co_code)
            except AttributeError:
                contents=str(actfunc)
        return contents
    def subst_args(self, target, source, env):
        return map(lambda x, e=env, t=target, s=source:
                          e.subst(x, 0, t, s),
                   self.args)
    def subst_kw(self, target, source, env):
        kw={}
        for key in self.kw.keys():
            kw[key]=env.subst(self.kw[key], 0, target, source)
        return kw
    def __call__(self, target, source, env):
        args=self.subst_args(target, source, env)
        kw=self.subst_kw(target, source, env)
        return apply(self.parent.actfunc, args, kw)
    def strfunction(self, target, source, env):
        args=self.subst_args(target, source, env)
        kw=self.subst_kw(target, source, env)
        return apply(self.parent.strfunc, args, kw)
class ActionFactory:
    def __init__(self, actfunc, strfunc):
        self.actfunc=actfunc
        self.strfunc=strfunc
    def __call__(self, *args, **kw):
        ac=ActionCaller(self, args, kw)
        return Action(ac, strfunction=ac.strfunction)
