#ifndef _LOG_CACHE_HPP
#define _LOG_CACHE_HPP

#include <tqstring.h>
#include <tqdir.h>
#include <tqmutex.h>

#include "svnqt/svnqt_defines.h"
#include "svnqt/shared_pointer.h"

namespace svn {
    namespace cache {

        class LogCacheData;

        class SVNTQT_EXPORT LogCache
        {
        private:
            svn::SharedPointer<LogCacheData> m_CacheData;

        protected:
            LogCache();
            static LogCache* mSelf;
            TQString m_BasePath;
            static TQString s_CACHE_FOLDER;
            void setupCachePath();
            void setupMainDb();

        public:
            ///! should used for testing only!
            LogCache(const TQString&aBasePath);
            virtual ~LogCache();
            static LogCache* self();
            TQDataBase reposDb(const TQString&aRepository);
            TQStringList cachedRepositories()const;

            bool valid()const;
        };
    }
}

#endif
