/*
 * Copyright (C) 2002 Marco Wegner <mail@marcowegner.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation version 2.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
  In addition, as a special exception, the copyright holders give
  permission to link the code of this program with any edition of
  the TQt library by Trolltech AS, Norway (or with modified versions
  of TQt that use the same license as TQt), and distribute linked
  combinations including the two.  You must obey the GNU General
  Public License in all respects for all of the code used other than
  TQt. If you modify this file, you may extend this exception to
  your version of the file, but you are not obligated to do so.  If
  you do not wish to do so, delete this exception statement from
  your version.
 */


#include "tdefile_po.h"

#include <tqstringlist.h>

#include "poinfo.h"
#include <kgenericfactory.h>

using namespace KBabel;

typedef KGenericFactory<KPoPlugin> POFactory;
K_EXPORT_COMPONENT_FACTORY(tdefile_po, POFactory("tdefile_po"))

KPoPlugin::KPoPlugin(TQObject *parent, const char *name,
                     const TQStringList& args)
  : KFilePlugin(parent, name, args)
{
  KFileMimeTypeInfo* info = addMimeTypeInfo("application/x-gettext");

  KFileMimeTypeInfo::GroupInfo* group =
    addGroupInfo(info, "CatalogInfo", i18n("Catalog Information"));

  KFileMimeTypeInfo::ItemInfo* item;
  item = addItemInfo(group, "Total", i18n("Total Messages"), TQVariant::Int);
  item = addItemInfo(group, "Fuzzy", i18n("Fuzzy Messages"), TQVariant::Int);
  item = addItemInfo(group, "Untranslated", i18n("Untranslated Messages"), TQVariant::Int);
  item = addItemInfo(group, "LastTranslator", i18n("Last Translator"), TQVariant::String);
  item = addItemInfo(group, "LanguageTeam", i18n("Language Team"), TQVariant::String);
  item = addItemInfo(group, "Revision", i18n("Revision"), TQVariant::String);
}

bool KPoPlugin::readInfo(KFileMetaInfo& metaInfo, uint)
{
  PoInfo poInfo;
  TQStringList wordList;
  ConversionStatus status = PoInfo::info(metaInfo.path(), poInfo, wordList, false, false, false);
  if (status == OK) {
    KFileMetaInfoGroup group = appendGroup(metaInfo, "CatalogInfo");

    appendItem(group, "Total", poInfo.total);
    appendItem(group, "Fuzzy", poInfo.fuzzy);
    appendItem(group, "Untranslated", poInfo.untranslated);
    appendItem(group, "LastTranslator", poInfo.lastTranslator);
    appendItem(group, "LanguageTeam", poInfo.languageTeam);
    appendItem(group, "Revision", poInfo.revision);

    return true;
  }
  return false;
}

#include "tdefile_po.moc"
