#ifndef COMMON_FIELD_H
#define COMMON_FIELD_H

#include "lib/mp_simple_board.h"
#include "base/field.h"
#include "types.h"

#include "lib/libksirtet_export.h"


class ShowNextPiece;
class GiftShower;
class Shadow;
class KProgress;
class KGameProgress;
class KGameLCDClock;

class LIBKSIRTET_EXPORT Field : public MPSimpleBoard, public BaseField
{
 TQ_OBJECT
  
 public:
    Field(TQWidget *parent);

 public slots:
    void moveLeft();
    void moveRight();
    void dropDownStart();
    void dropDownStop();
    void oneLineDown();
    void rotateLeft();
    void rotateRight();
    void moveLeftTotal();
    void moveRightTotal();

    virtual void settingsChanged();

 protected slots:
    void scoreUpdatedSlot() { scoreUpdated(); }
    virtual void levelUpdated();
    virtual void removedUpdated();

 private:
    KGameLCDClock *showTime;
    ShowNextPiece *showNext;
    KProgress     *toLevel;
    TQLabel        *labShowNext, *levelLabel;
    KGameProgress *prevHeight, *nextHeight;
    Shadow        *shadow;
    KCanvasRootPixmap *_snRootPixmap;
    ClientPlayData _cpd;

    void _init(bool AI, bool multiplayer, bool server, bool first,
               const TQString &name);
    void showOpponents(bool show);
    void initVariableGUI();

    void _initFlag(TQDataStream &);
    void _playFlag(TQDataStream &);
    void _pauseFlag(bool pause);
    void _stopFlag(bool gameover);
    void _dataOut(TQDataStream &);
    void _gameOverDataOut(TQDataStream &);
    void _initDataOut(TQDataStream &) {}

    KExtHighscore::Score currentScore() const;
};

#endif
