/***************************************************************************
                          kverbosdoc.h  -  description
                             -------------------
    begin                : Fre Dez 14 19:28:09 CET 2001
    copyright            : (C) 2001 by Arnold Kraschinski
    email                : arnold.k67@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KVERBOSDOC_H
#define KVERBOSDOC_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for QT
#include <tqfile.h>

// include files for KDE
#include <kurl.h>

// include files des Projektes
#include "verbspanish.h"

// forward declaration of the Kverbos classes
class KVerbosView;
class KVerbosUser;


/**
 *  KVerbosDoc provides a document object for a document-view model.
 *
 *  The KVerbosDoc class provides a document object that can be used in conjunction with
 *  the classes KVerbosApp and KVerbosView to create a document-view model for standard KDE
 *  applications based on TDEApplication and TDEMainWindow. Thereby, the document object
 *  is created by the KVerbosApp instance and contains the document structure with the
 *  according methods for manipulation of the document data by KVerbosView objects. Also,
 *  KVerbosDoc contains the methods for serialization of the document data from and to files.
 *
 *  Die Dokumentenklasse hlt eine Liste der verfgbaren Verben vor. Aus dieser Liste wird
 *  eines ausgewhlt, das gelernt werden soll. Die View-Klasse kann dieses Verb abfragen und
 *  in dem Lernfenster darstellen.
 *  Es gibt einige Situationen, die eine neuen Wahl dieses Verbes erforderlich machen:
 *  - zu Beginn des Programms, wenn die Klasse gebildet wird
 *  - wenn eine neue Verbendatei geladen wird
 *  - wenn die View-Klasse eine neue Wahl anfordert
 *    die View-Klasse merkt sich die Anzahl der richtig gelsten Verben.
 *
 *  @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
 *  @version KDevelop version 1.2 code generation
 */
class KVerbosDoc : public TQObject
{
  TQ_OBJECT
  
  public:
    /**
     * Constructor for the fileclass of the application
     */
    KVerbosDoc(TQWidget *parent, const char *name=0);
    /**
     * Destructor for the fileclass of the application
     */
    ~KVerbosDoc();

    /** adds a view to the document which represents the document contents. Usually this is your main view. */
    void addView(KVerbosView *view);
    /** removes a view from the list of currently connected views */
    void removeView(KVerbosView *view);
    /** sets the modified flag for the document after a modifying action on the view connected to the document.*/
    void setModified(bool _m=true){ modified=_m; }
    /** returns if the document is modified or not. Use this to determine if your document needs saving by the user on closing.*/
    bool isModified(){ return modified; }
    /** "save modified" - asks the user for saving if the document is modified */
    bool saveModified();
    /** deletes the document's contents */
    void deleteContents();
    /** initializes the document generally */
    bool newDocument();
    /** closes the acutal document */
    void closeDocument();
    /** loads the document by filename and format and emits the updateViews() signal
     *  Es werden bei der Datei die beiden Formate HTML-Datei und reine Textdatei unter-
     *  schieden
     */
    bool openDocument(const KURL& url, const char *format=0);
    bool openDocHTML(TQFile &f);
    bool openDocVERBOS(TQFile &f);
    /** saves the document under filename and format.
     *  Die Datei kann wahlweise im HTML-Format oder als normale Textdatei abgespeichert
     *  werden. Die HTML-Datei ist umfangreicher, weil der formatierende HTML-Code
     *  ergnzt werden muss.
     */
    bool saveDocument(const KURL& url, const char *format=0);
    bool saveDocHTML(TQFile &f);
    bool saveDocVERBOS(TQFile &f);
    /** sets a new user name, and deletes the old one. If the old one is different from
      * the default name DEFAULTUSER then some information is stored about the user. The
      * Program look if some information about the user is stored.
      */
    void setNewUser(const TQString n);
    /** returns a pointer to the actual user object */
    KVerbosUser* getUser() { return benutzer; }
    /** returns the KURL of the document */
    const KURL& URL() const;
    /** sets the URL of the document */
	  void setURL(const KURL& url);
	  /** es wird ein Verb der Liste hinzugefgt, ist emitStatus = true, wird auch
	   *  die Statuszeile entsprechend angepasst.
	   */
	  void appendVerb(const verbSpanish v, bool emitStatus = true);
	  /** prft, ob die Liste des Dokumentes leer ist */
	  bool isEmpty() const;
	  /** Gibt einen Zeiger auf die Verbliste des Dokumentes zurck */
	  spanishVerbList* getList();
	  /** Gibt die Anzahl der Verben im Dokument zurck */
	  int getAnzahl() const { return verbList2.count(); }
	  /** Gibt die gewhlte Zeit, die Formen des Verbes dazu und den spanischen
	    * und deutschen Infinitiv zurck
	    */
	  TQString getAuswahl(TQString s[][3], int &t);
	  /** feedback from the view class about the solution */
	  void solved(const bool b);
	private:
	  /** searches the verb given as a string in the list and returns a pointer to the verb */
	spanishVerbList::Iterator findVerb(const TQString& s);

  signals:
    /** wird emittiert, wenn sich die Anzahl der Verben im Dokument verndert hat */
    void anzahlVerbenGeaendert( int );
    void changeView();

  public slots:
    /**
     * calls repaint() on all views connected to the document object and is called by the view by which the document has been changed.
     *  As this view normally repaints itself, it is excluded from the paintEvent.
     */
    void slotUpdateAllViews(KVerbosView *sender);

  public:
    /**
     *  the list of the views currently connected to the document
     */
    static TQPtrList<KVerbosView> *pViewList;

  private:
    /**
     *  the modified flag of the current document
     */
    bool modified;
    KURL doc_url;
    /** Die Liste der Verben */
    spanishVerbList verbList2;
    KVerbosUser* benutzer;
};

#endif // KVERBOSDOC_H
