#!/usr/bin/env python

# Copyright (c) 2002 Detlev Offenbach <detlev@die-offenbachs.de>

from random import randint
import sys

from PyTQt.tqt import *

from mywidget import MyWidget

class TQVDialog(TQDialog):
    def __init__(self, parent=None, name=None, modal=0, flags=0):
        TQDialog.__init__(self, parent, name, modal, flags)
        
        self.vb = TQVBoxLayout(self, 8)
        self.vb.setAutoAdd(1)
        
        self.hb = None
        self.map = {}
        #self.sm = TQSignalMapper(self)
        self.connect(self, PYSIGNAL('mapped(int)'), self.done)
        
    def addButtons(self, cancel=None, ok=None, mid1=None, mid2=None, mid3=None):
        if ok is None:
            self.addButton(self.tr("OK"),1)
        else:
            self.addButton(ok,1)
        
        if mid1 is not None:
            self.addButton(mid1,2)
        
        if mid2 is not None:
            self.addButton(mid2,3)
        
        if mid3 is not None:
            self.addButton(mid3,4)
            
        if cancel is None:
            self.addButton(self.tr('Cancel'),0)
        else:
            self.addButton(cancel,0)
            
    def addButton(self, text, result):
        if self.hb is None:
            self.hb = TQHBox(self)
        c = TQPushButton(text, self.hb)
        self.setMapping(c, result)
        self.connect(c, TQ_SIGNAL('clicked()'), self.mapit)
        
    def setMapping(self, c, result):
        self.map[c] = result
        
    def mapit(self):
        qo = self.sender()
        self.emit(PYSIGNAL('mapped(int)'), (self.map[qo],))
    
translator = None
wlist = []  # keep reference to widgets

def showLang(lang):
    global translator
    
    tqApp.setPalette(TQPalette(TQColor(220-randint(0,64),220-randint(0,64),220-randint(0,64))))
    
    language = "mywidget_"+lang+".qm"
    fi = TQFileInfo(language)
    
    if not fi.exists():
        TQMessageBox.warning(None, "File error",
            "Cannot find translation for language: "+lang+\
            "\n(try eg. 'de' or 'en')")
        return None
        
    if translator is not None:
        tqApp.removeTranslator(translator)
        translator = None
        
    translator = TQTranslator(None)
    translator.load(language,".")
    tqApp.installTranslator(translator)
    m = MyWidget()
    m.setCaption("PyTQt Example - i18n - " + str(m.caption()))
    wlist.append(m)
    return m
    
def main(argv):
    app = TQApplication(argv)
    
    qm = ["cs", "de", "el", "en", "eo", "fr", "it", "jp", "ko", "no", "ru", "zh"]
    
    lang = None
    if len(argv) == 2:
        lang = argv[1]
        
    if (len(argv) != 2) or (lang == "all"):
        dlg = TQVDialog(None, None, 1)
        qmb = []
        r = 0
        if lang == "all":
            r=2
        else:
            bg = TQButtonGroup(4, TQt.Vertical, "Choose Locales", dlg)
            loc = TQTextCodec.locale()
            for i in range(0,len(qm)):
                qmb.append(TQCheckBox(qm[i], bg))
                qmb[i].setChecked(str(loc) == qm[i])
            dlg.addButtons("Cancel","OK","All")
            r = dlg.exec_loop()
        
        if r:
            tight = tqApp.desktop().screen().width() < 1024
            x = 5
            y = 25
            for i in range(0,len(qm)):
                if (r == 2) or (qmb[i].isChecked()):
                    w = showLang(qm[i])
                    
                    if w == None:
                        sys.exit(0)
                        
                    app.connect(app, TQ_SIGNAL('lastWindowClosed()'), tqApp, TQ_SLOT('quit()'))
                    w.setGeometry(x,y,197,356)
                    w.show()
                    if tight:
                        x += 8
                        y += 8
                    else:
                        x += 205
                        if x > 1000:
                            x = 5
                            y += 384
                            
        else:
            sys.exit(0)
        
    else:
        lang = argv[1]
        m = showLang(lang)
        app.setMainWidget(m)
        m.setCaption("PyTQt Example - i18n")
        m.show()
        
    return app.exec_loop()
    
if __name__ == "__main__":
    main(sys.argv)
