/*
 * This file is part of the Polkit-tqt project
 * Copyright (C) 2009 Radek Novacek <rnovacek@redhat.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB. If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef POLKIT_TQT_DETAILS_H
#define POLKIT_TQT_DETAILS_H

#include "polkit-tqt-export.h"

typedef struct _PolkitDetails PolkitDetails;

class TQString;
class TQStringList;


/**
 * \namespace PolkitTQt PolkitTQt
 *
 * \brief Namespace wrapping Polkit-TQt classes
 *
 * This namespace wraps all Polkit-TQt classes.
 */
namespace PolkitTQt
{

/**
 * \class Details polkit-tqt-details.h Details
 * \author Radek Novacek <rnovacek@redhat.com>
 *
 * \brief Class used for passing details around.
 */
class POLKIT_TQT_EXPORT Details
{
  public:
    Details();
    Details(const Details &other);
    ~Details();

    /**
     * Creates Details object from PolkitDetails
     *
     * \warning Use this only if you are completely aware of what are you doing!
     *
     * \param pkDetails PolkitDetails object
     */
    explicit Details(PolkitDetails *pkDetails);

    Details& operator=(const Details &other);

    /**
     * Get the value for \p key
     *
     * \param key A key
     * \return Value of the key \p key, otherwise empty TQString.
     */
    TQString lookup(const TQString &key) const;

    /**
     * Inserts key \p key with value \p value.
     *
     * \param key A key.
     * \param value A value.
     */
    void insert(const TQString &key, const TQString &value);

    /**
     * Gets a list of all keys.
     *
     * \return List of all keys.
     */
    TQStringList keys() const;

  private:
    class Data;
    Data *d;
};

}

#endif
