#!/bin/sh

SCRIPT_DIR=$(dirname $(readlink -f "$0"))

# check user
USERNAME=`whoami`
I_AM_ROOT=n
if [ "${USERNAME}" = "root" ]; then
  I_AM_ROOT=y
fi

# check if polkit files need to be copied
DEST_FILE="/usr/share/polkit-1/actions/org.tqt.policykit.examples.policy"
FILE_EXISTS='n'
if [ -f "${DEST_FILE}" ]; then
  FILE_EXISTS='y'
fi

if [ "${I_AM_ROOT}" = "y" ]; then
  if [ "${FILE_EXISTS}" = "n" ]; then
    cp "${SCRIPT_DIR}/../examples/org.tqt.policykit.examples.policy" "${DEST_FILE}"
  fi
  useradd testuser
  sudo -u testuser $1
  retval=$?
  userdel testuser
  if [ "${FILE_EXISTS}" = "n" ]; then
    rm "${DEST_FILE}"
  fi
else
  if [ "${FILE_EXISTS}" = "y" ]; then
    # Required file already exist, can do the test
    $1
    retval=$?
  else
    echo "This test requires file ${DEST_FILE} to exists. Skipping test."
    retval=0
  fi
fi

if [ ${retval} = 0 ]; then
  echo "Test passed."
else
  echo "Test failed."
fi

exit $retval
