/***************************************************************************
 * eventslot.h
 * This file is part of the KDE project
 * copyright (C)2004-2005 by Sebastian Sauer (mail@dipe.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 ***************************************************************************/

#ifndef KROSS_API_EVENTSLOT_H
#define KROSS_API_EVENTSLOT_H

#include <tqstring.h>
#include <tqobject.h>
#include <ksharedptr.h>

#include "event.h"

namespace Kross { namespace Api {

    /**
     * Each TQt signal and slot connection between a TQObject
     * instance and a functionname is represented with
     * a EventSlot and handled by the \a EventManager.
     */
    class EventSlot : public Event<EventSlot>
    {
        public:

            /**
             * Shared pointer to implement reference-counting.
             */
            typedef TDESharedPtr<EventSlot> Ptr;

            /**
             * Constructor.
             *
             * \param name The name of the EventSlot. The EventSlot
             *       will be accessible by that unique name via
             *       it's parent.
             * \param receiver The receiver of the event.
             * \param slot The slot of the receiver which this
             *       EventSlot points to.
             */
            EventSlot(const TQString& name, TQObject* receiver, TQCString slot);

            /**
             * Destructor.
             */
            virtual ~EventSlot();

            /// \see Kross::Api::Object::getClassName()
            virtual const TQString getClassName() const;

            /// \see Kross::Api::Event::call()
            virtual Object::Ptr call(const TQString& name, TDESharedPtr<List> arguments);

/*
        private:
            EventManager* m_eventmanager;
            TQGuardedPtr<TQObject> m_sender;
            TQCString m_signal;
            TQCString m_slot;
            TQString m_function;
            TQValueList<EventSlot*> m_slots;
        protected:
            void call(const TQVariant&);
        public slots:
            // Stupid signals and slots. To get the passed
            // arguments we need to have all cases of slots
            // avaiable for EventManager::connect() signals.
            void callback();
            void callback(short);
            void callback(int);
            void callback(int, int);
            void callback(int, int, int);
            void callback(int, int, int, int);
            void callback(int, int, int, int, int);
            void callback(int, int, int, int, bool);
            void callback(int, bool);
            void callback(int, int, bool);
            void callback(int, int, const TQString&);
            void callback(uint);
            void callback(long);
            void callback(ulong);
            void callback(double);
            void callback(const char*);
            void callback(bool);
            void callback(const TQString&);
            void callback(const TQString&, int);
            void callback(const TQString&, int, int);
            void callback(const TQString&, uint);
            void callback(const TQString&, bool);
            void callback(const TQString&, bool, bool);
            void callback(const TQString&, bool, int);
            void callback(const TQString&, const TQString&);
            void callback(const TQString&, const TQString&, const TQString&);
            void callback(const TQStringList&);
            void callback(const TQVariant&);
            // The following both slots are more generic to
            // handle Kross::Api::Object instances.
            //void callback(Kross::Api::Object*);
            //void callback(Kross::Api::List*);
*/
        private:
            TQObject* m_receiver;
            TQCString m_slot;
    };

}}

#endif

