#include "KoListStyleStack.h"
#include <KoDom.h>
#include <KoXmlNS.h>

KoListStyleStack::KoListStyleStack()
    : m_initialLevel( 0 )
{
}

KoListStyleStack::~KoListStyleStack()
{
}

void KoListStyleStack::pop()
{
    m_stack.pop();
}

void KoListStyleStack::push( const TQDomElement& style )
{
    m_stack.push( style );
}

void KoListStyleStack::setInitialLevel( int initialLevel )
{
    Q_ASSERT( m_stack.isEmpty() );
    m_initialLevel = initialLevel;
}

TQDomElement KoListStyleStack::currentListStyle() const
{
    Q_ASSERT( !m_stack.isEmpty() );
    return m_stack.top();
}

TQDomElement KoListStyleStack::currentListStyleProperties() const
{
    TQDomElement style = currentListStyle();
    return KoDom::namedItemNS( style, KoXmlNS::style, "list-level-properties" );
}

TQDomElement KoListStyleStack::currentListStyleTextProperties() const
{
    TQDomElement style = currentListStyle();
    return KoDom::namedItemNS( style, KoXmlNS::style, "text-properties" );
}
