/* This file is part of the KDE project
   Copyright (C) 2003 Thomas Zander <zander@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KPTPRESOURCESPANEL_H
#define KPTPRESOURCESPANEL_H

#include "kptresource.h"
#include "resourcespanelbase.h"

#include <tqlistbox.h>
#include <tqstring.h>

class TQListViewItem;
class KCommand;

namespace KPlato
{

class Project;
class GroupItem;
class ResourcesPanelResourceItem;
class ResourcesPanelGroupLVItem;
class Part;

class ResourcesPanel : public ResourcesPanelBase {
    TQ_OBJECT
  
public:
    ResourcesPanel (TQWidget *parent, Project *project);
    
    bool ok();
    KCommand *buildCommand(Part *part);

    void sendChanged();

    void renameStopped(TQListViewItem* item);
    
protected slots:
    void slotAddGroup();
    void slotDeleteGroup();

    void slotAddResource();
    void slotEditResource();
    void slotDeleteResource();

    void slotGroupChanged(TQListViewItem *item);
    void slotGroupChanged();
    void slotResourceRename(const TQString &newName);
    void slotResourceChanged( TQListBoxItem*);
    void slotCurrentChanged( TQListBoxItem*);

    void slotListDoubleClicked(TQListViewItem*, const TQPoint&, int);
    void slotItemRenamed(TQListViewItem *item, int col);
    void slotRenameStarted(TQListViewItem *item, int col);
    void slotStartRename(TQListViewItem *item, int col);
signals:
    void changed();
    void selectionChanged();
    void startRename(TQListViewItem *item, int col);
    void renameStarted(TQListViewItem *item, int col);
    
private:
    Project *project;
    ResourcesPanelGroupLVItem *m_groupItem;

    TQPtrList<GroupItem> m_groupItems;
    TQPtrList<GroupItem> m_deletedGroupItems;

    bool m_blockResourceRename;
    TQListViewItem *m_renameItem;
};

} //KPlato namespace

#endif // PRESOURCESPANEL_H
