/* This file is part of the KDE project
   Copyright (C) 2005 Dag Andersen <danders@get2net.dk>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KPTACCOUNTSVIEWCONFIGDIALOG_H
#define KPTACCOUNTSVIEWCONFIGDIALOG_H


#include <kdialogbase.h>
#include "kptaccountsviewconfigurepanelbase.h"

class TQDate;
class TQString;
class TQWidget;

namespace KPlato
{

class AccountsviewConfigPanel;

class AccountsviewConfigDialog : public KDialogBase {
    TQ_OBJECT
  
public:
    AccountsviewConfigDialog(const TQDate &date, int period, const TQStringList &periodTexts, bool cumulative, TQWidget *parent);

    TQDate date();
    int period();
    TQString periodText();
    bool isCumulative();

private:
    AccountsviewConfigPanel *m_panel;
};

class AccountsviewConfigPanel : public AccountsviewConfigurePanelBase {
    TQ_OBJECT
  
public:
    AccountsviewConfigPanel(TQWidget *parent);
    
public slots:
    void slotChanged();

signals:
    void changed(bool);
};

} //KPlato namespace

#endif // KPTACCOUNTSVIEWCONFIGDIALOG_H
