/* This file is part of the KDE project
   Copyright (C) 2004 Dag Andersen <danders@get2net.dk>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef INTERVALITEM_H
#define INTERVALITEM_H

#include <tqlistview.h>
#include <tqdatetime.h>
#include <tqpair.h>

namespace KPlato
{

class IntervalItem : public TQListViewItem
{
public:
    IntervalItem(TQListView * parent, TQTime start, TQTime end)
    : TQListViewItem(parent, TQString("%1  -  %2").arg(start.toString(), end.toString())),
      m_start(start),
      m_end(end)
    {}
    TQPair<TQTime, TQTime> interval() { return TQPair<TQTime, TQTime>(m_start, m_end); }

private:
    TQTime m_start;
    TQTime m_end;
};

}  //KPlato namespace

#endif /* INTERVALITEM_H */

