/* This file is part of the KDE project
   Copyright (C) 2001, The Karbon Developers
   Copyright (C) 2002, The Karbon Developers

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __VLAYERCMD_H__
#define __VLAYERCMD_H__

#include "vcommand.h"
#include "vobject.h"


class VDocument;
class VLayer;


class VLayerCmd : public VCommand
{
public:
	/**
	 * The different types of layer commands.
	 */
	enum VLayerCmdType
	{
		addLayer,
		raiseLayer,
		lowerLayer,
		deleteLayer
	};

	VLayerCmd( VDocument* doc, const TQString& name, VLayer* layer, VLayerCmdType order );
	virtual ~VLayerCmd() {}
	
	virtual void execute();
	virtual void unexecute();

protected:
	VLayer* m_layer;
	VLayerCmdType m_cmdType;
	VObject::VState m_oldState;
};

#endif

