/*
 * tdeumaskinput.h
 *
 *  Copyright (c) 2013 Timothy Pearson <kb9vqf@pearsoncomputing.net>
 *
 *  Requires the TQt widget libraries
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#ifndef TDE_UMASKINPUT_H
#define TDE_UMASKINPUT_H

#include <knuminput.h>

class TDEUI_EXPORT TDEUmaskInput : public KIntSpinBox
{
	TQ_OBJECT
	
	TQ_PROPERTY( int base READ base WRITE setBase )
	
	public:	
		/**
		*  Constructor.
		*
		*  Constructs a widget with an integer inputline with a little scrollbar
		*  and a slider, with minimal value 0, maximal value 99, step 1, base 10
		*  and initial value 0.
		*/
		TDEUmaskInput( TQWidget *parent=0, const char *name=0);

		/**
		*  Constructor.
		*
		*  Constructs a widget with an integer inputline with a little scrollbar
		*  and a slider.
		*
		*  @param lower  The lowest valid value.
		*  @param upper  The greatest valid value.
		*  @param step   The step size of the scrollbar.
		*  @param value  The actual value.
		*  @param base   The base of the used number system.
		*  @param parent The parent of the widget.
		*  @param name   The Name of the widget.
		*/
		TDEUmaskInput(int lower, int upper, int step, int value, int base = 10, TQWidget* parent = 0, const char* name = 0);
		
		/**
		*  Destructor.
		*/
		virtual ~TDEUmaskInput();

	public:
		/**
		* Sets the base in which the numbers in the spin box are represented.
		*/
		void setBase(int base);

		/**
		* @return the base in which numbers in the spin box are represented.
		*/
		int base() const;

	protected:
		virtual TQString mapValueToText(int);

};

#endif // TDE_UMASKINPUT_H
