//
// C++ Implementation: k9process
//
// Description: 
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "k9process.h"
#include <tqobject.h>
#include <tqapplication.h>
#include <tqeventloop.h>

k9Process::k9Process(TQObject *parent, const char *name)
 : TDEProcess(parent, name),m_waitSync(false)
{
   connect(this,TQ_SIGNAL(processExited( TDEProcess* )),this,TQ_SLOT(slotProcessExited( TDEProcess* )));
 
}


k9Process::~k9Process()
{
}

void k9Process::sync() {
  m_waitSync=true;
  TQApplication::eventLoop()->enterLoop();
}


void k9Process::slotProcessExited( TDEProcess * proc) {
   if (m_waitSync) {
   	TQApplication::eventLoop()->exitLoop();
   	m_waitSync=false;	
   }
}

const TQString & k9Process::debug() {
    m_debug="";
    for (int i=0;i<arguments.count();i++ ){
        m_debug +=" "+ *(arguments.at(i));
    }
    return m_debug;
}

bool  k9Process::start (RunMode runmode, Communication comm) {
  m_elapsed.start();
  return TDEProcess::start(runmode,comm);
}
#include "k9process.moc"


int k9Process::getElapsed() const {
    return m_elapsed.elapsed();
}
