/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef VARIOUSWIDGETS_H
#define VARIOUSWIDGETS_H

#include <tqwidget.h>
#include <kcombobox.h>
#include <tqdialog.h>
#include <kurllabel.h>
#include <tqstring.h>
#include <kdialogbase.h>

class TQLineEdit;
class TDEIconViewItem;
class TQIconViewItem;

class Basket;

/** A widget to select a command to run,
  * with a TQLineEdit and a TQPushButton.
  * @author Sbastien Laot
  */
class RunCommandRequester : public TQWidget
{
  TQ_OBJECT
  
  public:
	RunCommandRequester(const TQString &runCommand, const TQString &message, TQWidget *parent = 0, const char *name = 0);
	~RunCommandRequester();
	TQString runCommand();
	void setRunCommand(const TQString &runCommand);
	TQLineEdit *lineEdit() { return m_runCommand; }
  private slots:
	void slotSelCommand();
  private:
	TQLineEdit *m_runCommand;
	TQString    m_message;
};

/** TQComboBox to ask icon size
  * @author Sbastien Laot
  */
class IconSizeCombo : public TQComboBox
{
  TQ_OBJECT
  
  public:
	IconSizeCombo(bool rw, TQWidget *parent = 0, const char *name = 0);
	~IconSizeCombo();
	int iconSize();
	void setSize(int size);
};

/** A window that the user resize to graphically choose a new image size
  * TODO: Create a SizePushButton or even SizeWidget
  * @author Sbastien Laot
  */
class ViewSizeDialog : public TQDialog
{
  TQ_OBJECT
  
  public:
	ViewSizeDialog(TQWidget *parent, int w, int h);
	~ViewSizeDialog();
  private:
	virtual void resizeEvent(TQResizeEvent *);
	TQWidget *m_sizeGrip;
};

/** A label displaying a link that, once clicked, offer a What's This messageBox to help users.
  * @author Sbastien Laot
  */
class HelpLabel : public KURLLabel
{
  TQ_OBJECT
  
  public:
	HelpLabel(const TQString &text, const TQString &message, TQWidget *parent);
	~HelpLabel();
	TQString message()                       { return m_message;    }
  public slots:
	void setMessage(const TQString &message) { m_message = message; }
	void showMessage();
  protected:
	void keyPressEvent(TQKeyEvent *event);
  private:
	TQString m_message;
};

/** A dialog to choose the size of an icon.
  * @author Sbastien Laot
  */
class IconSizeDialog : public KDialogBase
{
  TQ_OBJECT
  
  public:
	IconSizeDialog(const TQString &caption, const TQString &message, const TQString &icon, int iconSize, TQWidget *parent);
	~IconSizeDialog();
	int iconSize() { return m_iconSize; } /// << @return the choosen icon size (16, 32, ...) or -1 if canceled!
  protected slots:
	void slotCancel();
	void slotSelectionChanged();
	void choose(TQIconViewItem*);
  private:
	TDEIconViewItem *m_size16;
	TDEIconViewItem *m_size22;
	TDEIconViewItem *m_size32;
	TDEIconViewItem *m_size48;
	TDEIconViewItem *m_size64;
	TDEIconViewItem *m_size128;
	int m_iconSize;
};

/**
 * A missing class from KDE (and TQt): a combobox to select a font size!
 */
class FontSizeCombo : public KComboBox
{
  TQ_OBJECT
  
  public:
	FontSizeCombo(bool rw, bool withDefault, TQWidget *parent = 0, const char *name = 0);
	~FontSizeCombo();
	void setFontSize(int size);
	int fontSize();
  protected:
	void keyPressEvent(TQKeyEvent *event);
  signals:
	void sizeChanged(int size);
	void escapePressed();
	void returnPressed2();
  private slots:
	void textChangedInCombo(const TQString &text);
  private:
	bool m_withDefault;
};

#endif // VARIOUSWIDGETS_H
