/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 * 
 * Date        : 2006-10-05
 * Description : a TQListBoxItem which can display an image preview
 *               as a thumbnail and a customized qwhatsthis class 
 *               for listbox items
 * 
 * Copyright (C) 2006-2007 by Guillaume Laurent <glaurent@telegraph-road.org>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#ifndef LISTBOXPREVIEWITEM_H
#define LISTBOXPREVIEWITEM_H

// TQt includes.

#include <tqmap.h>
#include <tqlistbox.h>
#include <tqwhatsthis.h>
#include <tqpixmap.h>

// Local includes.

#include "digikam_export.h"

namespace Digikam
{

class DIGIKAM_EXPORT ListBoxPreviewItem : public TQListBoxPixmap
{

public:

    ListBoxPreviewItem(TQListBox *listbox, const TQPixmap &pix, const TQString &text)
        : TQListBoxPixmap(listbox, pix, text) {};

    ListBoxPreviewItem(const TQPixmap &pix, const TQString &text)
        : TQListBoxPixmap(pix, text) {};

    virtual int height ( const TQListBox * lb ) const;
    virtual int width  ( const TQListBox * lb ) const;
};

/**
 * A qwhatthis class which can be pointed to a specific item
 * in a TQListBox rather than the TQListBox itself
 *
 */
class DIGIKAM_EXPORT ListBoxWhatsThis : public TQWhatsThis 
{

public:

    ListBoxWhatsThis(TQListBox* w) : TQWhatsThis(w), m_listBox(w) {}
    virtual TQString text (const TQPoint &);
    void add(TQListBoxItem*, const TQString& text);

protected:

    TQMap<TQListBoxItem*, TQString>  m_itemWhatsThisMap;
    TQListBox                     *m_listBox;
};

}  // namespace Digikam

#endif  // LISTBOXPREVIEWITEM_H
