/* this file was generated by the MCOP idl compiler - DO NOT EDIT */

#include "artsmodulesmixers.h"

// Implementation
Arts::SimpleMixerChannel_base *Arts::SimpleMixerChannel_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::SimpleMixerChannel_base *castedObject = (Arts::SimpleMixerChannel_base *)skel->_cast(Arts::SimpleMixerChannel_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::SimpleMixerChannel_base *Arts::SimpleMixerChannel_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::SimpleMixerChannel_base::_fromReference(r,true);
	return 0;
}

Arts::SimpleMixerChannel_base *Arts::SimpleMixerChannel_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::SimpleMixerChannel_base *castedObject = (Arts::SimpleMixerChannel_base *)object._base()->_cast(Arts::SimpleMixerChannel_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::SimpleMixerChannel_base *Arts::SimpleMixerChannel_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::SimpleMixerChannel_base *result;
	result = (Arts::SimpleMixerChannel_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::SimpleMixerChannel");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::SimpleMixerChannel_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::SimpleMixerChannel")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::SimpleMixerChannel_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	ret.push_back("inleft");
	ret.push_back("inright");
	return ret;
}
std::vector<std::string> Arts::SimpleMixerChannel_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	ret.push_back("outleft");
	ret.push_back("outright");
	return ret;
}

void *Arts::SimpleMixerChannel_base::_cast(unsigned long iid)
{
	if(iid == Arts::SimpleMixerChannel_base::_IID) return (Arts::SimpleMixerChannel_base *)this;
	if(iid == Arts::Environment::MixerChannel_base::_IID) return (Arts::Environment::MixerChannel_base *)this;
	if(iid == Arts::StereoEffect_base::_IID) return (Arts::StereoEffect_base *)this;
	if(iid == Arts::SynthModule_base::_IID) return (Arts::SynthModule_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::SimpleMixerChannel_stub::SimpleMixerChannel_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::SimpleMixerChannel_stub::SimpleMixerChannel_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

Arts::Synth_STD_EQUALIZER Arts::SimpleMixerChannel_stub::equalizerLeft()
{
	long methodID = _lookupMethodFast("method:000000135f6765745f657175616c697a65724c656674000000001a417274733a3a53796e74685f5354445f455155414c495a455200000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if (!result) return Arts::Synth_STD_EQUALIZER::null();
	Arts::Synth_STD_EQUALIZER_base* returnCode;
	Arts::readObject(*result,returnCode);
	delete result;
	return Arts::Synth_STD_EQUALIZER::_from_base(returnCode);
}

Arts::Synth_STD_EQUALIZER Arts::SimpleMixerChannel_stub::equalizerRight()
{
	long methodID = _lookupMethodFast("method:000000145f6765745f657175616c697a65725269676874000000001a417274733a3a53796e74685f5354445f455155414c495a455200000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if (!result) return Arts::Synth_STD_EQUALIZER::null();
	Arts::Synth_STD_EQUALIZER_base* returnCode;
	Arts::readObject(*result,returnCode);
	delete result;
	return Arts::Synth_STD_EQUALIZER::_from_base(returnCode);
}

Arts::StereoEffectStack Arts::SimpleMixerChannel_stub::insertEffects()
{
	long methodID = _lookupMethodFast("method:000000135f6765745f696e73657274456666656374730000000018417274733a3a53746572656f456666656374537461636b00000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if (!result) return Arts::StereoEffectStack::null();
	Arts::StereoEffectStack_base* returnCode;
	Arts::readObject(*result,returnCode);
	delete result;
	return Arts::StereoEffectStack::_from_base(returnCode);
}

float Arts::SimpleMixerChannel_stub::gainLeft()
{
	long methodID = _lookupMethodFast("method:0000000e5f6765745f6761696e4c6566740000000006666c6f617400000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0.0; // error occurred
	float returnCode = result->readFloat();
	delete result;
	return returnCode;
}

void Arts::SimpleMixerChannel_stub::gainLeft(float newValue)
{
	long methodID = _lookupMethodFast("method:0000000e5f7365745f6761696e4c6566740000000005766f696400000000020000000100000006666c6f617400000000096e657756616c7565000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeFloat(newValue);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

float Arts::SimpleMixerChannel_stub::gainRight()
{
	long methodID = _lookupMethodFast("method:0000000f5f6765745f6761696e52696768740000000006666c6f617400000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0.0; // error occurred
	float returnCode = result->readFloat();
	delete result;
	return returnCode;
}

void Arts::SimpleMixerChannel_stub::gainRight(float newValue)
{
	long methodID = _lookupMethodFast("method:0000000f5f7365745f6761696e52696768740000000005766f696400000000020000000100000006666c6f617400000000096e657756616c7565000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeFloat(newValue);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

float Arts::SimpleMixerChannel_stub::pan()
{
	long methodID = _lookupMethodFast("method:000000095f6765745f70616e0000000006666c6f617400000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0.0; // error occurred
	float returnCode = result->readFloat();
	delete result;
	return returnCode;
}

void Arts::SimpleMixerChannel_stub::pan(float newValue)
{
	long methodID = _lookupMethodFast("method:000000095f7365745f70616e0000000005766f696400000000020000000100000006666c6f617400000000096e657756616c7565000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeFloat(newValue);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

float Arts::SimpleMixerChannel_stub::volumeLeft()
{
	long methodID = _lookupMethodFast("method:000000105f6765745f766f6c756d654c6566740000000006666c6f617400000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0.0; // error occurred
	float returnCode = result->readFloat();
	delete result;
	return returnCode;
}

void Arts::SimpleMixerChannel_stub::volumeLeft(float newValue)
{
	long methodID = _lookupMethodFast("method:000000105f7365745f766f6c756d654c6566740000000005766f696400000000020000000100000006666c6f617400000000096e657756616c7565000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeFloat(newValue);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

float Arts::SimpleMixerChannel_stub::volumeRight()
{
	long methodID = _lookupMethodFast("method:000000115f6765745f766f6c756d6552696768740000000006666c6f617400000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0.0; // error occurred
	float returnCode = result->readFloat();
	delete result;
	return returnCode;
}

void Arts::SimpleMixerChannel_stub::volumeRight(float newValue)
{
	long methodID = _lookupMethodFast("method:000000115f7365745f766f6c756d6552696768740000000005766f696400000000020000000100000006666c6f617400000000096e657756616c7565000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeFloat(newValue);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

std::string Arts::SimpleMixerChannel_skel::_interfaceName()
{
	return "Arts::SimpleMixerChannel";
}

bool Arts::SimpleMixerChannel_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::SimpleMixerChannel") return true;
	if (interfacename == "Arts::Environment::MixerChannel") return true;
	if (interfacename == "Arts::StereoEffect") return true;
	if (interfacename == "Arts::SynthModule") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::SimpleMixerChannel_skel::_interfaceNameSkel()
{
	return "Arts::SimpleMixerChannel";
}

// _get_equalizerLeft
static void _dispatch_Arts_SimpleMixerChannel_00(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	Arts::Synth_STD_EQUALIZER returnCode = ((Arts::SimpleMixerChannel_skel *)object)->equalizerLeft();
	Arts::writeObject(*result,returnCode._base());
}

// _get_equalizerRight
static void _dispatch_Arts_SimpleMixerChannel_01(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	Arts::Synth_STD_EQUALIZER returnCode = ((Arts::SimpleMixerChannel_skel *)object)->equalizerRight();
	Arts::writeObject(*result,returnCode._base());
}

// _get_insertEffects
static void _dispatch_Arts_SimpleMixerChannel_02(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	Arts::StereoEffectStack returnCode = ((Arts::SimpleMixerChannel_skel *)object)->insertEffects();
	Arts::writeObject(*result,returnCode._base());
}

// _get_gainLeft
static void _dispatch_Arts_SimpleMixerChannel_03(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeFloat(((Arts::SimpleMixerChannel_skel *)object)->gainLeft());
}

// _set_gainLeft
static void _dispatch_Arts_SimpleMixerChannel_04(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	float newValue = request->readFloat();
	((Arts::SimpleMixerChannel_skel *)object)->gainLeft(newValue);
}

// _get_gainRight
static void _dispatch_Arts_SimpleMixerChannel_05(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeFloat(((Arts::SimpleMixerChannel_skel *)object)->gainRight());
}

// _set_gainRight
static void _dispatch_Arts_SimpleMixerChannel_06(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	float newValue = request->readFloat();
	((Arts::SimpleMixerChannel_skel *)object)->gainRight(newValue);
}

// _get_pan
static void _dispatch_Arts_SimpleMixerChannel_07(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeFloat(((Arts::SimpleMixerChannel_skel *)object)->pan());
}

// _set_pan
static void _dispatch_Arts_SimpleMixerChannel_08(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	float newValue = request->readFloat();
	((Arts::SimpleMixerChannel_skel *)object)->pan(newValue);
}

// _get_volumeLeft
static void _dispatch_Arts_SimpleMixerChannel_09(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeFloat(((Arts::SimpleMixerChannel_skel *)object)->volumeLeft());
}

// _set_volumeLeft
static void _dispatch_Arts_SimpleMixerChannel_10(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	float newValue = request->readFloat();
	((Arts::SimpleMixerChannel_skel *)object)->volumeLeft(newValue);
}

// _get_volumeRight
static void _dispatch_Arts_SimpleMixerChannel_11(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeFloat(((Arts::SimpleMixerChannel_skel *)object)->volumeRight());
}

// _set_volumeRight
static void _dispatch_Arts_SimpleMixerChannel_12(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	float newValue = request->readFloat();
	((Arts::SimpleMixerChannel_skel *)object)->volumeRight(newValue);
}

void Arts::SimpleMixerChannel_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:000000135f6765745f657175616c697a65724c656674000000001a"
        "417274733a3a53796e74685f5354445f455155414c495a45520000000002000000"
        "0000000000000000145f6765745f657175616c697a65725269676874000000001a"
        "417274733a3a53796e74685f5354445f455155414c495a45520000000002000000"
        "0000000000000000135f6765745f696e7365727445666665637473000000001841"
        "7274733a3a53746572656f456666656374537461636b0000000002000000000000"
        "00000000000e5f6765745f6761696e4c6566740000000006666c6f617400000000"
        "0200000000000000000000000e5f7365745f6761696e4c6566740000000005766f"
        "696400000000020000000100000006666c6f617400000000096e657756616c7565"
        "0000000000000000000000000f5f6765745f6761696e5269676874000000000666"
        "6c6f6174000000000200000000000000000000000f5f7365745f6761696e526967"
        "68740000000005766f696400000000020000000100000006666c6f617400000000"
        "096e657756616c7565000000000000000000000000095f6765745f70616e000000"
        "0006666c6f617400000000020000000000000000000000095f7365745f70616e00"
        "00000005766f696400000000020000000100000006666c6f617400000000096e65"
        "7756616c7565000000000000000000000000105f6765745f766f6c756d654c6566"
        "740000000006666c6f617400000000020000000000000000000000105f7365745f"
        "766f6c756d654c6566740000000005766f69640000000002000000010000000666"
        "6c6f617400000000096e657756616c7565000000000000000000000000115f6765"
        "745f766f6c756d6552696768740000000006666c6f617400000000020000000000"
        "000000000000115f7365745f766f6c756d6552696768740000000005766f696400"
        "000000020000000100000006666c6f617400000000096e657756616c7565000000"
        "000000000000",
		"MethodTable"
	);
	_addMethod(_dispatch_Arts_SimpleMixerChannel_00,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SimpleMixerChannel_01,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SimpleMixerChannel_02,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SimpleMixerChannel_03,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SimpleMixerChannel_04,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SimpleMixerChannel_05,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SimpleMixerChannel_06,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SimpleMixerChannel_07,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SimpleMixerChannel_08,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SimpleMixerChannel_09,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SimpleMixerChannel_10,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SimpleMixerChannel_11,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_SimpleMixerChannel_12,this,Arts::MethodDef(m));
	Arts::Environment::MixerChannel_skel::_buildMethodTable();
}

Arts::SimpleMixerChannel_skel::SimpleMixerChannel_skel()
{
}

Arts::Object_base* Arts::SimpleMixerChannel::_Creator() {
	return Arts::SimpleMixerChannel_base::_create();
}

unsigned long Arts::SimpleMixerChannel_base::_IID = Arts::MCOPUtils::makeIID("Arts::SimpleMixerChannel");

Arts::SimpleMixerChannelGuiFactory_base *Arts::SimpleMixerChannelGuiFactory_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::SimpleMixerChannelGuiFactory_base *castedObject = (Arts::SimpleMixerChannelGuiFactory_base *)skel->_cast(Arts::SimpleMixerChannelGuiFactory_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::SimpleMixerChannelGuiFactory_base *Arts::SimpleMixerChannelGuiFactory_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::SimpleMixerChannelGuiFactory_base::_fromReference(r,true);
	return 0;
}

Arts::SimpleMixerChannelGuiFactory_base *Arts::SimpleMixerChannelGuiFactory_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::SimpleMixerChannelGuiFactory_base *castedObject = (Arts::SimpleMixerChannelGuiFactory_base *)object._base()->_cast(Arts::SimpleMixerChannelGuiFactory_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::SimpleMixerChannelGuiFactory_base *Arts::SimpleMixerChannelGuiFactory_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::SimpleMixerChannelGuiFactory_base *result;
	result = (Arts::SimpleMixerChannelGuiFactory_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::SimpleMixerChannelGuiFactory");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::SimpleMixerChannelGuiFactory_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::SimpleMixerChannelGuiFactory")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::SimpleMixerChannelGuiFactory_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> Arts::SimpleMixerChannelGuiFactory_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *Arts::SimpleMixerChannelGuiFactory_base::_cast(unsigned long iid)
{
	if(iid == Arts::SimpleMixerChannelGuiFactory_base::_IID) return (Arts::SimpleMixerChannelGuiFactory_base *)this;
	if(iid == Arts::GuiFactory_base::_IID) return (Arts::GuiFactory_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::SimpleMixerChannelGuiFactory_stub::SimpleMixerChannelGuiFactory_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::SimpleMixerChannelGuiFactory_stub::SimpleMixerChannelGuiFactory_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

std::string Arts::SimpleMixerChannelGuiFactory_skel::_interfaceName()
{
	return "Arts::SimpleMixerChannelGuiFactory";
}

bool Arts::SimpleMixerChannelGuiFactory_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::SimpleMixerChannelGuiFactory") return true;
	if (interfacename == "Arts::GuiFactory") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::SimpleMixerChannelGuiFactory_skel::_interfaceNameSkel()
{
	return "Arts::SimpleMixerChannelGuiFactory";
}

void Arts::SimpleMixerChannelGuiFactory_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:",
		"MethodTable"
	);
	Arts::GuiFactory_skel::_buildMethodTable();
}

Arts::SimpleMixerChannelGuiFactory_skel::SimpleMixerChannelGuiFactory_skel()
{
}

Arts::Object_base* Arts::SimpleMixerChannelGuiFactory::_Creator() {
	return Arts::SimpleMixerChannelGuiFactory_base::_create();
}

unsigned long Arts::SimpleMixerChannelGuiFactory_base::_IID = Arts::MCOPUtils::makeIID("Arts::SimpleMixerChannelGuiFactory");

Arts::MonoSimpleMixerChannel_base *Arts::MonoSimpleMixerChannel_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::MonoSimpleMixerChannel_base *castedObject = (Arts::MonoSimpleMixerChannel_base *)skel->_cast(Arts::MonoSimpleMixerChannel_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::MonoSimpleMixerChannel_base *Arts::MonoSimpleMixerChannel_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::MonoSimpleMixerChannel_base::_fromReference(r,true);
	return 0;
}

Arts::MonoSimpleMixerChannel_base *Arts::MonoSimpleMixerChannel_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::MonoSimpleMixerChannel_base *castedObject = (Arts::MonoSimpleMixerChannel_base *)object._base()->_cast(Arts::MonoSimpleMixerChannel_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::MonoSimpleMixerChannel_base *Arts::MonoSimpleMixerChannel_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::MonoSimpleMixerChannel_base *result;
	result = (Arts::MonoSimpleMixerChannel_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::MonoSimpleMixerChannel");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::MonoSimpleMixerChannel_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::MonoSimpleMixerChannel")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::MonoSimpleMixerChannel_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	ret.push_back("inleft");
	ret.push_back("inright");
	return ret;
}
std::vector<std::string> Arts::MonoSimpleMixerChannel_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	ret.push_back("outleft");
	ret.push_back("outright");
	return ret;
}

void *Arts::MonoSimpleMixerChannel_base::_cast(unsigned long iid)
{
	if(iid == Arts::MonoSimpleMixerChannel_base::_IID) return (Arts::MonoSimpleMixerChannel_base *)this;
	if(iid == Arts::Environment::MixerChannel_base::_IID) return (Arts::Environment::MixerChannel_base *)this;
	if(iid == Arts::StereoEffect_base::_IID) return (Arts::StereoEffect_base *)this;
	if(iid == Arts::SynthModule_base::_IID) return (Arts::SynthModule_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::MonoSimpleMixerChannel_stub::MonoSimpleMixerChannel_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::MonoSimpleMixerChannel_stub::MonoSimpleMixerChannel_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

Arts::Synth_STD_EQUALIZER Arts::MonoSimpleMixerChannel_stub::equalizer()
{
	long methodID = _lookupMethodFast("method:0000000f5f6765745f657175616c697a6572000000001a417274733a3a53796e74685f5354445f455155414c495a455200000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if (!result) return Arts::Synth_STD_EQUALIZER::null();
	Arts::Synth_STD_EQUALIZER_base* returnCode;
	Arts::readObject(*result,returnCode);
	delete result;
	return Arts::Synth_STD_EQUALIZER::_from_base(returnCode);
}

Arts::StereoEffectStack Arts::MonoSimpleMixerChannel_stub::insertEffects()
{
	long methodID = _lookupMethodFast("method:000000135f6765745f696e73657274456666656374730000000018417274733a3a53746572656f456666656374537461636b00000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if (!result) return Arts::StereoEffectStack::null();
	Arts::StereoEffectStack_base* returnCode;
	Arts::readObject(*result,returnCode);
	delete result;
	return Arts::StereoEffectStack::_from_base(returnCode);
}

float Arts::MonoSimpleMixerChannel_stub::gain()
{
	long methodID = _lookupMethodFast("method:0000000a5f6765745f6761696e0000000006666c6f617400000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0.0; // error occurred
	float returnCode = result->readFloat();
	delete result;
	return returnCode;
}

void Arts::MonoSimpleMixerChannel_stub::gain(float newValue)
{
	long methodID = _lookupMethodFast("method:0000000a5f7365745f6761696e0000000005766f696400000000020000000100000006666c6f617400000000096e657756616c7565000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeFloat(newValue);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

float Arts::MonoSimpleMixerChannel_stub::pan()
{
	long methodID = _lookupMethodFast("method:000000095f6765745f70616e0000000006666c6f617400000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0.0; // error occurred
	float returnCode = result->readFloat();
	delete result;
	return returnCode;
}

void Arts::MonoSimpleMixerChannel_stub::pan(float newValue)
{
	long methodID = _lookupMethodFast("method:000000095f7365745f70616e0000000005766f696400000000020000000100000006666c6f617400000000096e657756616c7565000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeFloat(newValue);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

float Arts::MonoSimpleMixerChannel_stub::volume()
{
	long methodID = _lookupMethodFast("method:0000000c5f6765745f766f6c756d650000000006666c6f617400000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0.0; // error occurred
	float returnCode = result->readFloat();
	delete result;
	return returnCode;
}

void Arts::MonoSimpleMixerChannel_stub::volume(float newValue)
{
	long methodID = _lookupMethodFast("method:0000000c5f7365745f766f6c756d650000000005766f696400000000020000000100000006666c6f617400000000096e657756616c7565000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeFloat(newValue);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

std::string Arts::MonoSimpleMixerChannel_skel::_interfaceName()
{
	return "Arts::MonoSimpleMixerChannel";
}

bool Arts::MonoSimpleMixerChannel_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::MonoSimpleMixerChannel") return true;
	if (interfacename == "Arts::Environment::MixerChannel") return true;
	if (interfacename == "Arts::StereoEffect") return true;
	if (interfacename == "Arts::SynthModule") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::MonoSimpleMixerChannel_skel::_interfaceNameSkel()
{
	return "Arts::MonoSimpleMixerChannel";
}

// _get_equalizer
static void _dispatch_Arts_MonoSimpleMixerChannel_00(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	Arts::Synth_STD_EQUALIZER returnCode = ((Arts::MonoSimpleMixerChannel_skel *)object)->equalizer();
	Arts::writeObject(*result,returnCode._base());
}

// _get_insertEffects
static void _dispatch_Arts_MonoSimpleMixerChannel_01(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	Arts::StereoEffectStack returnCode = ((Arts::MonoSimpleMixerChannel_skel *)object)->insertEffects();
	Arts::writeObject(*result,returnCode._base());
}

// _get_gain
static void _dispatch_Arts_MonoSimpleMixerChannel_02(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeFloat(((Arts::MonoSimpleMixerChannel_skel *)object)->gain());
}

// _set_gain
static void _dispatch_Arts_MonoSimpleMixerChannel_03(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	float newValue = request->readFloat();
	((Arts::MonoSimpleMixerChannel_skel *)object)->gain(newValue);
}

// _get_pan
static void _dispatch_Arts_MonoSimpleMixerChannel_04(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeFloat(((Arts::MonoSimpleMixerChannel_skel *)object)->pan());
}

// _set_pan
static void _dispatch_Arts_MonoSimpleMixerChannel_05(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	float newValue = request->readFloat();
	((Arts::MonoSimpleMixerChannel_skel *)object)->pan(newValue);
}

// _get_volume
static void _dispatch_Arts_MonoSimpleMixerChannel_06(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeFloat(((Arts::MonoSimpleMixerChannel_skel *)object)->volume());
}

// _set_volume
static void _dispatch_Arts_MonoSimpleMixerChannel_07(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	float newValue = request->readFloat();
	((Arts::MonoSimpleMixerChannel_skel *)object)->volume(newValue);
}

void Arts::MonoSimpleMixerChannel_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:0000000f5f6765745f657175616c697a6572000000001a41727473"
        "3a3a53796e74685f5354445f455155414c495a4552000000000200000000000000"
        "00000000135f6765745f696e73657274456666656374730000000018417274733a"
        "3a53746572656f456666656374537461636b000000000200000000000000000000"
        "000a5f6765745f6761696e0000000006666c6f6174000000000200000000000000"
        "000000000a5f7365745f6761696e0000000005766f696400000000020000000100"
        "000006666c6f617400000000096e657756616c7565000000000000000000000000"
        "095f6765745f70616e0000000006666c6f61740000000002000000000000000000"
        "0000095f7365745f70616e0000000005766f696400000000020000000100000006"
        "666c6f617400000000096e657756616c75650000000000000000000000000c5f67"
        "65745f766f6c756d650000000006666c6f61740000000002000000000000000000"
        "00000c5f7365745f766f6c756d650000000005766f696400000000020000000100"
        "000006666c6f617400000000096e657756616c7565000000000000000000",
		"MethodTable"
	);
	_addMethod(_dispatch_Arts_MonoSimpleMixerChannel_00,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_MonoSimpleMixerChannel_01,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_MonoSimpleMixerChannel_02,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_MonoSimpleMixerChannel_03,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_MonoSimpleMixerChannel_04,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_MonoSimpleMixerChannel_05,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_MonoSimpleMixerChannel_06,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_MonoSimpleMixerChannel_07,this,Arts::MethodDef(m));
	Arts::Environment::MixerChannel_skel::_buildMethodTable();
}

Arts::MonoSimpleMixerChannel_skel::MonoSimpleMixerChannel_skel()
{
}

Arts::Object_base* Arts::MonoSimpleMixerChannel::_Creator() {
	return Arts::MonoSimpleMixerChannel_base::_create();
}

unsigned long Arts::MonoSimpleMixerChannel_base::_IID = Arts::MCOPUtils::makeIID("Arts::MonoSimpleMixerChannel");

Arts::MonoSimpleMixerChannelGuiFactory_base *Arts::MonoSimpleMixerChannelGuiFactory_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::MonoSimpleMixerChannelGuiFactory_base *castedObject = (Arts::MonoSimpleMixerChannelGuiFactory_base *)skel->_cast(Arts::MonoSimpleMixerChannelGuiFactory_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::MonoSimpleMixerChannelGuiFactory_base *Arts::MonoSimpleMixerChannelGuiFactory_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::MonoSimpleMixerChannelGuiFactory_base::_fromReference(r,true);
	return 0;
}

Arts::MonoSimpleMixerChannelGuiFactory_base *Arts::MonoSimpleMixerChannelGuiFactory_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::MonoSimpleMixerChannelGuiFactory_base *castedObject = (Arts::MonoSimpleMixerChannelGuiFactory_base *)object._base()->_cast(Arts::MonoSimpleMixerChannelGuiFactory_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::MonoSimpleMixerChannelGuiFactory_base *Arts::MonoSimpleMixerChannelGuiFactory_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::MonoSimpleMixerChannelGuiFactory_base *result;
	result = (Arts::MonoSimpleMixerChannelGuiFactory_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::MonoSimpleMixerChannelGuiFactory");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::MonoSimpleMixerChannelGuiFactory_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::MonoSimpleMixerChannelGuiFactory")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::MonoSimpleMixerChannelGuiFactory_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> Arts::MonoSimpleMixerChannelGuiFactory_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *Arts::MonoSimpleMixerChannelGuiFactory_base::_cast(unsigned long iid)
{
	if(iid == Arts::MonoSimpleMixerChannelGuiFactory_base::_IID) return (Arts::MonoSimpleMixerChannelGuiFactory_base *)this;
	if(iid == Arts::GuiFactory_base::_IID) return (Arts::GuiFactory_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::MonoSimpleMixerChannelGuiFactory_stub::MonoSimpleMixerChannelGuiFactory_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::MonoSimpleMixerChannelGuiFactory_stub::MonoSimpleMixerChannelGuiFactory_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

std::string Arts::MonoSimpleMixerChannelGuiFactory_skel::_interfaceName()
{
	return "Arts::MonoSimpleMixerChannelGuiFactory";
}

bool Arts::MonoSimpleMixerChannelGuiFactory_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::MonoSimpleMixerChannelGuiFactory") return true;
	if (interfacename == "Arts::GuiFactory") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::MonoSimpleMixerChannelGuiFactory_skel::_interfaceNameSkel()
{
	return "Arts::MonoSimpleMixerChannelGuiFactory";
}

void Arts::MonoSimpleMixerChannelGuiFactory_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:",
		"MethodTable"
	);
	Arts::GuiFactory_skel::_buildMethodTable();
}

Arts::MonoSimpleMixerChannelGuiFactory_skel::MonoSimpleMixerChannelGuiFactory_skel()
{
}

Arts::Object_base* Arts::MonoSimpleMixerChannelGuiFactory::_Creator() {
	return Arts::MonoSimpleMixerChannelGuiFactory_base::_create();
}

unsigned long Arts::MonoSimpleMixerChannelGuiFactory_base::_IID = Arts::MCOPUtils::makeIID("Arts::MonoSimpleMixerChannelGuiFactory");

Arts::Synth_AUX_BUS_base *Arts::Synth_AUX_BUS_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::Synth_AUX_BUS_base *castedObject = (Arts::Synth_AUX_BUS_base *)skel->_cast(Arts::Synth_AUX_BUS_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::Synth_AUX_BUS_base *Arts::Synth_AUX_BUS_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::Synth_AUX_BUS_base::_fromReference(r,true);
	return 0;
}

Arts::Synth_AUX_BUS_base *Arts::Synth_AUX_BUS_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::Synth_AUX_BUS_base *castedObject = (Arts::Synth_AUX_BUS_base *)object._base()->_cast(Arts::Synth_AUX_BUS_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::Synth_AUX_BUS_base *Arts::Synth_AUX_BUS_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::Synth_AUX_BUS_base *result;
	result = (Arts::Synth_AUX_BUS_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::Synth_AUX_BUS");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::Synth_AUX_BUS_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::Synth_AUX_BUS")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::Synth_AUX_BUS_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	ret.push_back("invalue");
	return ret;
}
std::vector<std::string> Arts::Synth_AUX_BUS_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *Arts::Synth_AUX_BUS_base::_cast(unsigned long iid)
{
	if(iid == Arts::Synth_AUX_BUS_base::_IID) return (Arts::Synth_AUX_BUS_base *)this;
	if(iid == Arts::SynthModule_base::_IID) return (Arts::SynthModule_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::Synth_AUX_BUS_stub::Synth_AUX_BUS_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::Synth_AUX_BUS_stub::Synth_AUX_BUS_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

float Arts::Synth_AUX_BUS_stub::level()
{
	long methodID = _lookupMethodFast("method:0000000b5f6765745f6c6576656c0000000006666c6f617400000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0.0; // error occurred
	float returnCode = result->readFloat();
	delete result;
	return returnCode;
}

void Arts::Synth_AUX_BUS_stub::level(float newValue)
{
	long methodID = _lookupMethodFast("method:0000000b5f7365745f6c6576656c0000000005766f696400000000020000000100000006666c6f617400000000096e657756616c7565000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeFloat(newValue);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

long Arts::Synth_AUX_BUS_stub::channel()
{
	long methodID = _lookupMethodFast("method:0000000d5f6765745f6368616e6e656c00000000056c6f6e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0; // error occurred
	long returnCode = result->readLong();
	delete result;
	return returnCode;
}

void Arts::Synth_AUX_BUS_stub::channel(long newValue)
{
	long methodID = _lookupMethodFast("method:0000000d5f7365745f6368616e6e656c0000000005766f6964000000000200000001000000056c6f6e6700000000096e657756616c7565000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeLong(newValue);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

std::string Arts::Synth_AUX_BUS_skel::_interfaceName()
{
	return "Arts::Synth_AUX_BUS";
}

bool Arts::Synth_AUX_BUS_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::Synth_AUX_BUS") return true;
	if (interfacename == "Arts::SynthModule") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::Synth_AUX_BUS_skel::_interfaceNameSkel()
{
	return "Arts::Synth_AUX_BUS";
}

// _get_level
static void _dispatch_Arts_Synth_AUX_BUS_00(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeFloat(((Arts::Synth_AUX_BUS_skel *)object)->level());
}

// _set_level
static void _dispatch_Arts_Synth_AUX_BUS_01(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	float newValue = request->readFloat();
	((Arts::Synth_AUX_BUS_skel *)object)->level(newValue);
}

// _get_channel
static void _dispatch_Arts_Synth_AUX_BUS_02(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeLong(((Arts::Synth_AUX_BUS_skel *)object)->channel());
}

// _set_channel
static void _dispatch_Arts_Synth_AUX_BUS_03(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	long newValue = request->readLong();
	((Arts::Synth_AUX_BUS_skel *)object)->channel(newValue);
}

void Arts::Synth_AUX_BUS_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:0000000b5f6765745f6c6576656c0000000006666c6f6174000000"
        "000200000000000000000000000b5f7365745f6c6576656c0000000005766f6964"
        "00000000020000000100000006666c6f617400000000096e657756616c75650000"
        "000000000000000000000d5f6765745f6368616e6e656c00000000056c6f6e6700"
        "0000000200000000000000000000000d5f7365745f6368616e6e656c0000000005"
        "766f6964000000000200000001000000056c6f6e6700000000096e657756616c75"
        "65000000000000000000",
		"MethodTable"
	);
	_addMethod(_dispatch_Arts_Synth_AUX_BUS_00,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_Synth_AUX_BUS_01,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_Synth_AUX_BUS_02,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_Synth_AUX_BUS_03,this,Arts::MethodDef(m));
	Arts::SynthModule_skel::_buildMethodTable();
}

Arts::Synth_AUX_BUS_skel::Synth_AUX_BUS_skel()
{
	_initStream("invalue",&invalue,9);
}

Arts::Object_base* Arts::Synth_AUX_BUS::_Creator() {
	return Arts::Synth_AUX_BUS_base::_create();
}

unsigned long Arts::Synth_AUX_BUS_base::_IID = Arts::MCOPUtils::makeIID("Arts::Synth_AUX_BUS");

Arts::LittleStereoMixerChannel_base *Arts::LittleStereoMixerChannel_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::LittleStereoMixerChannel_base *castedObject = (Arts::LittleStereoMixerChannel_base *)skel->_cast(Arts::LittleStereoMixerChannel_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::LittleStereoMixerChannel_base *Arts::LittleStereoMixerChannel_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::LittleStereoMixerChannel_base::_fromReference(r,true);
	return 0;
}

Arts::LittleStereoMixerChannel_base *Arts::LittleStereoMixerChannel_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::LittleStereoMixerChannel_base *castedObject = (Arts::LittleStereoMixerChannel_base *)object._base()->_cast(Arts::LittleStereoMixerChannel_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::LittleStereoMixerChannel_base *Arts::LittleStereoMixerChannel_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::LittleStereoMixerChannel_base *result;
	result = (Arts::LittleStereoMixerChannel_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::LittleStereoMixerChannel");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::LittleStereoMixerChannel_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::LittleStereoMixerChannel")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::LittleStereoMixerChannel_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	ret.push_back("inleft");
	ret.push_back("inright");
	return ret;
}
std::vector<std::string> Arts::LittleStereoMixerChannel_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	ret.push_back("outleft");
	ret.push_back("outright");
	return ret;
}

void *Arts::LittleStereoMixerChannel_base::_cast(unsigned long iid)
{
	if(iid == Arts::LittleStereoMixerChannel_base::_IID) return (Arts::LittleStereoMixerChannel_base *)this;
	if(iid == Arts::Environment::MixerChannel_base::_IID) return (Arts::Environment::MixerChannel_base *)this;
	if(iid == Arts::StereoEffect_base::_IID) return (Arts::StereoEffect_base *)this;
	if(iid == Arts::SynthModule_base::_IID) return (Arts::SynthModule_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::LittleStereoMixerChannel_stub::LittleStereoMixerChannel_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::LittleStereoMixerChannel_stub::LittleStereoMixerChannel_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

float Arts::LittleStereoMixerChannel_stub::volume()
{
	long methodID = _lookupMethodFast("method:0000000c5f6765745f766f6c756d650000000006666c6f617400000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0.0; // error occurred
	float returnCode = result->readFloat();
	delete result;
	return returnCode;
}

void Arts::LittleStereoMixerChannel_stub::volume(float newValue)
{
	long methodID = _lookupMethodFast("method:0000000c5f7365745f766f6c756d650000000005766f696400000000020000000100000006666c6f617400000000096e657756616c7565000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeFloat(newValue);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

float Arts::LittleStereoMixerChannel_stub::balance()
{
	long methodID = _lookupMethodFast("method:0000000d5f6765745f62616c616e63650000000006666c6f617400000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0.0; // error occurred
	float returnCode = result->readFloat();
	delete result;
	return returnCode;
}

void Arts::LittleStereoMixerChannel_stub::balance(float newValue)
{
	long methodID = _lookupMethodFast("method:0000000d5f7365745f62616c616e63650000000005766f696400000000020000000100000006666c6f617400000000096e657756616c7565000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeFloat(newValue);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

std::string Arts::LittleStereoMixerChannel_skel::_interfaceName()
{
	return "Arts::LittleStereoMixerChannel";
}

bool Arts::LittleStereoMixerChannel_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::LittleStereoMixerChannel") return true;
	if (interfacename == "Arts::Environment::MixerChannel") return true;
	if (interfacename == "Arts::StereoEffect") return true;
	if (interfacename == "Arts::SynthModule") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::LittleStereoMixerChannel_skel::_interfaceNameSkel()
{
	return "Arts::LittleStereoMixerChannel";
}

// _get_volume
static void _dispatch_Arts_LittleStereoMixerChannel_00(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeFloat(((Arts::LittleStereoMixerChannel_skel *)object)->volume());
}

// _set_volume
static void _dispatch_Arts_LittleStereoMixerChannel_01(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	float newValue = request->readFloat();
	((Arts::LittleStereoMixerChannel_skel *)object)->volume(newValue);
}

// _get_balance
static void _dispatch_Arts_LittleStereoMixerChannel_02(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeFloat(((Arts::LittleStereoMixerChannel_skel *)object)->balance());
}

// _set_balance
static void _dispatch_Arts_LittleStereoMixerChannel_03(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	float newValue = request->readFloat();
	((Arts::LittleStereoMixerChannel_skel *)object)->balance(newValue);
}

void Arts::LittleStereoMixerChannel_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:0000000c5f6765745f766f6c756d650000000006666c6f61740000"
        "00000200000000000000000000000c5f7365745f766f6c756d650000000005766f"
        "696400000000020000000100000006666c6f617400000000096e657756616c7565"
        "0000000000000000000000000d5f6765745f62616c616e63650000000006666c6f"
        "6174000000000200000000000000000000000d5f7365745f62616c616e63650000"
        "000005766f696400000000020000000100000006666c6f617400000000096e6577"
        "56616c7565000000000000000000",
		"MethodTable"
	);
	_addMethod(_dispatch_Arts_LittleStereoMixerChannel_00,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_LittleStereoMixerChannel_01,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_LittleStereoMixerChannel_02,this,Arts::MethodDef(m));
	_addMethod(_dispatch_Arts_LittleStereoMixerChannel_03,this,Arts::MethodDef(m));
	Arts::Environment::MixerChannel_skel::_buildMethodTable();
}

Arts::LittleStereoMixerChannel_skel::LittleStereoMixerChannel_skel()
{
}

Arts::Object_base* Arts::LittleStereoMixerChannel::_Creator() {
	return Arts::LittleStereoMixerChannel_base::_create();
}

unsigned long Arts::LittleStereoMixerChannel_base::_IID = Arts::MCOPUtils::makeIID("Arts::LittleStereoMixerChannel");

Arts::LittleStereoMixerChannelGuiFactory_base *Arts::LittleStereoMixerChannelGuiFactory_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	Arts::LittleStereoMixerChannelGuiFactory_base *castedObject = (Arts::LittleStereoMixerChannelGuiFactory_base *)skel->_cast(Arts::LittleStereoMixerChannelGuiFactory_base::_IID);
	assert(castedObject);
	return castedObject;
}

Arts::LittleStereoMixerChannelGuiFactory_base *Arts::LittleStereoMixerChannelGuiFactory_base::_fromString(const std::string& objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return Arts::LittleStereoMixerChannelGuiFactory_base::_fromReference(r,true);
	return 0;
}

Arts::LittleStereoMixerChannelGuiFactory_base *Arts::LittleStereoMixerChannelGuiFactory_base::_fromDynamicCast(const Arts::Object& object)
{
	if(object.isNull()) return 0;

	Arts::LittleStereoMixerChannelGuiFactory_base *castedObject = (Arts::LittleStereoMixerChannelGuiFactory_base *)object._base()->_cast(Arts::LittleStereoMixerChannelGuiFactory_base::_IID);
	if(castedObject) return castedObject->_copy();

	return _fromString(object._toString());
}

Arts::LittleStereoMixerChannelGuiFactory_base *Arts::LittleStereoMixerChannelGuiFactory_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	Arts::LittleStereoMixerChannelGuiFactory_base *result;
	result = (Arts::LittleStereoMixerChannelGuiFactory_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"Arts::LittleStereoMixerChannelGuiFactory");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new Arts::LittleStereoMixerChannelGuiFactory_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("Arts::LittleStereoMixerChannelGuiFactory")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> Arts::LittleStereoMixerChannelGuiFactory_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> Arts::LittleStereoMixerChannelGuiFactory_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *Arts::LittleStereoMixerChannelGuiFactory_base::_cast(unsigned long iid)
{
	if(iid == Arts::LittleStereoMixerChannelGuiFactory_base::_IID) return (Arts::LittleStereoMixerChannelGuiFactory_base *)this;
	if(iid == Arts::GuiFactory_base::_IID) return (Arts::GuiFactory_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

Arts::LittleStereoMixerChannelGuiFactory_stub::LittleStereoMixerChannelGuiFactory_stub()
{
	// constructor for subclasses (don't use directly)
}

Arts::LittleStereoMixerChannelGuiFactory_stub::LittleStereoMixerChannelGuiFactory_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

std::string Arts::LittleStereoMixerChannelGuiFactory_skel::_interfaceName()
{
	return "Arts::LittleStereoMixerChannelGuiFactory";
}

bool Arts::LittleStereoMixerChannelGuiFactory_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "Arts::LittleStereoMixerChannelGuiFactory") return true;
	if (interfacename == "Arts::GuiFactory") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string Arts::LittleStereoMixerChannelGuiFactory_skel::_interfaceNameSkel()
{
	return "Arts::LittleStereoMixerChannelGuiFactory";
}

void Arts::LittleStereoMixerChannelGuiFactory_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:",
		"MethodTable"
	);
	Arts::GuiFactory_skel::_buildMethodTable();
}

Arts::LittleStereoMixerChannelGuiFactory_skel::LittleStereoMixerChannelGuiFactory_skel()
{
}

Arts::Object_base* Arts::LittleStereoMixerChannelGuiFactory::_Creator() {
	return Arts::LittleStereoMixerChannelGuiFactory_base::_create();
}

unsigned long Arts::LittleStereoMixerChannelGuiFactory_base::_IID = Arts::MCOPUtils::makeIID("Arts::LittleStereoMixerChannelGuiFactory");

static Arts::IDLFileReg IDLFileReg_artsmodulesmixers("artsmodulesmixers",
    "IDLFile:000000010000000000000000000000000700000019417274733a3a53696d70"
    "6c654d697865724368616e6e656c000000000100000020417274733a3a456e7669726f"
    "6e6d656e743a3a4d697865724368616e6e656c0000000000000000080000000e657175"
    "616c697a65724c656674000000001a417274733a3a53796e74685f5354445f45515541"
    "4c495a45520000000012000000000000000f657175616c697a65725269676874000000"
    "001a417274733a3a53796e74685f5354445f455155414c495a45520000000012000000"
    "000000000e696e73657274456666656374730000000018417274733a3a53746572656f"
    "456666656374537461636b000000001200000000000000096761696e4c656674000000"
    "0006666c6f61740000000013000000000000000a6761696e5269676874000000000666"
    "6c6f61740000000013000000000000000470616e0000000006666c6f61740000000013"
    "000000000000000b766f6c756d654c6566740000000006666c6f617400000000130000"
    "00000000000c766f6c756d6552696768740000000006666c6f61740000000013000000"
    "00000000000000000000000023417274733a3a53696d706c654d697865724368616e6e"
    "656c477569466163746f7279000000000100000011417274733a3a477569466163746f"
    "727900000000000000000000000000000000000000001d417274733a3a4d6f6e6f5369"
    "6d706c654d697865724368616e6e656c000000000100000020417274733a3a456e7669"
    "726f6e6d656e743a3a4d697865724368616e6e656c0000000000000000050000000a65"
    "7175616c697a6572000000001a417274733a3a53796e74685f5354445f455155414c49"
    "5a45520000000012000000000000000e696e7365727445666665637473000000001841"
    "7274733a3a53746572656f456666656374537461636b00000000120000000000000005"
    "6761696e0000000006666c6f61740000000013000000000000000470616e0000000006"
    "666c6f617400000000130000000000000007766f6c756d650000000006666c6f617400"
    "0000001300000000000000000000000000000027417274733a3a4d6f6e6f53696d706c"
    "654d697865724368616e6e656c477569466163746f7279000000000100000011417274"
    "733a3a477569466163746f727900000000000000000000000000000000000000001441"
    "7274733a3a53796e74685f4155585f425553000000000100000012417274733a3a5379"
    "6e74684d6f64756c65000000000000000003000000066c6576656c0000000006666c6f"
    "6174000000001300000000000000086368616e6e656c00000000056c6f6e6700000000"
    "130000000000000008696e76616c75650000000006666c6f6174000000000900000000"
    "00000000000000000000001f417274733a3a4c6974746c6553746572656f4d69786572"
    "4368616e6e656c000000000100000020417274733a3a456e7669726f6e6d656e743a3a"
    "4d697865724368616e6e656c00000000000000000200000007766f6c756d6500000000"
    "06666c6f61740000000013000000000000000862616c616e63650000000006666c6f61"
    "74000000001300000000000000000000000000000029417274733a3a4c6974746c6553"
    "746572656f4d697865724368616e6e656c477569466163746f72790000000001000000"
    "11417274733a3a477569466163746f7279000000000000000000000000000000000000"
    "000000"
);
