// File autogenerated

#if !defined(NETWORKMANAGERPROXY_H_INCLUDED)
#define NETWORKMANAGERPROXY_H_INCLUDED

// TQt includes
#include <tqmap.h>
#include <tqobject.h>

// TQt D-Bus includes
#include <tqdbuserror.h>

// forward declarations
class TQString;
class TQT_DBusConnection;
class TQT_DBusDataList;
class TQT_DBusError;
class TQT_DBusMessage;
class TQT_DBusObjectPath;
class TQT_DBusProxy;
class TQT_DBusVariant;
template <typename K> class TQT_DBusDataMap;
template <typename T> class TQValueList;

namespace DBus
{

class NetworkManagerProxy : public TQObject
{
    TQ_OBJECT
    
public:
    NetworkManagerProxy(const TQString& service, const TQString& path, TQObject* parent = 0, const char* name = 0);

    virtual ~NetworkManagerProxy();

    void setConnection(const TQT_DBusConnection& connection);

signals:
    void AsyncErrorResponseDetected(int asyncCallId, const TQT_DBusError error);

    void CheckPermissions();

    void StateChanged(TQ_UINT32 state);

    void PropertiesChanged(const TQMap< TQString, TQT_DBusVariant >& properties);

    void DeviceAdded(const TQT_DBusObjectPath& device_path);

    void DeviceRemoved(const TQT_DBusObjectPath& device_path);

    void ActivateConnectionAsyncReply(int asyncCallId, const TQT_DBusObjectPath& active_connection);

    void AddAndActivateConnectionAsyncReply(int asyncCallId, const TQT_DBusObjectPath& path, const TQT_DBusObjectPath& active_connection);

    void DeactivateConnectionAsyncReply(int asyncCallId);

    void SleepAsyncReply(int asyncCallId);

    void EnableAsyncReply(int asyncCallId);

    void GetPermissionsAsyncReply(int asyncCallId, const TQMap< TQString, TQString >& permissions);


public:
    virtual bool GetDevices(TQValueList< TQT_DBusObjectPath >& devices, TQT_DBusError& error);

    virtual bool GetDeviceByIpIface(const TQString& iface, TQT_DBusObjectPath& device, TQT_DBusError& error);

    virtual bool SetLogging(const TQString& level, const TQString& domains, TQT_DBusError& error);

    virtual bool state(TQ_UINT32& state, TQT_DBusError& error);

    virtual bool ActivateConnectionAsync(int& asyncCallId, const TQT_DBusObjectPath& connection, const TQT_DBusObjectPath& device, const TQT_DBusObjectPath& specific_object, TQT_DBusError& error);

    virtual bool AddAndActivateConnectionAsync(int& asyncCallId, const TQT_DBusDataMap< TQString >& connection, const TQT_DBusObjectPath& device, const TQT_DBusObjectPath& specific_object, TQT_DBusError& error);

    virtual bool DeactivateConnectionAsync(int& asyncCallId, const TQT_DBusObjectPath& active_connection, TQT_DBusError& error);

    virtual bool SleepAsync(int& asyncCallId, bool sleep, TQT_DBusError& error);

    virtual bool EnableAsync(int& asyncCallId, bool enable, TQT_DBusError& error);

    virtual bool GetPermissionsAsync(int& asyncCallId, TQT_DBusError& error);

public:
    virtual void setDBusProperty(const TQString& name, const TQT_DBusVariant& variant, TQT_DBusError& error);
    virtual TQT_DBusVariant getDBusProperty(const TQString& name, TQT_DBusError& error) const;

    virtual bool getNetworkingEnabled(TQT_DBusError& error) const;

    virtual void setWirelessEnabled(bool value, TQT_DBusError& error);
    virtual bool getWirelessEnabled(TQT_DBusError& error) const;

    virtual bool getWirelessHardwareEnabled(TQT_DBusError& error) const;

    virtual void setWwanEnabled(bool value, TQT_DBusError& error);
    virtual bool getWwanEnabled(TQT_DBusError& error) const;

    virtual bool getWwanHardwareEnabled(TQT_DBusError& error) const;

    virtual void setWimaxEnabled(bool value, TQT_DBusError& error);
    virtual bool getWimaxEnabled(TQT_DBusError& error) const;

    virtual bool getWimaxHardwareEnabled(TQT_DBusError& error) const;

    virtual TQValueList< TQT_DBusObjectPath > getActiveConnections(TQT_DBusError& error) const;

    virtual TQString getVersion(TQT_DBusError& error) const;

    virtual TQ_UINT32 getState(TQT_DBusError& error) const;

protected slots: // usually no need to reimplement
    virtual void slotHandleDBusSignal(const TQT_DBusMessage& message);

    virtual void slotHandleAsyncReply(int id, const TQT_DBusMessage& message);

protected:
    TQT_DBusProxy* m_baseProxy;

    TQMap<int, TQString> m_asyncCalls;

private: // Hiding copy constructor and assignment operator
    NetworkManagerProxy(const NetworkManagerProxy&);
    NetworkManagerProxy& operator=(const NetworkManagerProxy&);
}; // class NetworkManagerProxy

}; // namespace DBus

#endif //NETWORKMANAGERPROXY_H_INCLUDED

// End of File

