// This file is generated by tdeconfig_compiler from kreversi.kcfg.
// All changes you do to this file will be lost.
#ifndef PREFS_H
#define PREFS_H

#include <tdeconfigskeleton.h>
#include <kdebug.h>

#include <kstandarddirs.h>
#include <tdeglobal.h>
class Prefs : public TDEConfigSkeleton
{
  public:

    static Prefs *self();
    ~Prefs();


    /**
      Get Whether to use a grayscale board instead of colored.
    */
    static
    bool grayscale()
    {
      return self()->mGrayscale;
    }


    /**
      Get The human color.
    */
    static
    int humanColor()
    {
      return self()->mHumanColor;
    }


    /**
      Get The computer color.
    */
    static
    int computerColor()
    {
      return self()->mComputerColor;
    }


    /**
      Get Whether to use animations.
    */
    static
    bool animation()
    {
      return self()->mAnimation;
    }


    /**
      Get The speed of the animations.
    */
    static
    int animationSpeed()
    {
      return self()->mAnimationSpeed;
    }

    /**
      Set The zoom factor of the board.
    */
    static
    void setZoom( int v )
    {
      if (v < 10)
      {
        kdDebug() << "setZoom: value " << v << " is less than the minimum value of 10" << endl;
        v = 10;
      }

      if (v > 300)
      {
        kdDebug() << "setZoom: value " << v << " is greater than the maximum value of 300" << endl;
        v = 300;
      }

      if (!self()->isImmutable( TQString::fromLatin1( "Zoom" ) ))
        self()->mZoom = v;
    }

    /**
      Get The zoom factor of the board.
    */
    static
    int zoom()
    {
      return self()->mZoom;
    }


    /**
      Get Whether to play competitively in contrast to casually.
    */
    static
    bool competitiveGameChoice()
    {
      return self()->mCompetitiveGameChoice;
    }

    /**
      Set The strength of the computer player.
    */
    static
    void setSkill( int v )
    {
      if (v < 1)
      {
        kdDebug() << "setSkill: value " << v << " is less than the minimum value of 1" << endl;
        v = 1;
      }

      if (v > 7)
      {
        kdDebug() << "setSkill: value " << v << " is greater than the maximum value of 7" << endl;
        v = 7;
      }

      if (!self()->isImmutable( TQString::fromLatin1( "skill" ) ))
        self()->mSkill = v;
    }

    /**
      Get The strength of the computer player.
    */
    static
    int skill()
    {
      return self()->mSkill;
    }


    /**
      Get Whether to use a background image.
    */
    static
    bool backgroundImageChoice()
    {
      return self()->mBackgroundImageChoice;
    }


    /**
      Get The background color to use.
    */
    static
    TQColor backgroundColor()
    {
      return self()->mBackgroundColor;
    }


    /**
      Get Image to use as background.
    */
    static
    TQString backgroundImage()
    {
      return self()->mBackgroundImage;
    }

    /**
      Set Whether the menubar is visible.
    */
    static
    void setMenubarVisible( bool v )
    {
      if (!self()->isImmutable( TQString::fromLatin1( "MenubarVisible" ) ))
        self()->mMenubarVisible = v;
    }

    /**
      Get Whether the menubar is visible.
    */
    static
    bool menubarVisible()
    {
      return self()->mMenubarVisible;
    }

    static
    void writeConfig()
    {
      static_cast<TDEConfigSkeleton*>(self())->writeConfig();
    }
  protected:
    Prefs();
    static Prefs *mSelf;


    // Game
    bool mGrayscale;
    int mHumanColor;
    int mComputerColor;
    bool mAnimation;
    int mAnimationSpeed;
    int mZoom;
    bool mCompetitiveGameChoice;
    int mSkill;
    bool mBackgroundImageChoice;
    TQColor mBackgroundColor;
    TQString mBackgroundImage;
    bool mMenubarVisible;

  private:
};

#endif

