// File autogenerated

// declaration include
#include "filetransfer1Proxy.h"

// TQt includes
#include <tqmap.h>
#include <tqstring.h>

// TQt D-Bus includes
#include <tqdbusdata.h>
#include <tqdbusdatalist.h>
#include <tqdbusdatamap.h>
#include <tqdbuserror.h>
#include <tqdbusmessage.h>
#include <tqdbusobjectpath.h>
#include <tqdbusproxy.h>
#include <tqdbusvariant.h>


namespace org
{
namespace bluez
{
namespace obex
{

FileTransfer1Proxy::FileTransfer1Proxy(const TQString& service, const TQString& path, TQObject* parent, const char* name)
    : TQObject(parent, name),
      m_baseProxy(new TQT_DBusProxy())
{
    m_baseProxy->setInterface("org.bluez.obex.FileTransfer1");
    m_baseProxy->setPath(path);
    m_baseProxy->setService(service);

}

FileTransfer1Proxy::~FileTransfer1Proxy()
{
    delete m_baseProxy;
}

void FileTransfer1Proxy::setConnection(const TQT_DBusConnection& connection)
{
    m_baseProxy->setConnection(connection);
}

bool FileTransfer1Proxy::ChangeFolder(const TQString& folder, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromString(folder);

    TQT_DBusMessage reply = m_baseProxy->sendWithReply("ChangeFolder", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;
    return true;
}

bool FileTransfer1Proxy::CreateFolder(const TQString& folder, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromString(folder);

    TQT_DBusMessage reply = m_baseProxy->sendWithReply("CreateFolder", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;
    return true;
}

bool FileTransfer1Proxy::ListFolder(TQT_DBusDataList& folderinfo, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;


    TQT_DBusMessage reply = m_baseProxy->sendWithReply("ListFolder", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;

    if (reply.count() != 1) return false;

    bool ok = false;

    folderinfo = reply.front().toList(&ok);
    if (!ok) return false;

    return true;
}

bool FileTransfer1Proxy::GetFile(const TQString& targetfile, const TQString& sourcefile, TQT_DBusObjectPath& transfer, TQMap< TQString, TQT_DBusVariant >& properties, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromString(targetfile);
    parameters << TQT_DBusData::fromString(sourcefile);

    TQT_DBusMessage reply = m_baseProxy->sendWithReply("GetFile", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;

    if (reply.count() != 2) return false;

    bool ok = false;

    transfer = reply.front().toObjectPath(&ok);
    if (!ok) return false;

    reply.pop_front();

    bool subOK = false;

    properties = reply.front().toStringKeyMap(&ok).toVariantMap(&subOK);
    if (!subOK) return false;
    if (!ok) return false;

    return true;
}

bool FileTransfer1Proxy::PutFile(const TQString& sourcefile, const TQString& targetfile, TQT_DBusObjectPath& transfer, TQMap< TQString, TQT_DBusVariant >& properties, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromString(sourcefile);
    parameters << TQT_DBusData::fromString(targetfile);

    TQT_DBusMessage reply = m_baseProxy->sendWithReply("PutFile", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;

    if (reply.count() != 2) return false;

    bool ok = false;

    transfer = reply.front().toObjectPath(&ok);
    if (!ok) return false;

    reply.pop_front();

    bool subOK = false;

    properties = reply.front().toStringKeyMap(&ok).toVariantMap(&subOK);
    if (!subOK) return false;
    if (!ok) return false;

    return true;
}

bool FileTransfer1Proxy::CopyFile(const TQString& sourcefile, const TQString& targetfile, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromString(sourcefile);
    parameters << TQT_DBusData::fromString(targetfile);

    TQT_DBusMessage reply = m_baseProxy->sendWithReply("CopyFile", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;
    return true;
}

bool FileTransfer1Proxy::MoveFile(const TQString& sourcefile, const TQString& targetfile, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromString(sourcefile);
    parameters << TQT_DBusData::fromString(targetfile);

    TQT_DBusMessage reply = m_baseProxy->sendWithReply("MoveFile", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;
    return true;
}

bool FileTransfer1Proxy::Delete(const TQString& file, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromString(file);

    TQT_DBusMessage reply = m_baseProxy->sendWithReply("Delete", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;
    return true;
}

}; // namespace obex

}; // namespace bluez

}; // namespace org

#include "filetransfer1Proxy.moc"

// End of File

