// File autogenerated

#if !defined(DEVICE1PROXY_H_INCLUDED)
#define DEVICE1PROXY_H_INCLUDED

// TQt includes
#include <tqmap.h>
#include <tqobject.h>

// TQt D-Bus includes
#include <tqdbuserror.h>

// forward declarations
class TQString;
class TQStringList;
class TQT_DBusConnection;
class TQT_DBusError;
class TQT_DBusMessage;
class TQT_DBusObjectPath;
class TQT_DBusProxy;
class TQT_DBusVariant;

namespace org
{
namespace bluez
{

class Device1Proxy : public TQObject
{
    TQ_OBJECT
    
public:
    Device1Proxy(const TQString& service, const TQString& path, TQObject* parent = 0, const char* name = 0);

    virtual ~Device1Proxy();

    void setConnection(const TQT_DBusConnection& connection);

signals:
    void AsyncErrorResponseDetected(int asyncCallId, const TQT_DBusError error);

    void DisconnectAsyncReply(int asyncCallId);

    void ConnectAsyncReply(int asyncCallId);

    void ConnectProfileAsyncReply(int asyncCallId);

    void DisconnectProfileAsyncReply(int asyncCallId);

    void PairAsyncReply(int asyncCallId);

    void CancelPairingAsyncReply(int asyncCallId);


public:
    virtual bool DisconnectAsync(int& asyncCallId, TQT_DBusError& error);

    virtual bool ConnectAsync(int& asyncCallId, TQT_DBusError& error);

    virtual bool ConnectProfileAsync(int& asyncCallId, const TQString& UUID, TQT_DBusError& error);

    virtual bool DisconnectProfileAsync(int& asyncCallId, const TQString& UUID, TQT_DBusError& error);

    virtual bool PairAsync(int& asyncCallId, TQT_DBusError& error);

    virtual bool CancelPairingAsync(int& asyncCallId, TQT_DBusError& error);

public:
    virtual void setDBusProperty(const TQString& name, const TQT_DBusVariant& variant, TQT_DBusError& error);
    virtual TQT_DBusVariant getDBusProperty(const TQString& name, TQT_DBusError& error) const;

    virtual TQString getAddress(TQT_DBusError& error) const;

    virtual TQString getName(TQT_DBusError& error) const;

    virtual void setAlias(const TQString& value, TQT_DBusError& error);
    virtual TQString getAlias(TQT_DBusError& error) const;

    virtual TQ_UINT32 getClass(TQT_DBusError& error) const;

    virtual TQ_UINT16 getAppearance(TQT_DBusError& error) const;

    virtual TQString getIcon(TQT_DBusError& error) const;

    virtual bool getPaired(TQT_DBusError& error) const;

    virtual void setTrusted(bool value, TQT_DBusError& error);
    virtual bool getTrusted(TQT_DBusError& error) const;

    virtual void setBlocked(bool value, TQT_DBusError& error);
    virtual bool getBlocked(TQT_DBusError& error) const;

    virtual bool getLegacyPairing(TQT_DBusError& error) const;

    virtual TQ_INT16 getRSSI(TQT_DBusError& error) const;

    virtual bool getConnected(TQT_DBusError& error) const;

    virtual TQStringList getUUIDs(TQT_DBusError& error) const;

    virtual TQString getModalias(TQT_DBusError& error) const;

    virtual TQT_DBusObjectPath getAdapter(TQT_DBusError& error) const;

    virtual TQMap< TQ_UINT16, TQT_DBusVariant > getManufacturerData(TQT_DBusError& error) const;

    virtual TQMap< TQString, TQT_DBusVariant > getServiceData(TQT_DBusError& error) const;

    virtual TQ_INT16 getTxPower(TQT_DBusError& error) const;

    virtual bool getServicesResolved(TQT_DBusError& error) const;

protected slots: // usually no need to reimplement
    virtual void slotHandleAsyncReply(int id, const TQT_DBusMessage& message);

protected:
    TQT_DBusProxy* m_baseProxy;

    TQMap<int, TQString> m_asyncCalls;

private: // Hiding copy constructor and assignment operator
    Device1Proxy(const Device1Proxy&);
    Device1Proxy& operator=(const Device1Proxy&);
}; // class Device1Proxy

}; // namespace bluez

}; // namespace org

#endif //DEVICE1PROXY_H_INCLUDED

// End of File

