/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2006-09-28
 * Description : a widget to display a GPS web map locator.
 *
 * Copyright (C) 2006-2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 * Copyright 2008 by Gerhard Kulzer <gerhard at kulzer dot net>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef GPSMAPWIDGET_H
#define GPSMAPWIDGET_H

// TQt includes.

#include <tqstring.h>

// KDE includes.

#include <tdehtml_part.h>

namespace KIPIGPSSyncPlugin
{

class GPSMapWidgetPrivate;

class GPSMapWidget : public TDEHTMLPart
{
    TQ_OBJECT
  

public:

    GPSMapWidget(TQWidget* parent);
    ~GPSMapWidget();

    void    setGPSPosition(const TQString& lat, const TQString& lon);

    void    setZoomLevel(int zoomLevel);
    int     zoomLevel();

    void    setMapType(const TQString& mapType);
    TQString mapType();

    void    setFileName(const TQString& fileName);
    TQString fileName();

    void    resized();

signals:

    void signalNewGPSLocationFromMap(const TQString&, const TQString&, const TQString&);

protected:

    void tdehtmlMouseMoveEvent(tdehtml::MouseMoveEvent*);
    void tdehtmlMouseReleaseEvent(tdehtml::MouseReleaseEvent *);

private:

    void extractGPSPositionfromStatusbar(const TQString& txt);

private:

    GPSMapWidgetPrivate *d;
};

}  // namespace KIPIGPSSyncPlugin

#endif /* GPSMAPWIDGET_H */
