// Code generated by re2go, DO NOT EDIT.
//line "go/submatch/02_mtags.re":1
//go:generate re2go $INPUT -o $OUTPUT --api simple
package main

import "reflect"

const (
	mtagRoot int = -1
	tagNone int = -1
)

// An m-tag tree is a way to store histories with an O(1) copy operation.
// Histories naturally form a tree, as they have common start and fork at some
// point. The tree is stored as an array of pairs (tag value, link to parent).
// An m-tag is represented with a single link in the tree (array index).
type mtagElem struct {
	elem int
	pred int
}
type mtagTrie = []mtagElem

type Ver = []int // unbounded number of version components

func s2n(s string) int { // convert pre-parsed string to a number
	n := 0
	for _, c := range s { n = n*10 + int(c-'0') }
	return n
}

// Append a single value to an m-tag history.
func add_mtag(trie *mtagTrie, mtag int, value int) int {
	*trie = append(*trie, mtagElem{value, mtag})
	return len(*trie) - 1
}

// Recursively unwind tag histories and collect version components.
func unwind(trie mtagTrie, x int, y int, str string) Ver {
	// Reached the root of the m-tag tree, stop recursion.
	if x == mtagRoot && y == mtagRoot {
		return []int{}
	}

	// Unwind history further.
	ver := unwind(trie, trie[x].pred, trie[y].pred, str)

	// Get tag values. Tag histories must have equal length.
	if x == mtagRoot || y == mtagRoot {
		panic("tag histories have different length")
	}
	ex := trie[x].elem
	ey := trie[y].elem

	if ex != tagNone && ey != tagNone {
		// Both tags are valid string indices, extract component.
		ver = append(ver, s2n(str[ex:ey]))
	} else if !(ex == tagNone && ey == tagNone) {
		panic("both tags should be tagNone")
	}
	return ver
}

func parse(yyinput string) []int {
	var yycursor, yymarker int
	trie := make([]mtagElem, 0)

	// Final tag variables available in semantic action.
	
//line "go/submatch/02_mtags.go":70
var t1 int;var t2 int;
//line "go/submatch/02_mtags.re":66

	
//line "go/submatch/02_mtags.go":75
var t3 int;var t4 int;
//line "go/submatch/02_mtags.re":67


	// Intermediate tag variables used by the lexer (must be autogenerated).
	
//line "go/submatch/02_mtags.go":82
var yyt1 int
	var yyt2 int
//line "go/submatch/02_mtags.re":70

	
//line "go/submatch/02_mtags.go":88
	yytm3 := mtagRoot
	yytm4 := mtagRoot
//line "go/submatch/02_mtags.re":71


	
//line "go/submatch/02_mtags.go":95
{
	var yych byte
	yych = yyinput[yycursor]
	switch (yych) {
	case '0','1','2','3','4','5','6','7','8','9':
		yyt1 = yycursor
		goto yy3
	default:
		goto yy1
	}
yy1:
	yycursor += 1
yy2:
//line "go/submatch/02_mtags.re":88
	{ return nil }
//line "go/submatch/02_mtags.go":111
yy3:
	yycursor += 1
	yymarker = yycursor
	yych = yyinput[yycursor]
	switch (yych) {
	case 0x00:
		yytm4 = add_mtag(&trie, yytm4, tagNone)
		yytm3 = add_mtag(&trie, yytm3, tagNone)
		yyt2 = yycursor
		goto yy4
	case '.':
		yyt2 = yycursor
		goto yy5
	case '0','1','2','3','4','5','6','7','8','9':
		goto yy7
	default:
		goto yy2
	}
yy4:
	yycursor += 1
	t1 = yyt1
	t2 = yyt2
	t3 = yytm3
	t4 = yytm4
//line "go/submatch/02_mtags.re":82
	{
			ver := make([]int, 0)
			ver = append(ver, s2n(yyinput[t1:t2]))
			ver = append(ver, unwind(trie, t3, t4, yyinput)...)
			return ver
		}
//line "go/submatch/02_mtags.go":143
yy5:
	yycursor += 1
	yych = yyinput[yycursor]
	switch (yych) {
	case '0','1','2','3','4','5','6','7','8','9':
		yytm3 = add_mtag(&trie, yytm3, yycursor)
		goto yy8
	default:
		goto yy6
	}
yy6:
	yycursor = yymarker
	goto yy2
yy7:
	yycursor += 1
	yych = yyinput[yycursor]
	switch (yych) {
	case 0x00:
		yytm4 = add_mtag(&trie, yytm4, tagNone)
		yytm3 = add_mtag(&trie, yytm3, tagNone)
		yyt2 = yycursor
		goto yy4
	case '.':
		yyt2 = yycursor
		goto yy5
	case '0','1','2','3','4','5','6','7','8','9':
		goto yy7
	default:
		goto yy6
	}
yy8:
	yycursor += 1
	yych = yyinput[yycursor]
	switch (yych) {
	case 0x00:
		yytm4 = add_mtag(&trie, yytm4, yycursor)
		goto yy4
	case '.':
		yytm4 = add_mtag(&trie, yytm4, yycursor)
		goto yy5
	case '0','1','2','3','4','5','6','7','8','9':
		goto yy8
	default:
		goto yy6
	}
}
//line "go/submatch/02_mtags.re":89

}

func main() {
	assert_eq := func(x, y []int) {
		if !reflect.DeepEqual(x, y) { panic("error") }
	}
	assert_eq(parse("1\000"), []int{1})
	assert_eq(parse("1.2.3.4.5.6.7\000"), []int{1, 2, 3, 4, 5, 6, 7})
	assert_eq(parse("1.\000"), nil)
}
