context("ion")

test_that("ion returns the correct value", {
  skip_on_cran()
  vcr::use_cassette("ion", {
    aa <- ion(155166)
    bb <- ion(298678)
    cc <- ion(4796748) # ursus americanus
    dd <- ion(1280626) # puma concolor
  })

  expect_is(aa, 'data.frame')
  expect_is(bb, 'data.frame')
  expect_is(cc, 'data.frame')
  expect_is(dd, 'data.frame')

  expect_named(aa, c('identifier', 'title', 'namecomplete'))
})

test_that("ion fails well", {
  skip_on_cran()
  vcr::use_cassette("ion_fails_well", {
    expect_error(ion(2343434434434), class = "error")
    expect_error(ion("asdfasfs"), class = "error")
  })
  
  skip_on_cran()
  expect_error(ion(), "argument \"x\" is missing")
})
