% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{s2_data_tbl_countries}
\alias{s2_data_tbl_countries}
\alias{s2_data_tbl_timezones}
\alias{s2_data_tbl_cities}
\alias{s2_data_countries}
\alias{s2_data_timezones}
\alias{s2_data_cities}
\title{Low-resolution world boundaries, timezones, and cities}
\format{
A data.frame with columns \code{name} (character), and
\code{geometry} (wk_wkb)

An object of class \code{data.frame} with 120 rows and 2 columns.

An object of class \code{data.frame} with 243 rows and 3 columns.
}
\source{
\href{https://www.naturalearthdata.com/}{Natural Earth Data}
}
\usage{
s2_data_tbl_countries

s2_data_tbl_timezones

s2_data_tbl_cities

s2_data_countries(name = NULL)

s2_data_timezones(utc_offset_min = NULL, utc_offset_max = utc_offset_min)

s2_data_cities(name = NULL)
}
\arguments{
\item{name}{The name of a country, continent, city, or \code{NULL}
for all features.}

\item{utc_offset_min, utc_offset_max}{Minimum and/or maximum timezone
offsets.}
}
\description{
Well-known binary versions of the \href{https://www.naturalearthdata.com/}{Natural Earth}
low-resolution world boundaries and timezone boundaries.
}
\examples{
head(s2_data_countries())
s2_data_countries("Germany")
s2_data_countries("Europe")

head(s2_data_timezones())
s2_data_timezones(-4)

head(s2_data_cities())
s2_data_cities("Cairo")

}
\keyword{datasets}
