\name{schmid}
\alias{schmid}
\title{Apply the Schmid Leiman transformation to a correlation matrix}
\description{One way to find omega is to do a factor analysis of the original data set, rotate the factors obliquely, do a Schmid Leiman transformation, and then find omega. Here is the code for Schmid Leiman.  The S-L transform takes a factor or PC solution, transforms it to an oblique solution, factors the oblique solution to find a higher order (g ) factor, and then residualizes g out of the the group factors.

}
\usage{
schmid(model, nfactors = 3, fm = "minres",digits=2,rotate="oblimin",
            n.obs=NA,option="equal",Phi=NULL,covar=FALSE,...)
}

\arguments{
  \item{model}{ A correlation matrix }
  \item{nfactors}{ Number of factors to extract }
  \item{fm}{the default is to do minres. fm="pa" for principal axes, fm="pc" for principal components, fm = "minres" for minimum residual (OLS), pc="ml" for maximum likelihood }
  \item{digits}{if digits not equal NULL, rounds to digits}
  \item{rotate}{The default, oblimin, produces somewhat more correlated factors than the alternative, simplimax. Other options include Promax (not Kaiser normalized) or promax (Promax with Kaiser normalization).  See \code{\link{fa}} for possible oblique rotations.}
  \item{n.obs}{Number of observations, used to find fit statistics if specified.  Will be calculated if input is raw data}
  \item{option}{When asking for just two group factors, option can be for "equal", "first" or "second"}
  \item{Phi}{If Phi is specified, then the analysis is done on a pattern matrix with the associated factor intercorrelation (Phi) matrix. This allows for reanalysess of published results}
  \item{covar}{Defaults to FALSE and finds correlations.  If set to TRUE, then do the calculations on the unstandardized variables.}
  \item{...}{Allows additional parameters to be passed to the factoring routines}
}
\details{Schmid Leiman orthogonalizations are typical in the ability domain, but are not seen as often in the non-cognitive personality domain.  S-L is one way of finding the loadings of items on the general factor for estimating omega. 

A typical example would be in the study of anxiety and depression.  A general neuroticism factor (g) accounts for much of the variance, but smaller group factors of tense anxiety, panic disorder, depression, etc. also need to be considerd.

An alternative model is to consider hierarchical cluster analysis techniques such as \code{\link{ICLUST}}.

Requires the GPArotation package.

Although 3 factors are the minimum number necessary to define the solution uniquely, it is occasionally useful to allow for a two factor solution.  There are three possible options for this condition: setting the general factor loadings between the two lower order factors to be "equal" which will be the sqrt(oblique correlations between the factors) or to "first" or "second" in which case the general factor is equated with either the first or second group factor. A  message is issued suggesting that the model is not really well defined. 

A diagnostic tool for testing the appropriateness of a hierarchical model is p2 which is the percent of the common variance for each variable that is general factor variance.  In general, p2 should not have much variance. 



}
\value{
  
  \item{sl }{loadings on g + nfactors group factors, communalities, uniqueness, percent of g2 of h2}
  \item{orthog }{original orthogonal factor loadings}
  \item{oblique}{oblique factor loadings}
  \item{phi }{correlations among the transformed factors}
   \item{gload }{loadings of the lower order factors on g}
  ...
}
\references{\url{https://personality-project.org/r/r.omega.html} gives an example taken from Jensen and Weng, 1994 of a S-L transformation.}
\author{ William Revelle}

\seealso{  \code{\link{omega}}, \code{\link{omega.graph}}, \code{\link{fa.graph}}, \code{\link{ICLUST}},\code{\link{VSS}}}
\examples{
jen <- sim.hierarchical()  #create a hierarchical demo
if(!require(GPArotation)) {
   message("I am sorry, you must have GPArotation installed to use schmid.")} else {
   p.jen <- schmid(jen,digits=2)   #use the oblimin rotation
p.jen <- schmid(jen,rotate="promax") #use the promax rotation
}
}
\keyword{ multivariate }% at least one, from doc/KEYWORDS
\keyword{ models }% __ONLY ONE__ keyword per line
