% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_longer.R
\name{pivot_longer}
\alias{pivot_longer}
\title{Pivot data from wide to long}
\usage{
pivot_longer(
  data,
  cols,
  names_to = "name",
  names_prefix = NULL,
  names_sep = NULL,
  names_pattern = NULL,
  values_to = "value",
  values_drop_na = FALSE,
  ...
)
}
\arguments{
\item{data}{\code{data.frame}. The data to pivot.}

\item{cols}{<\code{\link[=select_helpers]{poor-select}}>. Columns to pivot into longer format.}

\item{names_to}{\code{character(n)}. The name of the new column(s) that will contain the column names.}

\item{names_prefix}{\code{character(1)}. A regular expression used to remove matching text from the start of each variable
name.}

\item{names_sep, names_pattern}{\code{character(1)}. If \code{names_to} contains multiple values, this argument controls how the
column name is broken up. \code{names_pattern} takes a regular expression containing matching groups (\verb{()}).}

\item{values_to}{\code{character(n)}. The name of the new column(s) that will contain the values of the pivoted variables.}

\item{values_drop_na}{\code{logical(1)}. If \code{TRUE}, will drop rows that contain only \code{NA} in the \code{values_to} column. This
effectively converts explicit missing values to implicit missing values, and should generally be used only when
missing values in data were created by its structure.}

\item{...}{Additional arguments passed on to methods.}
}
\value{
A \code{data.frame}.
}
\description{
\code{pivot_longer()} "lengthens" data, increasing the number of rows and decreasing the number of columns. The inverse
transformation is \code{\link[=pivot_wider]{pivot_wider()}}.
}
\examples{
wide_data <- data.frame(replicate(5, rnorm(10)))
# Customizing the names
pivot_longer(
  data = wide_data,
  cols = c(1, 2),
  names_to = "Column",
  values_to = "Numbers"
)

}
