% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dev-help.r, R/dev-topic.r
\name{dev_help}
\alias{dev_help}
\alias{dev_topic_index_reset}
\title{In-development help for package loaded with devtools}
\usage{
dev_help(
  topic,
  dev_packages = NULL,
  stage = "render",
  type = getOption("help_type")
)

dev_topic_index_reset(pkg_name)
}
\arguments{
\item{topic}{name of help to search for.}

\item{dev_packages}{A character vector of package names to search within.
If \code{NULL}, defaults to all packages loaded by devtools.}

\item{stage}{at which stage ("build", "install", or "render") should
\verb{\\\\Sexpr} macros be executed? This is only important if you're using
\verb{\\\\Sexpr} macro's in your Rd files.}

\item{type}{of html to produce: \code{"html"} or \code{"text"}. Defaults to
your default documentation type.}

\item{pkg_name}{Name of package.}
}
\description{
\code{dev_help} searches for source documentation provided in
packages loaded by devtools. To improve performance, the \code{.Rd} files
are parsed to create to index once, then cached. Use
\code{dev_topic_index_reset} to clear that index.
}
\examples{
\dontrun{
library("ggplot2")
help("ggplot") # loads installed documentation for ggplot

load_all("ggplot2")
dev_help("ggplot") # loads development documentation for ggplot
}
}
