% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blocksample.R
\name{blocksample}
\alias{blocksample}
\alias{dsample}
\title{Block sampling}
\usage{
blocksample(data, size, idvar = NULL, replace = TRUE, ...)
}
\arguments{
\item{data}{Data frame}

\item{size}{Size of samples}

\item{idvar}{Column defining the clusters}

\item{replace}{Logical indicating wether to sample with replacement}

\item{\dots}{additional arguments to lower level functions}
}
\value{
\code{data.frame}
}
\description{
Sample blockwise from clustered data
}
\details{
Original id is stored in the attribute 'id'
}
\examples{

d <- data.frame(x=rnorm(5), z=rnorm(5), id=c(4,10,10,5,5), v=rnorm(5))
(dd <- blocksample(d,size=20,~id))
attributes(dd)$id

\dontrun{
blocksample(data.table::data.table(d),1e6,~id)
}


d <- data.frame(x=c(1,rnorm(9)),
               z=rnorm(10),
               id=c(4,10,10,5,5,4,4,5,10,5),
               id2=c(1,1,2,1,2,1,1,1,1,2),
               v=rnorm(10))
dsample(d,~id, size=2)
dsample(d,.~id+id2)
dsample(d,x+z~id|x>0,size=5)

}
\author{
Klaus K. Holst
}
\keyword{models}
\keyword{utilities}
